/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.requirement;

import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.framedblocks.FramedBlocksInSchematics;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ISpecialEntityItemRequirement;
import com.simibubi.create.foundation.utility.NBTProcessors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2185;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2344;
import net.minecraft.class_2369;
import net.minecraft.class_2472;
import net.minecraft.class_2488;
import net.minecraft.class_2542;
import net.minecraft.class_2573;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_7923;

public class ItemRequirement {
    public static final ItemRequirement NONE = new ItemRequirement(Collections.emptyList());
    public static final ItemRequirement INVALID = new ItemRequirement(Collections.emptyList());
    protected List<StackRequirement> requiredItems;

    public ItemRequirement(List<StackRequirement> requiredItems) {
        this.requiredItems = requiredItems;
    }

    public ItemRequirement(StackRequirement stackRequirement) {
        this(List.of(stackRequirement));
    }

    public ItemRequirement(ItemUseType usage, class_1799 stack) {
        this(new StackRequirement(stack, usage));
    }

    public ItemRequirement(ItemUseType usage, class_1792 item) {
        this(usage, new class_1799((class_1935)item));
    }

    public ItemRequirement(ItemUseType usage, List<class_1799> requiredItems) {
        this(requiredItems.stream().map(req -> new StackRequirement((class_1799)req, usage)).collect(Collectors.toList()));
    }

    public static ItemRequirement of(class_2680 state, class_2586 be) {
        ItemRequirement requirement;
        class_2248 block = state.method_26204();
        if (block instanceof ISpecialBlockItemRequirement) {
            ISpecialBlockItemRequirement specialBlock = (ISpecialBlockItemRequirement)block;
            requirement = specialBlock.getRequiredItems(state, be);
        } else {
            requirement = ItemRequirement.defaultOf(state, be);
        }
        if (be instanceof ISpecialBlockEntityItemRequirement) {
            ISpecialBlockEntityItemRequirement specialBE = (ISpecialBlockEntityItemRequirement)be;
            requirement = requirement.union(specialBE.getRequiredItems(state));
        }
        if (Mods.FRAMEDBLOCKS.contains((class_1935)block)) {
            requirement = requirement.union(FramedBlocksInSchematics.getRequiredItems(state, be));
        }
        return requirement;
    }

    private static ItemRequirement defaultOf(class_2680 state, class_2586 be) {
        class_2248 block = state.method_26204();
        if (block == class_2246.field_10124) {
            return NONE;
        }
        class_1792 item = block.method_8389();
        if (item == class_1802.field_8162) {
            return INVALID;
        }
        if (state.method_28498((class_2769)class_2741.field_12485) && state.method_11654((class_2769)class_2741.field_12485) == class_2771.field_12682) {
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799((class_1935)item, 2));
        }
        if (block instanceof class_2542) {
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799((class_1935)item, ((Integer)state.method_11654((class_2769)class_2542.field_11710)).intValue()));
        }
        if (block instanceof class_2472) {
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799((class_1935)item, ((Integer)state.method_11654((class_2769)class_2472.field_11472)).intValue()));
        }
        if (block instanceof class_2488) {
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799((class_1935)item, ((Integer)state.method_11654((class_2769)class_2488.field_11518)).intValue()));
        }
        if (block == class_7923.field_41175.method_10223(com.simibubi.create.foundation.data.recipe.Mods.FD.asResource("rich_soil_farmland"))) {
            return new ItemRequirement(ItemUseType.CONSUME, (class_1792)class_7923.field_41178.method_10223(com.simibubi.create.foundation.data.recipe.Mods.FD.asResource("rich_soil")));
        }
        if (block instanceof class_2344 || block instanceof class_2369) {
            return new ItemRequirement(ItemUseType.CONSUME, class_1802.field_8831);
        }
        if (block instanceof class_2185 && be instanceof class_2573) {
            class_2573 bannerBE = (class_2573)be;
            return new ItemRequirement(new StrictNbtStackRequirement(bannerBE.method_10907(), ItemUseType.CONSUME));
        }
        if (block == class_2246.field_10214) {
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799((class_1935)class_1802.field_8602, 2));
        }
        if (block == class_2246.field_10313) {
            return new ItemRequirement(ItemUseType.CONSUME, new class_1799((class_1935)class_1802.field_8471, 2));
        }
        return new ItemRequirement(ItemUseType.CONSUME, item);
    }

    public static ItemRequirement of(class_1297 entity) {
        if (entity instanceof ISpecialEntityItemRequirement) {
            ISpecialEntityItemRequirement specialEntity = (ISpecialEntityItemRequirement)entity;
            return specialEntity.getRequiredItems();
        }
        if (entity instanceof class_1533) {
            class_1533 itemFrame = (class_1533)entity;
            class_1799 frame = new class_1799((class_1935)class_1802.field_8143);
            class_1799 displayedItem = NBTProcessors.withUnsafeNBTDiscarded(itemFrame.method_6940());
            if (displayedItem.method_7960()) {
                return new ItemRequirement(ItemUseType.CONSUME, class_1802.field_8143);
            }
            return new ItemRequirement(List.of(new StackRequirement(frame, ItemUseType.CONSUME), new StrictNbtStackRequirement(displayedItem, ItemUseType.CONSUME)));
        }
        if (entity instanceof class_1531) {
            class_1531 armorStand = (class_1531)entity;
            ArrayList<StackRequirement> requirements = new ArrayList<StackRequirement>();
            requirements.add(new StackRequirement(new class_1799((class_1935)class_1802.field_8694), ItemUseType.CONSUME));
            armorStand.method_5743().forEach(s -> requirements.add(new StrictNbtStackRequirement(NBTProcessors.withUnsafeNBTDiscarded(s), ItemUseType.CONSUME)));
            return new ItemRequirement(requirements);
        }
        return INVALID;
    }

    public boolean isEmpty() {
        return NONE == this;
    }

    public boolean isInvalid() {
        return INVALID == this;
    }

    public List<StackRequirement> getRequiredItems() {
        return this.requiredItems;
    }

    public ItemRequirement union(ItemRequirement other) {
        if (this.isInvalid() || other.isInvalid()) {
            return INVALID;
        }
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return new ItemRequirement(Stream.concat(this.requiredItems.stream(), other.requiredItems.stream()).collect(Collectors.toList()));
    }

    public static class StackRequirement {
        public final class_1799 stack;
        public final ItemUseType usage;

        public StackRequirement(class_1799 stack, ItemUseType usage) {
            this.stack = stack;
            this.usage = usage;
        }

        public boolean matches(class_1799 other) {
            return class_1799.method_7984((class_1799)this.stack, (class_1799)other);
        }

        public boolean matches(ItemVariant variant) {
            return variant.getItem() == this.stack.method_7909();
        }
    }

    public static enum ItemUseType {
        CONSUME,
        DAMAGE;

    }

    public static class StrictNbtStackRequirement
    extends StackRequirement {
        public StrictNbtStackRequirement(class_1799 stack, ItemUseType usage) {
            super(stack, usage);
        }

        @Override
        public boolean matches(class_1799 other) {
            return class_1799.method_31577((class_1799)this.stack, (class_1799)other);
        }

        @Override
        public boolean matches(ItemVariant variant) {
            return variant.matches(this.stack);
        }
    }
}

