/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlock;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

public class ElevatorColumn {
    public static WorldAttached<Map<ColumnCoords, ElevatorColumn>> LOADED_COLUMNS = new WorldAttached<Map>($ -> new HashMap());
    protected class_1936 level;
    protected ColumnCoords coords;
    protected List<Integer> contacts;
    protected int targetedYLevel;
    protected boolean isActive;
    protected boolean targetAvailable;
    public int namesListVersion;

    @Nullable
    public static ElevatorColumn get(class_1936 level, ColumnCoords coords) {
        return LOADED_COLUMNS.get(level).get(coords);
    }

    public static ElevatorColumn getOrCreate(class_1936 level, ColumnCoords coords) {
        return LOADED_COLUMNS.get(level).computeIfAbsent(coords, c -> new ElevatorColumn(level, (ColumnCoords)c));
    }

    public ElevatorColumn(class_1936 level, ColumnCoords coords) {
        this.level = level;
        this.coords = coords;
        this.contacts = new ArrayList<Integer>();
        this.targetAvailable = false;
    }

    public void markDirty() {
        for (class_2338 pos : this.getContacts()) {
            class_2586 blockEntity = this.level.method_8321(pos);
            if (!(blockEntity instanceof ElevatorContactBlockEntity)) continue;
            ElevatorContactBlockEntity ecbe = (ElevatorContactBlockEntity)blockEntity;
            ecbe.method_5431();
        }
    }

    public void floorReached(class_1936 level, String name) {
        this.getContacts().stream().forEach(p -> {
            class_2586 patt2116$temp = level.method_8321(p);
            if (patt2116$temp instanceof ElevatorContactBlockEntity) {
                ElevatorContactBlockEntity ecbe = (ElevatorContactBlockEntity)patt2116$temp;
                ecbe.updateDisplayedFloor(name);
            }
        });
    }

    public List<IntAttached<Couple<String>>> compileNamesList() {
        return this.getContacts().stream().map(p -> {
            class_2586 patt2382$temp = this.level.method_8321(p);
            if (patt2382$temp instanceof ElevatorContactBlockEntity) {
                ElevatorContactBlockEntity ecbe = (ElevatorContactBlockEntity)patt2382$temp;
                return IntAttached.with(p.method_10264(), ecbe.getNames());
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public void namesChanged() {
        ++this.namesListVersion;
    }

    public Collection<class_2338> getContacts() {
        return this.contacts.stream().map(this::contactAt).toList();
    }

    public void gatherAll() {
        class_2338.method_20437((class_2338)this.contactAt(this.level.method_31607()), (class_2338)this.contactAt(this.level.method_31600())).filter(p -> this.coords.equals(ElevatorContactBlock.getColumnCoords(this.level, p))).forEach(p -> this.level.method_8652(p, BlockHelper.copyProperties(this.level.method_8320(p), AllBlocks.ELEVATOR_CONTACT.getDefaultState()), 3));
    }

    public class_2338 contactAt(int y) {
        return new class_2338(this.coords.x, y, this.coords.z);
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
        this.markDirty();
        this.checkEmpty();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void target(int yLevel) {
        this.targetedYLevel = yLevel;
        this.targetAvailable = true;
    }

    public boolean isTargetAvailable() {
        return this.targetAvailable;
    }

    public int getTargetedYLevel() {
        return this.targetedYLevel;
    }

    public void initNames(class_1937 level) {
        Integer prevLevel = null;
        for (int i = 0; i < this.contacts.size(); ++i) {
            Integer y = this.contacts.get(i);
            class_2338 pos = this.contactAt(y);
            class_2586 class_25862 = level.method_8321(pos);
            if (!(class_25862 instanceof ElevatorContactBlockEntity)) continue;
            ElevatorContactBlockEntity ecbe = (ElevatorContactBlockEntity)class_25862;
            Integer currentLevel = null;
            if (!ecbe.shortName.isBlank()) {
                Integer tryValueOf = ElevatorColumn.tryValueOf(ecbe.shortName);
                if (tryValueOf != null) {
                    currentLevel = tryValueOf;
                }
                if (currentLevel == null) continue;
            }
            if (prevLevel != null) {
                currentLevel = prevLevel + 1;
            }
            Integer nextLevel = null;
            for (int peekI = i + 1; peekI < this.contacts.size(); ++peekI) {
                class_2338 peekPos = this.contactAt(this.contacts.get(peekI));
                class_2586 class_25863 = level.method_8321(peekPos);
                if (!(class_25863 instanceof ElevatorContactBlockEntity)) continue;
                ElevatorContactBlockEntity peekEcbe = (ElevatorContactBlockEntity)class_25863;
                Integer tryValueOf = ElevatorColumn.tryValueOf(peekEcbe.shortName);
                if (tryValueOf == null) continue;
                if (currentLevel != null && currentLevel >= tryValueOf) {
                    peekEcbe.shortName = "";
                    break;
                }
                nextLevel = tryValueOf;
                break;
            }
            if (currentLevel == null) {
                currentLevel = nextLevel != null ? nextLevel - 1 : 0;
            }
            ecbe.updateName(String.valueOf(currentLevel), ecbe.longName);
            prevLevel = currentLevel;
        }
    }

    private static Integer tryValueOf(String floorName) {
        try {
            return Integer.valueOf(floorName, 10);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public void add(class_2338 contactPos) {
        int index;
        int coord = contactPos.method_10264();
        if (this.contacts.contains(coord)) {
            return;
        }
        for (index = 0; index < this.contacts.size() && this.contacts.get(index) <= coord; ++index) {
        }
        this.contacts.add(index, coord);
        this.namesChanged();
    }

    public void remove(class_2338 contactPos) {
        this.contacts.remove((Object)contactPos.method_10264());
        this.checkEmpty();
        this.namesChanged();
    }

    private void checkEmpty() {
        if (this.contacts.isEmpty() && !this.isActive()) {
            LOADED_COLUMNS.get(this.level).remove(this.coords);
        }
    }

    public record ColumnCoords(int x, int z, class_2350 side) {
        public ColumnCoords relative(class_2338 anchor) {
            return new ColumnCoords(this.x + anchor.method_10263(), this.z + anchor.method_10260(), this.side);
        }

        public class_2487 write() {
            class_2487 tag = new class_2487();
            tag.method_10569("X", this.x);
            tag.method_10569("Z", this.z);
            NBTHelper.writeEnum(tag, "Side", this.side);
            return tag;
        }

        public static ColumnCoords read(class_2487 tag) {
            int x = tag.method_10550("X");
            int z = tag.method_10550("Z");
            class_2350 side = NBTHelper.readEnum(tag, "Side", class_2350.class);
            return new ColumnCoords(x, z, side);
        }
    }
}

