/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.jozufozu.flywheel.api.MaterialManager;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.bogey.BackupBogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeyInstance;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class BogeyStyle {
    public final class_2960 name;
    public final class_2960 cycleGroup;
    public final class_2561 displayName;
    public final class_2960 soundType;
    public final class_2394 contactParticle;
    public final class_2394 smokeParticle;
    public final class_2487 defaultData;
    private Optional<Supplier<? extends BogeyRenderer.CommonRenderer>> commonRendererFactory;
    private Map<BogeySizes.BogeySize, class_2960> sizes;
    @Environment(value=EnvType.CLIENT)
    private Map<BogeySizes.BogeySize, SizeRenderData> sizeRenderers;
    @Environment(value=EnvType.CLIENT)
    private Optional<BogeyRenderer.CommonRenderer> commonRenderer;

    public BogeyStyle(class_2960 name, class_2960 cycleGroup, class_2561 displayName, class_2960 soundType, class_2394 contactParticle, class_2394 smokeParticle, class_2487 defaultData, Map<BogeySizes.BogeySize, class_2960> sizes, Map<BogeySizes.BogeySize, Supplier<SizeRenderData>> sizeRenderers, Optional<Supplier<? extends BogeyRenderer.CommonRenderer>> commonRenderer) {
        this.name = name;
        this.cycleGroup = cycleGroup;
        this.displayName = displayName;
        this.soundType = soundType;
        this.contactParticle = contactParticle;
        this.smokeParticle = smokeParticle;
        this.defaultData = defaultData;
        this.sizes = sizes;
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            this.sizeRenderers = new HashMap<BogeySizes.BogeySize, SizeRenderData>();
            sizeRenderers.forEach((k, v) -> this.sizeRenderers.put((BogeySizes.BogeySize)k, (SizeRenderData)v.get()));
            this.commonRendererFactory = commonRenderer;
            this.commonRenderer = commonRenderer.map(Supplier::get);
        });
    }

    public Map<class_2960, BogeyStyle> getCycleGroup() {
        return AllBogeyStyles.getCycleGroup(this.cycleGroup);
    }

    public class_2248 getNextBlock(BogeySizes.BogeySize currentSize) {
        return Stream.iterate(currentSize.increment(), BogeySizes.BogeySize::increment).filter(this.sizes::containsKey).findFirst().map(this::getBlockOfSize).orElse(this.getBlockOfSize(currentSize));
    }

    public class_2248 getBlockOfSize(BogeySizes.BogeySize size) {
        return (class_2248)class_7923.field_41175.method_10223(this.sizes.get(size));
    }

    public Set<BogeySizes.BogeySize> validSizes() {
        return this.sizes.keySet();
    }

    @NotNull
    public class_3414 getSoundType() {
        AllSoundEvents.SoundEntry entry = AllSoundEvents.ALL.get(this.soundType);
        if (entry == null || entry.getMainEvent() == null) {
            entry = AllSoundEvents.TRAIN2;
        }
        return entry.getMainEvent();
    }

    @Environment(value=EnvType.CLIENT)
    public BogeyRenderer createRendererInstance(BogeySizes.BogeySize size) {
        return this.sizeRenderers.get(size).createRenderInstance();
    }

    @Environment(value=EnvType.CLIENT)
    public BogeyRenderer getInWorldRenderInstance(BogeySizes.BogeySize size) {
        SizeRenderData sizeData = this.sizeRenderers.get(size);
        return sizeData != null ? sizeData.getInWorldInstance() : BackupBogeyRenderer.INSTANCE;
    }

    public Optional<BogeyRenderer.CommonRenderer> getInWorldCommonRenderInstance() {
        return this.commonRenderer;
    }

    public Optional<BogeyRenderer.CommonRenderer> getNewCommonRenderInstance() {
        return this.commonRendererFactory.map(Supplier::get);
    }

    public BogeyInstance createInstance(CarriageBogey bogey, BogeySizes.BogeySize size, MaterialManager materialManager) {
        return new BogeyInstance(bogey, this, size, materialManager);
    }

    @Environment(value=EnvType.CLIENT)
    public record SizeRenderData(Supplier<? extends BogeyRenderer> rendererFactory, BogeyRenderer instance) {
        public BogeyRenderer createRenderInstance() {
            return this.rendererFactory.get();
        }

        public BogeyRenderer getInWorldInstance() {
            return this.instance;
        }
    }
}

