/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.piston;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public abstract class LinearActuatorBlockEntity
extends KineticBlockEntity
implements IControlContraption,
IDisplayAssemblyExceptions {
    public float offset;
    public boolean running;
    public boolean assembleNextTick;
    public boolean needsContraption;
    public AbstractContraptionEntity movedContraption;
    protected boolean forceMove;
    protected ScrollOptionBehaviour<IControlContraption.MovementMode> movementMode;
    protected boolean waitingForSpeedChange;
    protected AssemblyException lastException;
    protected double sequencedOffsetLimit;
    protected float clientOffsetDiff;

    public LinearActuatorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(3);
        this.forceMove = true;
        this.needsContraption = true;
        this.sequencedOffsetLimit = -1.0;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementMode = new ScrollOptionBehaviour<IControlContraption.MovementMode>(IControlContraption.MovementMode.class, (class_2561)Lang.translateDirect("contraptions.movement_mode", new Object[0]), this, this.getMovementModeSlot());
        this.movementMode.withCallback(t -> {
            this.waitingForSpeedChange = false;
        });
        behaviours.add(this.movementMode);
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    protected boolean syncSequenceContext() {
        return true;
    }

    @Override
    public void tick() {
        float newOffset;
        boolean contraptionPresent;
        super.tick();
        if (this.movedContraption != null && !this.movedContraption.method_5805()) {
            this.movedContraption = null;
        }
        if (this.isPassive()) {
            return;
        }
        if (this.field_11863.field_9236) {
            this.clientOffsetDiff *= 0.75f;
        }
        if (this.waitingForSpeedChange) {
            if (this.movedContraption != null) {
                if (this.field_11863.field_9236) {
                    float syncSpeed = this.clientOffsetDiff / 2.0f;
                    this.offset += syncSpeed;
                    this.movedContraption.setContraptionMotion(this.toMotionVector(syncSpeed));
                    return;
                }
                this.movedContraption.setContraptionMotion(class_243.field_1353);
            }
            return;
        }
        if (!this.field_11863.field_9236 && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                if (this.getSpeed() == 0.0f) {
                    this.tryDisassemble();
                } else {
                    this.sendData();
                }
                return;
            }
            if (this.getSpeed() != 0.0f) {
                try {
                    this.assemble();
                    this.lastException = null;
                }
                catch (AssemblyException e) {
                    this.lastException = e;
                }
            }
            this.sendData();
            return;
        }
        if (!this.running) {
            return;
        }
        boolean bl = contraptionPresent = this.movedContraption != null;
        if (this.needsContraption && !contraptionPresent) {
            return;
        }
        float movementSpeed = this.getMovementSpeed();
        boolean locked = false;
        if (this.sequencedOffsetLimit > 0.0) {
            this.sequencedOffsetLimit = Math.max(0.0, this.sequencedOffsetLimit - (double)Math.abs(movementSpeed));
            boolean bl2 = locked = this.sequencedOffsetLimit == 0.0;
        }
        if ((int)(newOffset = this.offset + movementSpeed) != (int)this.offset) {
            this.visitNewPosition();
        }
        if (locked) {
            this.forceMove = true;
            this.resetContraptionToOffset();
            this.sendData();
        }
        if (contraptionPresent && this.moveAndCollideContraption()) {
            this.movedContraption.setContraptionMotion(class_243.field_1353);
            this.offset = this.getGridOffset(this.offset);
            this.resetContraptionToOffset();
            this.collided();
            return;
        }
        if (!contraptionPresent || !this.movedContraption.isStalled()) {
            this.offset = newOffset;
        }
        int extensionRange = this.getExtensionRange();
        if (this.offset <= 0.0f || this.offset >= (float)extensionRange) {
            float f = this.offset = this.offset <= 0.0f ? 0.0f : (float)extensionRange;
            if (!this.field_11863.field_9236) {
                this.moveAndCollideContraption();
                this.resetContraptionToOffset();
                this.tryDisassemble();
                if (this.waitingForSpeedChange) {
                    this.forceMove = true;
                    this.sendData();
                }
            }
            return;
        }
    }

    protected boolean isPassive() {
        return false;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && !this.field_11863.field_9236) {
            this.sendData();
        }
    }

    protected int getGridOffset(float offset) {
        return class_3532.method_15340((int)((int)(offset + 0.5f)), (int)0, (int)this.getExtensionRange());
    }

    public float getInterpolatedOffset(float partialTicks) {
        float interpolatedOffset = class_3532.method_15363((float)(this.offset + (partialTicks - 0.5f) * this.getMovementSpeed()), (float)0.0f, (float)this.getExtensionRange());
        return interpolatedOffset;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.sequencedOffsetLimit = -1.0;
        if (this.isPassive()) {
            return;
        }
        this.assembleNextTick = true;
        this.waitingForSpeedChange = false;
        if (this.movedContraption != null && Math.signum(prevSpeed) != Math.signum(this.getSpeed()) && prevSpeed != 0.0f) {
            if (!this.movedContraption.isStalled()) {
                this.offset = Math.round(this.offset * 16.0f) / 16;
                this.resetContraptionToOffset();
            }
            this.movedContraption.getContraption().stop(this.field_11863);
        }
        if (this.sequenceContext != null && this.sequenceContext.instruction() == SequencerInstructions.TURN_DISTANCE) {
            this.sequencedOffsetLimit = this.sequenceContext.getEffectiveValue(this.getTheoreticalSpeed());
        }
    }

    @Override
    public void remove() {
        this.field_11865 = true;
        if (!this.field_11863.field_9236) {
            this.disassemble();
        }
        super.remove();
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("Running", this.running);
        compound.method_10556("Waiting", this.waitingForSpeedChange);
        compound.method_10548("Offset", this.offset);
        if (this.sequencedOffsetLimit >= 0.0) {
            compound.method_10549("SequencedOffsetLimit", this.sequencedOffsetLimit);
        }
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
        if (clientPacket && this.forceMove) {
            compound.method_10556("ForceMovement", this.forceMove);
            this.forceMove = false;
        }
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        boolean forceMovement = compound.method_10545("ForceMovement");
        float offsetBefore = this.offset;
        this.running = compound.method_10577("Running");
        this.waitingForSpeedChange = compound.method_10577("Waiting");
        this.offset = compound.method_10583("Offset");
        this.sequencedOffsetLimit = compound.method_10545("SequencedOffsetLimit") ? compound.method_10574("SequencedOffsetLimit") : -1.0;
        this.lastException = AssemblyException.read(compound);
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (forceMovement) {
            this.resetContraptionToOffset();
        } else if (this.running) {
            this.clientOffsetDiff = this.offset - offsetBefore;
            this.offset = offsetBefore;
        }
        if (!this.running) {
            this.movedContraption = null;
        }
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public abstract void disassemble();

    protected abstract void assemble() throws AssemblyException;

    protected abstract int getExtensionRange();

    protected abstract int getInitialOffset();

    protected abstract ValueBoxTransform getMovementModeSlot();

    protected abstract class_243 toMotionVector(float var1);

    protected abstract class_243 toPosition(float var1);

    protected void visitNewPosition() {
    }

    protected void tryDisassemble() {
        if (this.field_11865) {
            this.disassemble();
            return;
        }
        if (this.getMovementMode() == IControlContraption.MovementMode.MOVE_NEVER_PLACE) {
            this.waitingForSpeedChange = true;
            return;
        }
        int initial = this.getInitialOffset();
        if ((int)(this.offset + 0.5f) != initial && this.getMovementMode() == IControlContraption.MovementMode.MOVE_PLACE_RETURNED) {
            this.waitingForSpeedChange = true;
            return;
        }
        this.disassemble();
    }

    protected IControlContraption.MovementMode getMovementMode() {
        return this.movementMode.get();
    }

    protected boolean moveAndCollideContraption() {
        if (this.movedContraption == null) {
            return false;
        }
        if (this.movedContraption.isStalled()) {
            this.movedContraption.setContraptionMotion(class_243.field_1353);
            return false;
        }
        class_243 motion = this.getMotionVector();
        this.movedContraption.setContraptionMotion(this.getMotionVector());
        this.movedContraption.move(motion.field_1352, motion.field_1351, motion.field_1350);
        return ContraptionCollider.collideBlocks(this.movedContraption);
    }

    protected void collided() {
        if (this.field_11863.field_9236) {
            this.waitingForSpeedChange = true;
            return;
        }
        this.offset = this.getGridOffset(this.offset - this.getMovementSpeed());
        this.resetContraptionToOffset();
        this.tryDisassemble();
    }

    protected void resetContraptionToOffset() {
        if (this.movedContraption == null) {
            return;
        }
        if (!this.movedContraption.method_5805()) {
            return;
        }
        class_243 vec = this.toPosition(this.offset);
        this.movedContraption.method_5814(vec.field_1352, vec.field_1351, vec.field_1350);
        if (this.getSpeed() == 0.0f || this.waitingForSpeedChange) {
            this.movedContraption.setContraptionMotion(class_243.field_1353);
        }
    }

    public float getMovementSpeed() {
        float movementSpeed = class_3532.method_15363((float)LinearActuatorBlockEntity.convertToLinear(this.getSpeed()), (float)-0.49f, (float)0.49f) + this.clientOffsetDiff / 2.0f;
        if (this.field_11863.field_9236) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        if (this.sequencedOffsetLimit >= 0.0) {
            movementSpeed = (float)class_3532.method_15350((double)movementSpeed, (double)(-this.sequencedOffsetLimit), (double)this.sequencedOffsetLimit);
        }
        return movementSpeed;
    }

    public class_243 getMotionVector() {
        return this.toMotionVector(this.getMovementSpeed());
    }

    @Override
    public void onStall() {
        if (!this.field_11863.field_9236) {
            this.forceMove = true;
            this.sendData();
        }
    }

    public void onLengthBroken() {
        this.offset = 0.0f;
        this.sendData();
    }

    @Override
    public boolean isValid() {
        return !this.method_11015();
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        this.movedContraption = contraption;
        if (!this.field_11863.field_9236) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    @Override
    public class_2338 getBlockPosition() {
        return this.field_11867;
    }
}

