/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.bearing.ClockworkContraption;
import com.simibubi.create.content.contraptions.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.piston.PistonContraption;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class ContraptionType {
    public static final Map<String, ContraptionType> ENTRIES = new HashMap<String, ContraptionType>();
    public static final ContraptionType PISTON = ContraptionType.register("piston", PistonContraption::new);
    public static final ContraptionType BEARING = ContraptionType.register("bearing", BearingContraption::new);
    public static final ContraptionType PULLEY = ContraptionType.register("pulley", PulleyContraption::new);
    public static final ContraptionType CLOCKWORK = ContraptionType.register("clockwork", ClockworkContraption::new);
    public static final ContraptionType MOUNTED = ContraptionType.register("mounted", MountedContraption::new);
    public static final ContraptionType STABILIZED = ContraptionType.register("stabilized", StabilizedContraption::new);
    public static final ContraptionType GANTRY = ContraptionType.register("gantry", GantryContraption::new);
    public static final ContraptionType CARRIAGE = ContraptionType.register("carriage", CarriageContraption::new);
    public static final ContraptionType ELEVATOR = ContraptionType.register("elevator", ElevatorContraption::new);
    Supplier<? extends Contraption> factory;
    String id;

    public static ContraptionType register(String id, Supplier<? extends Contraption> factory) {
        ContraptionType value = new ContraptionType(id, factory);
        ENTRIES.put(id, value);
        return value;
    }

    private ContraptionType(String id, Supplier<? extends Contraption> factory) {
        this.factory = factory;
        this.id = id;
    }

    public static Contraption fromType(String type) {
        for (Map.Entry<String, ContraptionType> allContraptionTypes : ENTRIES.entrySet()) {
            if (!type.equals(allContraptionTypes.getKey())) continue;
            return allContraptionTypes.getValue().factory.get();
        }
        return null;
    }
}

