/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.contraptions.behaviour.BellMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.CampfireMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.dispenser.DispenserMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.dispenser.DropperMovementBehaviour;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class AllMovementBehaviours {
    private static final AttachedRegistry<class_2248, MovementBehaviour> BLOCK_BEHAVIOURS = new AttachedRegistry(class_7923.field_41175);
    private static final List<BehaviourProvider> GLOBAL_BEHAVIOURS = new ArrayList<BehaviourProvider>();

    public static void registerBehaviour(class_2960 block, MovementBehaviour behaviour) {
        BLOCK_BEHAVIOURS.register((class_2248)block, behaviour);
    }

    public static void registerBehaviour(class_2248 block, MovementBehaviour behaviour) {
        BLOCK_BEHAVIOURS.register(block, behaviour);
    }

    public static void registerBehaviourProvider(BehaviourProvider provider) {
        GLOBAL_BEHAVIOURS.add(provider);
    }

    @Nullable
    public static MovementBehaviour getBehaviour(class_2680 state) {
        MovementBehaviour behaviour = BLOCK_BEHAVIOURS.get(state.method_26204());
        if (behaviour != null) {
            return behaviour;
        }
        for (BehaviourProvider provider : GLOBAL_BEHAVIOURS) {
            behaviour = provider.getBehaviour(state);
            if (behaviour == null) continue;
            return behaviour;
        }
        return null;
    }

    public static <B extends class_2248> NonNullConsumer<? super B> movementBehaviour(MovementBehaviour behaviour) {
        return b -> AllMovementBehaviours.registerBehaviour(b, behaviour);
    }

    static void registerDefaults() {
        AllMovementBehaviours.registerBehaviour(class_2246.field_16332, (MovementBehaviour)new BellMovementBehaviour());
        AllMovementBehaviours.registerBehaviour(class_2246.field_17350, (MovementBehaviour)new CampfireMovementBehaviour());
        AllMovementBehaviours.registerBehaviour(class_2246.field_23860, (MovementBehaviour)new CampfireMovementBehaviour());
        DispenserMovementBehaviour.gatherMovedDispenseItemBehaviours();
        AllMovementBehaviours.registerBehaviour(class_2246.field_10200, (MovementBehaviour)new DispenserMovementBehaviour());
        AllMovementBehaviours.registerBehaviour(class_2246.field_10228, (MovementBehaviour)new DropperMovementBehaviour());
    }

    public static interface BehaviourProvider {
        @Nullable
        public MovementBehaviour getBehaviour(class_2680 var1);
    }
}

