/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.minecart.TrainCargoManager;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.CarriageEntityHandler;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.tterrag.registrate.fabric.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableDouble;

public class Carriage {
    public static final AtomicInteger netIdGenerator = new AtomicInteger();
    public Train train;
    public int id;
    public boolean blocked;
    public boolean stalled;
    public Couple<Boolean> presentConductors;
    public int bogeySpacing;
    public Couple<CarriageBogey> bogeys;
    public TrainCargoManager storage;
    class_2487 serialisedEntity;
    Map<Integer, class_2487> serialisedPassengers;
    private Map<class_5321<class_1937>, DimensionalCarriageEntity> entities;
    static final int FIRST = 0;
    static final int MIDDLE = 1;
    static final int LAST = 2;
    static final int BOTH = 3;
    private Set<class_5321<class_1937>> currentlyTraversedDimensions = new HashSet<class_5321<class_1937>>();
    private TravellingPoint portalScout = new TravellingPoint();

    public Carriage(CarriageBogey bogey1, @Nullable CarriageBogey bogey2, int bogeySpacing) {
        this.bogeySpacing = bogeySpacing;
        this.bogeys = Couple.create(bogey1, bogey2);
        this.id = netIdGenerator.incrementAndGet();
        this.serialisedEntity = new class_2487();
        this.presentConductors = Couple.create(false, false);
        this.serialisedPassengers = new HashMap<Integer, class_2487>();
        this.entities = new HashMap<class_5321<class_1937>, DimensionalCarriageEntity>();
        this.storage = new TrainCargoManager();
        bogey1.setLeading();
        bogey1.carriage = this;
        if (bogey2 != null) {
            bogey2.carriage = this;
        }
    }

    public boolean isOnIncompatibleTrack() {
        return this.leadingBogey().type.isOnIncompatibleTrack(this, true) || this.trailingBogey().type.isOnIncompatibleTrack(this, false);
    }

    public void setTrain(Train train) {
        this.train = train;
    }

    public boolean presentInMultipleDimensions() {
        return this.entities.size() > 1;
    }

    public void setContraption(class_1937 level, CarriageContraption contraption) {
        this.storage = null;
        CarriageContraptionEntity entity = CarriageContraptionEntity.create(level, contraption);
        entity.setCarriage(this);
        contraption.startMoving(level);
        contraption.onEntityInitialize(level, entity);
        this.updateContraptionAnchors();
        DimensionalCarriageEntity dimensional = this.getDimensional(level);
        dimensional.alignEntity(entity);
        dimensional.removeAndSaveEntity(entity, true);
    }

    public DimensionalCarriageEntity getDimensional(class_1937 level) {
        return this.getDimensional((class_5321<class_1937>)level.method_27983());
    }

    public DimensionalCarriageEntity getDimensional(class_5321<class_1937> dimension) {
        return this.entities.computeIfAbsent(dimension, $ -> new DimensionalCarriageEntity());
    }

    @Nullable
    public DimensionalCarriageEntity getDimensionalIfPresent(class_5321<class_1937> dimension) {
        return this.entities.get(dimension);
    }

    public double travel(class_1937 level, TrackGraph graph, double distance, TravellingPoint toFollowForward, TravellingPoint toFollowBackward, int type) {
        Function<TravellingPoint, TravellingPoint.ITrackSelector> forwardControl;
        Function<TravellingPoint, TravellingPoint.ITrackSelector> function = toFollowForward == null ? this.train.navigation::control : (forwardControl = mp -> mp.follow(toFollowForward));
        Function<TravellingPoint, TravellingPoint.ITrackSelector> backwardControl = toFollowBackward == null ? this.train.navigation::control : mp -> mp.follow(toFollowBackward);
        boolean onTwoBogeys = this.isOnTwoBogeys();
        double stress = this.train.derailed ? 0.0 : (onTwoBogeys ? (double)this.bogeySpacing - this.getAnchorDiff() : 0.0);
        this.blocked = false;
        MutableDouble distanceMoved = new MutableDouble(distance);
        boolean iterateFromBack = distance < 0.0;
        for (boolean firstBogey : Iterate.trueAndFalse) {
            if (!firstBogey && !onTwoBogeys) continue;
            boolean actuallyFirstBogey = !onTwoBogeys || firstBogey ^ iterateFromBack;
            CarriageBogey bogey = this.bogeys.get(actuallyFirstBogey);
            double bogeyCorrection = stress * (actuallyFirstBogey ? 0.5 : -0.5);
            double bogeyStress = bogey.getStress();
            for (boolean firstWheel : Iterate.trueAndFalse) {
                TravellingPoint.ITrackSelector trackSelector;
                TravellingPoint prevPoint;
                boolean actuallyFirstWheel = firstWheel ^ iterateFromBack;
                TravellingPoint point = bogey.points.get(actuallyFirstWheel);
                TravellingPoint travellingPoint = !actuallyFirstWheel ? (TravellingPoint)bogey.points.getFirst() : (prevPoint = !actuallyFirstBogey && onTwoBogeys ? (TravellingPoint)((CarriageBogey)this.bogeys.getFirst()).points.getSecond() : null);
                TravellingPoint nextPoint = actuallyFirstWheel ? (TravellingPoint)bogey.points.getSecond() : (actuallyFirstBogey && onTwoBogeys ? (TravellingPoint)((CarriageBogey)this.bogeys.getSecond()).points.getFirst() : null);
                double correction = bogeyStress * (actuallyFirstWheel ? 0.5 : -0.5);
                double toMove = distanceMoved.getValue();
                TravellingPoint.ITrackSelector frontTrackSelector = prevPoint == null ? forwardControl.apply(point) : point.follow(prevPoint);
                TravellingPoint.ITrackSelector backTrackSelector = nextPoint == null ? backwardControl.apply(point) : point.follow(nextPoint);
                boolean atFront = (type == 0 || type == 3) && actuallyFirstWheel && actuallyFirstBogey;
                boolean atBack = !(type != 2 && type != 3 || actuallyFirstWheel || actuallyFirstBogey && onTwoBogeys);
                TravellingPoint.IEdgePointListener frontListener = this.train.frontSignalListener();
                TravellingPoint.IEdgePointListener backListener = this.train.backSignalListener();
                TravellingPoint.IEdgePointListener passiveListener = point.ignoreEdgePoints();
                TravellingPoint.ITrackSelector iTrackSelector = trackSelector = (toMove += correction + bogeyCorrection) > 0.0 ? frontTrackSelector : backTrackSelector;
                TravellingPoint.IEdgePointListener signalListener = toMove > 0.0 ? (atFront ? frontListener : (atBack ? backListener : passiveListener)) : (atFront ? backListener : (atBack ? frontListener : passiveListener));
                double moved = point.travel(graph, toMove, trackSelector, signalListener, point.ignoreTurns(), c -> {
                    for (DimensionalCarriageEntity dce : this.entities.values()) {
                        if (!c.either(tnl -> tnl.equalsIgnoreDim((Object)dce.pivot))) continue;
                        return false;
                    }
                    if (this.entities.size() > 1) {
                        this.train.status.doublePortal();
                        return true;
                    }
                    return false;
                });
                this.blocked |= point.blocked;
                distanceMoved.setValue(moved);
            }
        }
        this.updateContraptionAnchors();
        this.manageEntities(level);
        return distanceMoved.getValue();
    }

    public double getAnchorDiff() {
        double diff = 0.0;
        int entries = 0;
        TravellingPoint leadingPoint = this.getLeadingPoint();
        TravellingPoint trailingPoint = this.getTrailingPoint();
        if (leadingPoint.node1 != null && trailingPoint.node1 != null && !leadingPoint.node1.getLocation().dimension.equals(trailingPoint.node1.getLocation().dimension)) {
            return this.bogeySpacing;
        }
        for (DimensionalCarriageEntity dce : this.entities.values()) {
            if (dce.leadingAnchor() == null || dce.trailingAnchor() == null) continue;
            ++entries;
            diff += dce.leadingAnchor().method_1022(dce.trailingAnchor());
        }
        if (entries == 0) {
            return this.bogeySpacing;
        }
        return diff / (double)entries;
    }

    public void updateConductors() {
        if (this.anyAvailableEntity() == null || this.entities.size() > 1 || this.serialisedPassengers.size() > 0) {
            return;
        }
        this.presentConductors.replace($ -> false);
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null || !entity.method_5805()) continue;
            this.presentConductors.replaceWithParams((current, checked) -> current != false || checked != false, entity.checkConductors());
        }
    }

    public void manageEntities(class_1937 level) {
        this.currentlyTraversedDimensions.clear();
        this.bogeys.forEach(cb -> {
            if (cb == null) {
                return;
            }
            cb.points.forEach(tp -> {
                if (tp.node1 == null) {
                    return;
                }
                this.currentlyTraversedDimensions.add(tp.node1.getLocation().dimension);
            });
        });
        Iterator<Map.Entry<class_5321<class_1937>, DimensionalCarriageEntity>> iterator = this.entities.entrySet().iterator();
        while (iterator.hasNext()) {
            CarriageContraptionEntity entity;
            DimensionalCarriageEntity dimensionalCarriageEntity;
            block6: {
                boolean discard;
                block4: {
                    class_3218 currentLevel;
                    block5: {
                        Map.Entry<class_5321<class_1937>, DimensionalCarriageEntity> entry = iterator.next();
                        boolean bl = discard = !this.currentlyTraversedDimensions.isEmpty() && !this.currentlyTraversedDimensions.contains(entry.getKey());
                        MinecraftServer server = level.method_8503();
                        if (server == null || (currentLevel = server.method_3847(entry.getKey())) == null) continue;
                        dimensionalCarriageEntity = entry.getValue();
                        entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
                        if (entity != null) break block4;
                        if (!discard) break block5;
                        iterator.remove();
                        break block6;
                    }
                    if (dimensionalCarriageEntity.positionAnchor == null || !CarriageEntityHandler.isActiveChunk((class_1937)currentLevel, class_2338.method_49638((class_2374)dimensionalCarriageEntity.positionAnchor))) break block6;
                    dimensionalCarriageEntity.createEntity((class_1937)currentLevel, this.anyAvailableEntity() == null);
                    break block6;
                }
                if (discard) {
                    discard = dimensionalCarriageEntity.discardTicks > 3;
                    ++dimensionalCarriageEntity.discardTicks;
                } else {
                    dimensionalCarriageEntity.discardTicks = 0;
                }
                CarriageEntityHandler.validateCarriageEntity(entity);
                if (!entity.method_5805() || entity.leftTickingChunks || discard) {
                    dimensionalCarriageEntity.removeAndSaveEntity(entity, discard);
                    if (!discard) continue;
                    iterator.remove();
                    continue;
                }
            }
            if ((entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get())) == null || dimensionalCarriageEntity.positionAnchor == null) continue;
            dimensionalCarriageEntity.alignEntity(entity);
            entity.syncCarriage();
        }
    }

    public void updateContraptionAnchors() {
        CarriageBogey leadingBogey = this.leadingBogey();
        if (leadingBogey.points.either(t -> t.edge == null)) {
            return;
        }
        CarriageBogey trailingBogey = this.trailingBogey();
        if (trailingBogey.points.either(t -> t.edge == null)) {
            return;
        }
        class_5321<class_1937> leadingBogeyDim = leadingBogey.getDimension();
        class_5321<class_1937> trailingBogeyDim = trailingBogey.getDimension();
        double leadingWheelSpacing = leadingBogey.type.getWheelPointSpacing();
        double trailingWheelSpacing = trailingBogey.type.getWheelPointSpacing();
        boolean leadingUpsideDown = leadingBogey.isUpsideDown();
        boolean trailingUpsideDown = trailingBogey.isUpsideDown();
        for (boolean leading : Iterate.trueAndFalse) {
            TravellingPoint point = leading ? this.getLeadingPoint() : this.getTrailingPoint();
            TravellingPoint otherPoint = !leading ? this.getLeadingPoint() : this.getTrailingPoint();
            class_5321<class_1937> dimension = point.node1.getLocation().dimension;
            class_5321<class_1937> otherDimension = otherPoint.node1.getLocation().dimension;
            if (dimension.equals(otherDimension) && leading) {
                this.getDimensional(dimension).discardPivot();
                continue;
            }
            DimensionalCarriageEntity dce = this.getDimensional(dimension);
            dce.positionAnchor = dimension.equals(leadingBogeyDim) ? leadingBogey.getAnchorPosition() : this.pivoted(dce, dimension, point, leading ? leadingWheelSpacing / 2.0 : (double)this.bogeySpacing + trailingWheelSpacing / 2.0, leadingUpsideDown, trailingUpsideDown);
            boolean backAnchorFlip = trailingBogey.isUpsideDown() ^ leadingBogey.isUpsideDown();
            if (this.isOnTwoBogeys()) {
                dce.rotationAnchors.setFirst(dimension.equals(leadingBogeyDim) ? leadingBogey.getAnchorPosition() : this.pivoted(dce, dimension, point, leading ? leadingWheelSpacing / 2.0 : (double)this.bogeySpacing + trailingWheelSpacing / 2.0, leadingUpsideDown, trailingUpsideDown));
                dce.rotationAnchors.setSecond(dimension.equals(trailingBogeyDim) ? trailingBogey.getAnchorPosition(backAnchorFlip) : this.pivoted(dce, dimension, point, leading ? leadingWheelSpacing / 2.0 + (double)this.bogeySpacing : trailingWheelSpacing / 2.0, leadingUpsideDown, trailingUpsideDown));
            } else if (dimension.equals(otherDimension)) {
                dce.rotationAnchors = leadingBogey.points.map(tp -> tp.getPosition(this.train.graph));
            } else {
                dce.rotationAnchors.setFirst(leadingBogey.points.getFirst() == point ? point.getPosition(this.train.graph) : this.pivoted(dce, dimension, point, leadingWheelSpacing, leadingUpsideDown, trailingUpsideDown));
                dce.rotationAnchors.setSecond(leadingBogey.points.getSecond() == point ? point.getPosition(this.train.graph) : this.pivoted(dce, dimension, point, leadingWheelSpacing, leadingUpsideDown, trailingUpsideDown));
            }
            int prevmin = dce.minAllowedLocalCoord();
            int prevmax = dce.maxAllowedLocalCoord();
            dce.updateCutoff(leading);
            if (prevmin == dce.minAllowedLocalCoord() && prevmax == dce.maxAllowedLocalCoord()) continue;
            dce.updateRenderedCutoff();
            dce.updatePassengerLoadout();
        }
    }

    private class_243 pivoted(DimensionalCarriageEntity dce, class_5321<class_1937> dimension, TravellingPoint start, double offset, boolean leadingUpsideDown, boolean trailingUpsideDown) {
        if (this.train.graph == null) {
            return dce.pivot == null ? null : dce.pivot.getLocation();
        }
        TrackNodeLocation pivot = dce.findPivot(dimension, start == this.getLeadingPoint());
        if (pivot == null) {
            return null;
        }
        boolean flipped = start != this.getLeadingPoint() && leadingUpsideDown != trailingUpsideDown;
        class_243 startVec = start.getPosition(this.train.graph, flipped);
        class_243 portalVec = pivot.getLocation().method_1031(0.0, leadingUpsideDown ? -1.0 : 1.0, 0.0);
        return VecHelper.lerp((float)(offset / startVec.method_1022(portalVec)), startVec, portalVec);
    }

    public void alignEntity(class_1937 level) {
        CarriageContraptionEntity entity;
        DimensionalCarriageEntity dimensionalCarriageEntity = this.entities.get(level.method_27983());
        if (dimensionalCarriageEntity != null && (entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get())) != null) {
            dimensionalCarriageEntity.alignEntity(entity);
        }
    }

    public TravellingPoint getLeadingPoint() {
        return this.leadingBogey().leading();
    }

    public TravellingPoint getTrailingPoint() {
        return this.trailingBogey().trailing();
    }

    public CarriageBogey leadingBogey() {
        return (CarriageBogey)this.bogeys.getFirst();
    }

    public CarriageBogey trailingBogey() {
        return this.isOnTwoBogeys() ? (CarriageBogey)this.bogeys.getSecond() : this.leadingBogey();
    }

    public boolean isOnTwoBogeys() {
        return this.bogeys.getSecond() != null;
    }

    public CarriageContraptionEntity anyAvailableEntity() {
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public void forEachPresentEntity(Consumer<CarriageContraptionEntity> callback) {
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null) continue;
            callback.accept(entity);
        }
    }

    public class_2487 write(DimensionPalette dimensions) {
        class_2487 tag = new class_2487();
        tag.method_10566("FirstBogey", (class_2520)((CarriageBogey)this.bogeys.getFirst()).write(dimensions));
        if (this.isOnTwoBogeys()) {
            tag.method_10566("SecondBogey", (class_2520)((CarriageBogey)this.bogeys.getSecond()).write(dimensions));
        }
        tag.method_10569("Spacing", this.bogeySpacing);
        tag.method_10556("FrontConductor", ((Boolean)this.presentConductors.getFirst()).booleanValue());
        tag.method_10556("BackConductor", ((Boolean)this.presentConductors.getSecond()).booleanValue());
        tag.method_10556("Stalled", this.stalled);
        HashMap<Integer, class_2487> passengerMap = new HashMap<Integer, class_2487>();
        for (DimensionalCarriageEntity dimensionalCarriageEntity : this.entities.values()) {
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensionalCarriageEntity.entity.get());
            if (entity == null) continue;
            this.serialize(entity);
            Contraption contraption = entity.getContraption();
            if (contraption == null) continue;
            Map<UUID, Integer> mapping = contraption.getSeatMapping();
            for (class_1297 passenger : entity.method_5685()) {
                if (!mapping.containsKey(passenger.method_5667())) continue;
                passengerMap.put(mapping.get(passenger.method_5667()), NBTSerializer.serializeNBTCompound((Object)passenger));
            }
        }
        tag.method_10566("Entity", (class_2520)this.serialisedEntity.method_10553());
        class_2487 passengerTag = new class_2487();
        passengerMap.putAll(this.serialisedPassengers);
        passengerMap.forEach((seat, nbt) -> passengerTag.method_10566("Seat" + seat, (class_2520)nbt.method_10553()));
        tag.method_10566("Passengers", (class_2520)passengerTag);
        tag.method_10566("EntityPositioning", (class_2520)NBTHelper.writeCompoundList(this.entities.entrySet(), e -> {
            class_2487 c = ((DimensionalCarriageEntity)e.getValue()).write();
            c.method_10569("Dim", dimensions.encode((class_5321<class_1937>)((class_5321)e.getKey())));
            return c;
        }));
        return tag;
    }

    private void serialize(class_1297 entity) {
        this.serialisedEntity = NBTSerializer.serializeNBTCompound((Object)entity);
        this.serialisedEntity.method_10551("Passengers");
        this.serialisedEntity.method_10562("Contraption").method_10551("Passengers");
    }

    public static Carriage read(class_2487 tag, TrackGraph graph, DimensionPalette dimensions) {
        CarriageBogey bogey1 = CarriageBogey.read(tag.method_10562("FirstBogey"), graph, dimensions);
        CarriageBogey bogey2 = tag.method_10545("SecondBogey") ? CarriageBogey.read(tag.method_10562("SecondBogey"), graph, dimensions) : null;
        Carriage carriage = new Carriage(bogey1, bogey2, tag.method_10550("Spacing"));
        carriage.stalled = tag.method_10577("Stalled");
        carriage.presentConductors = Couple.create(tag.method_10577("FrontConductor"), tag.method_10577("BackConductor"));
        carriage.serialisedEntity = tag.method_10562("Entity").method_10553();
        NBTHelper.iterateCompoundList(tag.method_10554("EntityPositioning", 10), c -> carriage.getDimensional(dimensions.decode(c.method_10550("Dim"))).read((class_2487)c));
        class_2487 passengersTag = tag.method_10562("Passengers");
        passengersTag.method_10541().forEach(key -> carriage.serialisedPassengers.put(Integer.valueOf(key.substring(4)), passengersTag.method_10562(key)));
        return carriage;
    }

    public class DimensionalCarriageEntity {
        public class_243 positionAnchor;
        public Couple<class_243> rotationAnchors;
        public WeakReference<CarriageContraptionEntity> entity = new WeakReference<Object>(null);
        public TrackNodeLocation pivot;
        int discardTicks;
        public float cutoff;
        public boolean pointsInitialised = false;

        public DimensionalCarriageEntity() {
            this.rotationAnchors = Couple.create(null, null);
        }

        public void discardPivot() {
            int prevmin = this.minAllowedLocalCoord();
            int prevmax = this.maxAllowedLocalCoord();
            this.cutoff = 0.0f;
            this.pivot = null;
            if (!Carriage.this.serialisedPassengers.isEmpty() && this.entity.get() != null || prevmin != this.minAllowedLocalCoord() || prevmax != this.maxAllowedLocalCoord()) {
                this.updatePassengerLoadout();
                this.updateRenderedCutoff();
            }
        }

        public void updateCutoff(boolean leadingIsCurrent) {
            class_243 leadingAnchor = (class_243)this.rotationAnchors.getFirst();
            class_243 trailingAnchor = (class_243)this.rotationAnchors.getSecond();
            if (leadingAnchor == null || trailingAnchor == null) {
                return;
            }
            if (this.pivot == null) {
                this.cutoff = 0.0f;
                return;
            }
            class_243 pivotLoc = this.pivot.getLocation().method_1031(0.0, 1.0, 0.0);
            double leadingSpacing = Carriage.this.leadingBogey().type.getWheelPointSpacing() / 2.0;
            double trailingSpacing = Carriage.this.trailingBogey().type.getWheelPointSpacing() / 2.0;
            double anchorSpacing = leadingSpacing + (double)Carriage.this.bogeySpacing + trailingSpacing;
            if (Carriage.this.isOnTwoBogeys()) {
                class_243 diff = trailingAnchor.method_1020(leadingAnchor).method_1029();
                trailingAnchor = trailingAnchor.method_1019(diff.method_1021(trailingSpacing));
                leadingAnchor = leadingAnchor.method_1019(diff.method_1021(-leadingSpacing));
            }
            double leadingDiff = leadingAnchor.method_1022(pivotLoc);
            double trailingDiff = trailingAnchor.method_1022(pivotLoc);
            this.cutoff = leadingIsCurrent && leadingDiff > trailingDiff && leadingDiff > 1.0 ? 0.0f : (leadingIsCurrent && leadingDiff < trailingDiff && trailingDiff > 1.0 ? 1.0f : (!leadingIsCurrent && leadingDiff > trailingDiff && leadingDiff > 1.0 ? -1.0f : (!leadingIsCurrent && leadingDiff < trailingDiff && trailingDiff > 1.0 ? 0.0f : (float)class_3532.method_15350((double)(1.0 - (leadingIsCurrent ? (leadingDiff /= anchorSpacing) : (trailingDiff /= anchorSpacing))), (double)0.0, (double)1.0) * (float)(leadingIsCurrent ? 1 : -1))));
        }

        public TrackNodeLocation findPivot(class_5321<class_1937> dimension, boolean leading) {
            if (this.pivot != null) {
                return this.pivot;
            }
            TravellingPoint start = leading ? Carriage.this.getLeadingPoint() : Carriage.this.getTrailingPoint();
            TravellingPoint end = !leading ? Carriage.this.getLeadingPoint() : Carriage.this.getTrailingPoint();
            Carriage.this.portalScout.node1 = start.node1;
            Carriage.this.portalScout.node2 = start.node2;
            Carriage.this.portalScout.edge = start.edge;
            Carriage.this.portalScout.position = start.position;
            TravellingPoint.ITrackSelector trackSelector = Carriage.this.portalScout.follow(end);
            int distance = Carriage.this.bogeySpacing + 10;
            int direction = leading ? -1 : 1;
            Carriage.this.portalScout.travel(Carriage.this.train.graph, direction * distance, trackSelector, Carriage.this.portalScout.ignoreEdgePoints(), Carriage.this.portalScout.ignoreTurns(), nodes -> {
                for (boolean b : Iterate.trueAndFalse) {
                    if (!((TrackNodeLocation)((Object)((Object)nodes.get((boolean)b)))).dimension.equals((Object)dimension)) continue;
                    this.pivot = (TrackNodeLocation)((Object)((Object)nodes.get(b)));
                }
                return true;
            });
            return this.pivot;
        }

        public class_2487 write() {
            class_2487 tag = new class_2487();
            tag.method_10548("Cutoff", this.cutoff);
            tag.method_10569("DiscardTicks", this.discardTicks);
            Carriage.this.storage.write(tag, false);
            if (this.pivot != null) {
                tag.method_10566("Pivot", (class_2520)this.pivot.write(null));
            }
            if (this.positionAnchor != null) {
                tag.method_10566("PositionAnchor", (class_2520)VecHelper.writeNBT(this.positionAnchor));
            }
            if (this.rotationAnchors.both(Objects::nonNull)) {
                tag.method_10566("RotationAnchors", (class_2520)this.rotationAnchors.serializeEach(VecHelper::writeNBTCompound));
            }
            return tag;
        }

        public void read(class_2487 tag) {
            this.cutoff = tag.method_10583("Cutoff");
            this.discardTicks = tag.method_10550("DiscardTicks");
            Carriage.this.storage.read(tag, null, false);
            if (tag.method_10545("Pivot")) {
                this.pivot = TrackNodeLocation.read(tag.method_10562("Pivot"), null);
            }
            if (this.positionAnchor != null) {
                return;
            }
            if (tag.method_10545("PositionAnchor")) {
                this.positionAnchor = VecHelper.readNBT(tag.method_10554("PositionAnchor", 6));
            }
            if (tag.method_10545("RotationAnchors")) {
                this.rotationAnchors = Couple.deserializeEach(tag.method_10554("RotationAnchors", 10), VecHelper::readNBTCompound);
            }
        }

        public class_243 leadingAnchor() {
            return Carriage.this.isOnTwoBogeys() ? (class_243)this.rotationAnchors.getFirst() : this.positionAnchor;
        }

        public class_243 trailingAnchor() {
            return Carriage.this.isOnTwoBogeys() ? (class_243)this.rotationAnchors.getSecond() : this.positionAnchor;
        }

        public int minAllowedLocalCoord() {
            if (this.cutoff <= 0.0f) {
                return Integer.MIN_VALUE;
            }
            if (this.cutoff >= 1.0f) {
                return Integer.MAX_VALUE;
            }
            return class_3532.method_15375((float)((float)(-Carriage.this.bogeySpacing + -1) + (float)(2 + Carriage.this.bogeySpacing) * this.cutoff));
        }

        public int maxAllowedLocalCoord() {
            if (this.cutoff >= 0.0f) {
                return Integer.MAX_VALUE;
            }
            if (this.cutoff <= -1.0f) {
                return Integer.MIN_VALUE;
            }
            return class_3532.method_15386((float)((float)(-Carriage.this.bogeySpacing + -1) + (float)(2 + Carriage.this.bogeySpacing) * (this.cutoff + 1.0f)));
        }

        public void updatePassengerLoadout() {
            class_1297 entity = (class_1297)this.entity.get();
            if (!(entity instanceof CarriageContraptionEntity)) {
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            class_1937 class_19372 = entity.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 sLevel = (class_3218)class_19372;
            HashSet<Integer> loadedPassengers = new HashSet<Integer>();
            int min = this.minAllowedLocalCoord();
            int max = this.maxAllowedLocalCoord();
            for (Map.Entry<Integer, class_2487> entry : Carriage.this.serialisedPassengers.entrySet()) {
                class_2338 localPos;
                Integer seatId = entry.getKey();
                List<class_2338> seats = cce.getContraption().getSeats();
                if (seatId >= seats.size() || !cce.isLocalCoordWithin(localPos = seats.get(seatId), min, max)) continue;
                class_2487 tag = entry.getValue();
                class_1297 passenger = null;
                if (tag.method_10545("PlayerPassenger")) {
                    passenger = sLevel.method_8503().method_3760().method_14602(tag.method_25926("PlayerPassenger"));
                } else {
                    passenger = class_1299.method_17842((class_2487)tag, (class_1937)entity.method_37908(), e -> {
                        e.method_29495(this.positionAnchor);
                        return e;
                    });
                    if (passenger != null) {
                        sLevel.method_30736(passenger);
                    }
                }
                if (passenger != null) {
                    class_5321 passengerDimension = passenger.method_37908().method_27983();
                    if (!passengerDimension.equals(sLevel.method_27983()) && passenger instanceof class_3222) {
                        class_3222 sp = (class_3222)passenger;
                        continue;
                    }
                    cce.addSittingPassenger(passenger, seatId);
                }
                loadedPassengers.add(seatId);
            }
            loadedPassengers.forEach(Carriage.this.serialisedPassengers::remove);
            Map<UUID, Integer> mapping = cce.getContraption().getSeatMapping();
            for (class_1297 passenger : entity.method_5685()) {
                class_2338 localPos = cce.getContraption().getSeatOf(passenger.method_5667());
                if (cce.isLocalCoordWithin(localPos, min, max) || !mapping.containsKey(passenger.method_5667())) continue;
                Integer seat = mapping.get(passenger.method_5667());
                if (passenger instanceof class_3222) {
                    class_3222 sp = (class_3222)passenger;
                    this.dismountPlayer(sLevel, sp, seat, true);
                    continue;
                }
                Carriage.this.serialisedPassengers.put(seat, NBTSerializer.serializeNBTCompound((Object)passenger));
                passenger.method_31472();
            }
        }

        private void dismountPlayer(class_3218 sLevel, class_3222 sp, Integer seat, boolean capture) {
            if (!capture) {
                sp.method_5848();
                return;
            }
            class_2487 tag = new class_2487();
            tag.method_25927("PlayerPassenger", sp.method_5667());
            Carriage.this.serialisedPassengers.put(seat, tag);
            sp.method_5848();
            sp.getCustomData().method_10551("ContraptionDismountLocation");
            for (Map.Entry<class_5321<class_1937>, DimensionalCarriageEntity> other : Carriage.this.entities.entrySet()) {
                class_243 loc;
                DimensionalCarriageEntity otherDce = other.getValue();
                if (otherDce == this || sp.method_37908().method_27983().equals(other.getKey())) continue;
                class_243 class_2432 = loc = otherDce.pivot == null ? otherDce.positionAnchor : otherDce.pivot.getLocation();
                if (loc == null) continue;
                class_3218 level = sLevel.method_8503().method_3847(other.getKey());
                sp.method_14251(level, loc.field_1352, loc.field_1351, loc.field_1350, sp.method_36454(), sp.method_36455());
                sp.method_30229();
                AllAdvancements.TRAIN_PORTAL.awardTo((class_1657)sp);
            }
        }

        public void updateRenderedCutoff() {
            class_1297 entity = (class_1297)this.entity.get();
            if (!(entity instanceof CarriageContraptionEntity)) {
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            Contraption contraption = cce.getContraption();
            if (!(contraption instanceof CarriageContraption)) {
                return;
            }
            CarriageContraption cc = (CarriageContraption)contraption;
            cc.portalCutoffMin = this.minAllowedLocalCoord();
            cc.portalCutoffMax = this.maxAllowedLocalCoord();
            if (!entity.method_37908().method_8608()) {
                return;
            }
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.invalidate(cce));
        }

        @Environment(value=EnvType.CLIENT)
        private void invalidate(CarriageContraptionEntity entity) {
            entity.getContraption().deferInvalidate = true;
            entity.updateRenderedPortalCutoff();
        }

        private void createEntity(class_1937 level, boolean loadPassengers) {
            class_1297 entity = class_1299.method_5892((class_2487)Carriage.this.serialisedEntity, (class_1937)level).orElse(null);
            if (!(entity instanceof CarriageContraptionEntity)) {
                Carriage.this.train.invalid = true;
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            entity.method_29495(this.positionAnchor);
            this.entity = new WeakReference<CarriageContraptionEntity>(cce);
            cce.setCarriage(Carriage.this);
            cce.syncCarriage();
            if (level instanceof class_3218) {
                class_3218 sl = (class_3218)level;
                sl.method_8649(entity);
            }
            this.updatePassengerLoadout();
        }

        private void removeAndSaveEntity(CarriageContraptionEntity entity, boolean portal) {
            Contraption contraption = entity.getContraption();
            if (contraption != null) {
                Map<UUID, Integer> mapping = contraption.getSeatMapping();
                for (class_1297 passenger : entity.method_5685()) {
                    if (!mapping.containsKey(passenger.method_5667())) continue;
                    Integer seat = mapping.get(passenger.method_5667());
                    if (passenger instanceof class_3222) {
                        class_3222 sp = (class_3222)passenger;
                        this.dismountPlayer(sp.method_51469(), sp, seat, portal);
                        continue;
                    }
                    Carriage.this.serialisedPassengers.put(seat, NBTSerializer.serializeNBTCompound((Object)passenger));
                }
            }
            for (class_1297 passenger : entity.method_5685()) {
                if (passenger instanceof class_1657) continue;
                passenger.method_31472();
            }
            Carriage.this.serialize(entity);
            entity.method_31472();
            this.entity.clear();
        }

        public void alignEntity(CarriageContraptionEntity entity) {
            if (this.rotationAnchors.either(Objects::isNull)) {
                return;
            }
            class_243 positionVec = (class_243)this.rotationAnchors.getFirst();
            class_243 coupledVec = (class_243)this.rotationAnchors.getSecond();
            double diffX = positionVec.field_1352 - coupledVec.field_1352;
            double diffY = positionVec.field_1351 - coupledVec.field_1351;
            double diffZ = positionVec.field_1350 - coupledVec.field_1350;
            entity.prevYaw = entity.yaw;
            entity.prevPitch = entity.pitch;
            if (!entity.method_37908().method_8608()) {
                class_243 lookahead = this.positionAnchor.method_1019(this.positionAnchor.method_1020(entity.method_19538()).method_1029().method_1021(16.0));
                for (class_1297 e : entity.method_5685()) {
                    if (!(e instanceof class_1657) || e.method_5858((class_1297)entity) > 1024.0) continue;
                    if (CarriageEntityHandler.isActiveChunk(entity.method_37908(), class_2338.method_49638((class_2374)lookahead))) break;
                    Carriage.this.train.carriageWaitingForChunks = Carriage.this.id;
                    return;
                }
                if (entity.method_5685().stream().anyMatch(p -> p instanceof class_1657)) {
                    // empty if block
                }
                if (Carriage.this.train.carriageWaitingForChunks == Carriage.this.id) {
                    Carriage.this.train.carriageWaitingForChunks = -1;
                }
                entity.setServerSidePrevPosition();
            }
            entity.method_33574(this.positionAnchor);
            entity.yaw = (float)(class_3532.method_15349((double)diffZ, (double)diffX) * 180.0 / Math.PI) + 180.0f;
            entity.pitch = (float)(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180.0 / Math.PI) * -1.0f;
            if (!entity.firstPositionUpdate) {
                return;
            }
            entity.field_6014 = entity.method_23317();
            entity.field_6036 = entity.method_23318();
            entity.field_5969 = entity.method_23321();
            entity.prevYaw = entity.yaw;
            entity.prevPitch = entity.pitch;
        }
    }
}

