/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.link.controller;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.redstone.link.controller.LecternControllerBlock;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerClientHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.fabric.ReachUtil;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;

public class LecternControllerBlockEntity
extends SmartBlockEntity {
    private class_1799 controller;
    private UUID user;
    private UUID prevUser;
    private boolean deactivatedThisTick;

    public LecternControllerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10566("Controller", (class_2520)this.controller.method_7953(new class_2487()));
        if (this.user != null) {
            compound.method_25927("User", this.user);
        }
    }

    @Override
    public void writeSafe(class_2487 compound) {
        super.writeSafe(compound);
        compound.method_10566("Controller", (class_2520)this.controller.method_7953(new class_2487()));
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.controller = class_1799.method_7915((class_2487)compound.method_10562("Controller"));
        this.user = compound.method_25928("User") ? compound.method_25926("User") : null;
    }

    public class_1799 getController() {
        return this.controller;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public boolean isUsedBy(class_1657 player) {
        return this.hasUser() && this.user.equals(player.method_5667());
    }

    public void tryStartUsing(class_1657 player) {
        if (!this.deactivatedThisTick && !this.hasUser() && !LecternControllerBlockEntity.playerIsUsingLectern(player) && LecternControllerBlockEntity.playerInRange(player, this.field_11863, this.field_11867)) {
            this.startUsing(player);
        }
    }

    public void tryStopUsing(class_1657 player) {
        if (this.isUsedBy(player)) {
            this.stopUsing(player);
        }
    }

    private void startUsing(class_1657 player) {
        this.user = player.method_5667();
        player.getCustomData().method_10556("IsUsingLecternController", true);
        this.sendData();
    }

    private void stopUsing(class_1657 player) {
        this.user = null;
        if (player != null) {
            player.getCustomData().method_10551("IsUsingLecternController");
        }
        this.deactivatedThisTick = true;
        this.sendData();
    }

    public static boolean playerIsUsingLectern(class_1657 player) {
        return player.getCustomData().method_10545("IsUsingLecternController");
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::tryToggleActive);
            this.prevUser = this.user;
        }
        if (!this.field_11863.field_9236) {
            this.deactivatedThisTick = false;
            if (!(this.field_11863 instanceof class_3218)) {
                return;
            }
            if (this.user == null) {
                return;
            }
            class_1297 entity = ((class_3218)this.field_11863).method_14190(this.user);
            if (!(entity instanceof class_1657)) {
                this.stopUsing(null);
                return;
            }
            class_1657 player = (class_1657)entity;
            if (!LecternControllerBlockEntity.playerInRange(player, this.field_11863, this.field_11867) || !LecternControllerBlockEntity.playerIsUsingLectern(player)) {
                this.stopUsing(player);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void tryToggleActive() {
        if (this.user == null && class_310.method_1551().field_1724.method_5667().equals(this.prevUser)) {
            LinkedControllerClientHandler.deactivateInLectern();
        } else if (this.prevUser == null && class_310.method_1551().field_1724.method_5667().equals(this.user)) {
            LinkedControllerClientHandler.activateInLectern(this.field_11867);
        }
    }

    public void setController(class_1799 newController) {
        this.controller = newController;
        if (newController != null) {
            AllSoundEvents.CONTROLLER_PUT.playOnServer(this.field_11863, (class_2382)this.field_11867);
        }
    }

    public void swapControllers(class_1799 stack, class_1657 player, class_1268 hand, class_2680 state) {
        class_1799 newController = stack.method_7972();
        stack.method_7939(0);
        if (player.method_5998(hand).method_7960()) {
            player.method_6122(hand, this.controller);
        } else {
            this.dropController(state);
        }
        this.setController(newController);
    }

    public void dropController(class_2680 state) {
        class_1297 playerEntity = ((class_3218)this.field_11863).method_14190(this.user);
        if (playerEntity instanceof class_1657) {
            this.stopUsing((class_1657)playerEntity);
        }
        class_2350 dir = (class_2350)state.method_11654((class_2769)LecternControllerBlock.field_16404);
        double x = (double)this.field_11867.method_10263() + 0.5 + 0.25 * (double)dir.method_10148();
        double y = this.field_11867.method_10264() + 1;
        double z = (double)this.field_11867.method_10260() + 0.5 + 0.25 * (double)dir.method_10165();
        class_1542 itementity = new class_1542(this.field_11863, x, y, z, this.controller.method_7972());
        itementity.method_6988();
        this.field_11863.method_8649((class_1297)itementity);
        this.controller = null;
    }

    public static boolean playerInRange(class_1657 player, class_1937 world, class_2338 pos) {
        double reach = 0.4 * ReachUtil.reach(player);
        return player.method_5707(class_243.method_24953((class_2382)pos)) < reach * reach;
    }
}

