/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.burner;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class BlazeBurnerRenderer
extends SafeBlockEntityRenderer<BlazeBurnerBlockEntity> {
    public BlazeBurnerRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(BlazeBurnerBlockEntity be, float partialTicks, class_4587 ms, class_4597 bufferSource, int light, int overlay) {
        BlazeBurnerBlock.HeatLevel heatLevel = be.getHeatLevelFromBlock();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        class_1937 level = be.method_10997();
        class_2680 blockState = be.method_11010();
        float animation = be.headAnimation.getValue(partialTicks) * 0.175f;
        float horizontalAngle = AngleHelper.rad(be.headAngle.getValue(partialTicks));
        boolean canDrawFlame = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
        boolean drawGoggles = be.goggles;
        boolean drawHat = be.hat;
        int hashCode = be.hashCode();
        BlazeBurnerRenderer.renderShared(ms, null, bufferSource, level, blockState, heatLevel, animation, horizontalAngle, canDrawFlame, drawGoggles, drawHat, hashCode);
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 bufferSource, LerpedFloat headAngle, boolean conductor) {
        class_2680 state = context.state;
        BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.getHeatLevelOf(state);
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        if (!heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            heatLevel = BlazeBurnerBlock.HeatLevel.FADING;
        }
        class_1937 level = context.world;
        float horizontalAngle = AngleHelper.rad(headAngle.getValue(AnimationTickHolder.getPartialTicks((class_1936)level)));
        boolean drawGoggles = context.blockEntityData.method_10545("Goggles");
        boolean drawHat = conductor || context.blockEntityData.method_10545("TrainHat");
        int hashCode = context.hashCode();
        BlazeBurnerRenderer.renderShared(matrices.getViewProjection(), matrices.getModel(), bufferSource, level, state, heatLevel, 0.0f, horizontalAngle, false, drawGoggles, drawHat, hashCode);
    }

    private static void renderShared(class_4587 ms, @Nullable class_4587 modelTransform, class_4597 bufferSource, class_1937 level, class_2680 blockState, BlazeBurnerBlock.HeatLevel heatLevel, float animation, float horizontalAngle, boolean canDrawFlame, boolean drawGoggles, boolean drawHat, int hashCode) {
        boolean blockAbove = animation > 0.125f;
        float time = AnimationTickHolder.getRenderTime((class_1936)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = class_3532.method_15374((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = class_3532.method_15374((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = class_3532.method_15374((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        float headY = offset - animation * 0.75f;
        class_4588 solid = bufferSource.getBuffer(class_1921.method_23577());
        class_4588 cutout = bufferSource.getBuffer(class_1921.method_23579());
        ms.method_22903();
        if (canDrawFlame && blockAbove) {
            SpriteShiftEntry spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            float spriteWidth = spriteShift.getTarget().method_4577() - spriteShift.getTarget().method_4594();
            float spriteHeight = spriteShift.getTarget().method_4575() - spriteShift.getTarget().method_4593();
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            SuperByteBuffer flameBuffer = CachedBufferer.partial(AllPartialModels.BLAZE_BURNER_FLAME, blockState);
            if (modelTransform != null) {
                flameBuffer.transform(modelTransform);
            }
            flameBuffer.shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll);
            BlazeBurnerRenderer.draw(flameBuffer, horizontalAngle, ms, cutout);
        }
        PartialModel blazeModel = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING) ? (blockAbove ? AllPartialModels.BLAZE_SUPER_ACTIVE : AllPartialModels.BLAZE_SUPER) : (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? (blockAbove && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.KINDLED) ? AllPartialModels.BLAZE_ACTIVE : AllPartialModels.BLAZE_IDLE) : AllPartialModels.BLAZE_INERT);
        SuperByteBuffer blazeBuffer = CachedBufferer.partial(blazeModel, blockState);
        if (modelTransform != null) {
            blazeBuffer.transform(modelTransform);
        }
        blazeBuffer.translate(0.0, headY, 0.0);
        BlazeBurnerRenderer.draw(blazeBuffer, horizontalAngle, ms, solid);
        if (drawGoggles) {
            PartialModel gogglesModel = blazeModel == AllPartialModels.BLAZE_INERT ? AllPartialModels.BLAZE_GOGGLES_SMALL : AllPartialModels.BLAZE_GOGGLES;
            SuperByteBuffer gogglesBuffer = CachedBufferer.partial(gogglesModel, blockState);
            if (modelTransform != null) {
                gogglesBuffer.transform(modelTransform);
            }
            gogglesBuffer.translate(0.0, headY + 0.5f, 0.0);
            BlazeBurnerRenderer.draw(gogglesBuffer, horizontalAngle, ms, solid);
        }
        if (drawHat) {
            SuperByteBuffer hatBuffer = CachedBufferer.partial(AllPartialModels.TRAIN_HAT, blockState);
            if (modelTransform != null) {
                hatBuffer.transform(modelTransform);
            }
            hatBuffer.translate(0.0, headY, 0.0);
            if (blazeModel == AllPartialModels.BLAZE_INERT) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)hatBuffer.translateY(0.5)).centre()).scale(0.75f)).unCentre();
            } else {
                hatBuffer.translateY(0.75);
            }
            hatBuffer.rotateCentered(class_2350.field_11036, horizontalAngle + (float)Math.PI).translate(0.5, 0.0, 0.5).light(0xF000F0).renderInto(ms, solid);
        }
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            PartialModel rodsModel = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
            PartialModel rodsModel2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
            SuperByteBuffer rodsBuffer = CachedBufferer.partial(rodsModel, blockState);
            if (modelTransform != null) {
                rodsBuffer.transform(modelTransform);
            }
            rodsBuffer.translate(0.0, offset1 + animation + 0.125f, 0.0).light(0xF000F0).renderInto(ms, solid);
            SuperByteBuffer rodsBuffer2 = CachedBufferer.partial(rodsModel2, blockState);
            if (modelTransform != null) {
                rodsBuffer2.transform(modelTransform);
            }
            rodsBuffer2.translate(0.0, offset2 + animation - 0.1875f, 0.0).light(0xF000F0).renderInto(ms, solid);
        }
        ms.method_22909();
    }

    private static void draw(SuperByteBuffer buffer, float horizontalAngle, class_4587 ms, class_4588 vc) {
        buffer.rotateCentered(class_2350.field_11036, horizontalAngle).light(0xF000F0).renderInto(ms, vc);
    }
}

