/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.goggles;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.outliner.Outline;
import com.simibubi.create.foundation.outliner.Outliner;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_638;

public class GoggleOverlayRenderer {
    private static final Map<Object, Outliner.OutlineEntry> outlines = CreateClient.OUTLINER.getOutlines();
    public static int hoverTicks = 0;
    public static class_2338 lastHovered = null;

    public static void renderOverlay(class_332 graphics, float partialTicks, class_1041 window) {
        Color colorBorderBot;
        boolean exceptionAdded;
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        class_239 objectMouseOver = mc.field_1765;
        if (!(objectMouseOver instanceof class_3965)) {
            lastHovered = null;
            hoverTicks = 0;
            return;
        }
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        class_3965 result = (class_3965)objectMouseOver;
        class_638 world = mc.field_1687;
        class_2338 pos = result.method_17777();
        int prevHoverTicks = hoverTicks++;
        lastHovered = pos;
        pos = GoggleOverlayRenderer.proxiedOverlayPosition((class_1937)world, pos);
        class_2586 be = world.method_8321(pos);
        boolean wearingGoggles = GogglesItem.isWearingGoggles((class_1657)mc.field_1724);
        boolean hasGoggleInformation = be instanceof IHaveGoggleInformation;
        boolean hasHoveringInformation = be instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)be;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, mc.field_1724.method_5715());
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add(Components.immutableEmpty());
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)be;
            hoverAddedInformation = hte.addToTooltip(tooltip, mc.field_1724.method_5715());
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (be instanceof IDisplayAssemblyExceptions && (exceptionAdded = ((IDisplayAssemblyExceptions)be).addExceptionToTooltip(tooltip))) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (!hasHoveringInformation) {
            hasHoveringInformation = hoverAddedInformation = TrainRelocator.addToTooltip(tooltip, mc.field_1724.method_5715());
            if (hoverAddedInformation) {
                hoverTicks = prevHoverTicks + 1;
            }
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            hoverTicks = 0;
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (wearingGoggles && AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            class_2350[] directions = Iterate.directionsInAxis(((class_2350)state.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166());
            int poles = 1;
            boolean pistonFound = false;
            for (class_2350 dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles((class_1937)world, pos, dir);
                poles += attachedPoles;
                pistonFound |= world.method_8320(pos.method_10079(dir, attachedPoles + 1)).method_26204() instanceof MechanicalPistonBlock;
            }
            if (!pistonFound) {
                hoverTicks = 0;
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(Components.immutableEmpty());
            }
            tooltip.add((class_2561)IHaveGoggleInformation.componentSpacing.method_27662().method_10852((class_2561)Lang.translateDirect("gui.goggles.pole_length", new Object[0])).method_10852((class_2561)Components.literal(" " + poles)));
        }
        if (tooltip.isEmpty()) {
            hoverTicks = 0;
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        int tooltipTextWidth = 0;
        for (class_5348 class_53482 : tooltip) {
            int textLineWidth = mc.field_1772.method_27525(class_53482);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        CClient cClient = AllConfigs.client();
        int posX = mc.method_22683().method_4486() / 2 + (Integer)cClient.overlayOffsetX.get();
        int posY = mc.method_22683().method_4502() / 2 + (Integer)cClient.overlayOffsetY.get();
        posX = Math.min(posX, mc.method_22683().method_4486() - tooltipTextWidth - 20);
        posY = Math.min(posY, mc.method_22683().method_4502() - tooltipHeight - 20);
        float fade = class_3532.method_15363((float)(((float)hoverTicks + partialTicks) / 24.0f), (float)0.0f, (float)1.0f);
        Boolean useCustom = (Boolean)cClient.overlayCustomColor.get();
        Color colorBackground = useCustom != false ? new Color((Integer)cClient.overlayBackgroundColor.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BACKGROUND).scaleAlpha(0.75f);
        Color colorBorderTop = useCustom != false ? new Color((Integer)cClient.overlayBorderColorTop.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BORDER, true).copy();
        Color color = colorBorderBot = useCustom != false ? new Color((Integer)cClient.overlayBorderColorBot.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BORDER, false).copy();
        if (fade < 1.0f) {
            poseStack.method_22904(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cClient.overlayOffsetX.get()).intValue() + 0.5f) * 8.0, 0.0, 0.0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        RemovedGuiUtils.drawHoveringText(graphics, tooltip, posX, posY, mc.method_22683().method_4486(), mc.method_22683().method_4502(), -1, colorBackground.getRGB(), colorBorderTop.getRGB(), colorBorderBot.getRGB(), mc.field_1772);
        class_1799 item = AllItems.GOGGLES.asStack();
        ((RenderElement)GuiGameElement.of(item).at(posX + 10, posY - 16, 450.0f)).render(graphics);
        poseStack.method_22909();
    }

    public static class_2338 proxiedOverlayPosition(class_1937 level, class_2338 pos) {
        class_2680 targetedState = level.method_8320(pos);
        class_2248 class_22482 = targetedState.method_26204();
        if (class_22482 instanceof IProxyHoveringInformation) {
            IProxyHoveringInformation proxy = (IProxyHoveringInformation)class_22482;
            return proxy.getInformationSource(level, pos, targetedState);
        }
        return pos;
    }
}

