/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlockItem;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.foundation.utility.Color;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TrackSwitchDebugVisualizer {
    public static void visualizeSwitchExits(TrackSwitch sw) {
        Minecraft mc = Minecraft.m_91087_();
        Entity camera = mc.f_91075_;
        if (camera == null) {
            return;
        }
        Vec3 offset = new Vec3(0.0, 0.4, 0.0);
        float width = 0.0625f;
        TrackNodeLocation from = sw.getSwitchPoint();
        TrackNodeLocation activeExit = sw.getSwitchTarget();
        for (TrackNodeLocation to : sw.getExits()) {
            boolean active = to == activeExit;
            CreateClient.OUTLINER.showLine((Object)to, from.getLocation().m_82549_(offset), to.getLocation().m_82549_(offset)).colored(active ? new Color(0, 203, 150) : new Color(255, 50, 150)).lineWidth(width);
        }
    }

    public static void visualizePotentialLocations() {
        boolean skipHints;
        Minecraft mc = Minecraft.m_91087_();
        Entity camera = mc.f_91075_;
        if (camera == null) {
            return;
        }
        if (mc.f_91074_ == null) {
            return;
        }
        boolean bl = skipHints = !EntityUtils.isHoldingItem((Player)mc.f_91074_, item -> item instanceof TrackSwitchBlockItem);
        if (skipHints) {
            HitResult hitResult = mc.f_91077_;
            if (!(hitResult instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            BlockPos pos = blockHitResult.m_82425_();
            BlockState state = mc.f_91074_.f_19853_.m_8055_(pos);
            if (!(state.m_60734_() instanceof TrackSwitchBlock)) {
                return;
            }
        }
        int range = 64;
        int rangeSqr = range * range;
        for (TrackGraph graph : CreateClient.RAILWAYS.trackNetworks.values()) {
            for (TrackNodeLocation tnl : graph.getNodes()) {
                TrackNode node;
                Map connections;
                int connectionCount;
                if (!Objects.equals(tnl.dimension, mc.f_91073_.m_46472_()) || tnl.getLocation().m_82557_(camera.m_20182_()) > (double)rangeSqr) continue;
                for (TrackSwitch sw : graph.getPoints(CREdgePointTypes.SWITCH)) {
                    TrackSwitchDebugVisualizer.visualizeSwitchExits(sw);
                }
                if (skipHints || (connectionCount = (connections = graph.getConnectionsFrom(node = graph.locateNode(tnl))).size()) <= 2 || connectionCount > 4) continue;
                Vec3 basePos = node.getLocation().getLocation();
                Vec3 averageOffset = Vec3.f_82478_;
                Vec3[] offsets = new Vec3[connectionCount];
                int i = 0;
                for (Map.Entry entry : connections.entrySet()) {
                    Vec3 offset = ((TrackNode)entry.getKey()).getLocation().getLocation().m_82546_(basePos).m_82541_();
                    averageOffset = averageOffset.m_82549_(offset);
                    offsets[i] = offset;
                    ++i;
                }
                Vec3 farthestOffset = Vec3.f_82478_;
                double farthestDistance = 0.0;
                for (Vec3 offset : offsets) {
                    double distance = averageOffset.m_82557_(offset);
                    if (!(distance > farthestDistance)) continue;
                    farthestDistance = distance;
                    farthestOffset = offset;
                }
                Direction offsetDirection = Direction.m_122366_((double)farthestOffset.f_82479_, (double)farthestOffset.f_82480_, (double)farthestOffset.f_82481_);
                CreateClient.OUTLINER.showAABB((Object)node, AABB.m_165882_((Vec3)tnl.getLocation().m_82520_(farthestOffset.f_82479_ / 2.0, farthestOffset.f_82480_ / 2.0, farthestOffset.f_82481_ / 2.0).m_82520_(0.0, 0.5, 0.0), (double)1.0, (double)1.0, (double)1.0)).colored(graph.color).lineWidth(0.0625f);
            }
        }
    }
}

