/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data;

import com.railwayteam.railways.base.data.forge.CRTagGenImpl;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CRTags;
import com.simibubi.create.AllBlocks;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class CRTagGen {
    private static final Map<TagKey<Block>, List<ResourceLocation>> OPTIONAL_TAGS = new HashMap<TagKey<Block>, List<ResourceLocation>>();

    @SafeVarargs
    public static void addOptionalTag(ResourceLocation id, TagKey<Block> ... tags) {
        for (TagKey<Block> tag : tags) {
            OPTIONAL_TAGS.computeIfAbsent(tag, e -> new ArrayList()).add(id);
        }
    }

    public static void generateBlockTags(RegistrateTagsProvider<Block> prov) {
        prov.addTag(CRTags.AllBlockTags.SEMAPHORE_POLES.tag).add((Object[])new Block[]{(Block)AllBlocks.METAL_GIRDER.get(), (Block)AllBlocks.METAL_GIRDER_ENCASED_SHAFT.get()}).forceAddTag(BlockTags.f_13039_);
        prov.addTag(CRTags.AllBlockTags.TRACK_CASING_BLACKLIST.tag);
        for (CRTags.AllBlockTags tag : CRTags.AllBlockTags.values()) {
            if (!tag.alwaysDatagen) continue;
            CRTagGen.tagAppender(prov, tag);
        }
        for (TagKey tagKey : OPTIONAL_TAGS.keySet()) {
            TagsProvider.TagAppender<Block> appender = CRTagGen.tagAppender(prov, tagKey);
            for (ResourceLocation loc : OPTIONAL_TAGS.get(tagKey)) {
                appender.m_176839_(loc);
            }
        }
    }

    public static void generateItemTags(RegistrateTagsProvider<Item> prov) {
        CommonTags.DYES.values().forEach(tag -> tag.generateCommon(prov));
        CommonTags.IRON_NUGGETS.generateCommon(prov);
        CommonTags.ZINC_NUGGETS.generateCommon(prov);
        CommonTags.BRASS_NUGGETS.generateCommon(prov);
        CommonTags.COPPER_INGOTS.generateCommon(prov);
        CommonTags.BRASS_INGOTS.generateCommon(prov);
        CommonTags.IRON_INGOTS.generateCommon(prov);
        CommonTags.STRING.generateCommon(prov).generateBoth(prov, tag -> tag.m_255204_(Items.f_42401_.m_204114_().m_205785_()));
        CommonTags.IRON_PLATES.generateCommon(prov);
        CommonTags.BRASS_PLATES.generateCommon(prov);
        CommonTags.WORKBENCH.generateCommon(prov).generateBoth(prov, tag -> tag.m_255204_(Items.f_41960_.m_204114_().m_205785_()));
        prov.addTag(CRTags.AllItemTags.NOT_TRAIN_FUEL.tag);
        for (CRTags.AllItemTags tag2 : CRTags.AllItemTags.values()) {
            if (!tag2.alwaysDatagen) continue;
            CRTagGen.tagAppender(prov, tag2);
        }
    }

    public static TagsProvider.TagAppender<Item> tagAppender(RegistrateTagsProvider<Item> prov, CRTags.AllItemTags tag) {
        return CRTagGen.tagAppender(prov, tag.tag);
    }

    public static TagsProvider.TagAppender<Block> tagAppender(RegistrateTagsProvider<Block> prov, CRTags.AllBlockTags tag) {
        return CRTagGen.tagAppender(prov, tag.tag);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> TagsProvider.TagAppender<T> tagAppender(RegistrateTagsProvider<T> prov, TagKey<T> tag) {
        void var1_1;
        return CRTagGenImpl.tagAppender(prov, var1_1);
    }
}

