/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.util.DevCapeUtils;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class})
public class MixinPlayerInfo {
    @Shadow
    @Final
    private GameProfile f_105298_;
    @Shadow
    @Final
    private Map<MinecraftProfileTexture.Type, ResourceLocation> f_105299_;
    @Unique
    private boolean railway$texturesLoaded;
    private static ResourceLocation DEV_CAPE = Railways.asResource("textures/misc/dev_cape.png");

    @Inject(at={@At(value="HEAD")}, method={"getCapeLocation"})
    protected void registerTextures(CallbackInfoReturnable<ResourceLocation> cir) {
        if (!this.railway$texturesLoaded && DevCapeUtils.INSTANCE.useDevCape(this.f_105298_.getId())) {
            this.railway$texturesLoaded = true;
            this.f_105299_.put(MinecraftProfileTexture.Type.CAPE, DEV_CAPE);
        }
    }

    @Inject(method={"getCapeLocation"}, at={@At(value="RETURN")}, cancellable=true)
    private void skipCapeIfNeeded(CallbackInfoReturnable<ResourceLocation> cir) {
        if (Objects.equals(DEV_CAPE, cir.getReturnValue()) && !DevCapeUtils.INSTANCE.useDevCape(this.f_105298_.getId())) {
            cir.setReturnValue(null);
        }
    }
}

