/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.railwayteam.railways.mixin_interfaces.IUpdateCount;
import com.simibubi.create.content.trains.bogey.BogeyInstance;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.CarriageContraptionInstance;
import com.simibubi.create.foundation.utility.Couple;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CarriageContraptionInstance.class})
public abstract class MixinCarriageContraptionInstance
extends EntityInstance<CarriageContraptionEntity>
implements IUpdateCount {
    private int updateCount = 0;
    @Shadow(remap=false)
    private Couple<BogeyInstance> bogeys;

    private MixinCarriageContraptionInstance(MaterialManager materialManager, CarriageContraptionEntity entity) {
        super(materialManager, (Entity)entity);
    }

    @Override
    public int snr_getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public void snr_fromParent(IUpdateCount parent) {
        this.updateCount = parent.snr_getUpdateCount();
    }

    @Override
    public void snr_markUpdate() {
        ++this.updateCount;
    }

    @Inject(method={"beginFrame"}, at={@At(value="HEAD")}, remap=false)
    private void snr_refreshBogeys(CallbackInfo ci) {
        if (IUpdateCount.outOfSync(this, (IUpdateCount)this.entity)) {
            if (this.bogeys != null) {
                this.bogeys.forEach(instance -> {
                    if (instance != null) {
                        instance.renderer.remove();
                        instance.commonRenderer.ifPresent(BogeyRenderer::remove);
                    }
                });
                this.bogeys = null;
            }
            this.snr_fromParent((IUpdateCount)this.entity);
        }
    }
}

