/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.railwayteam.railways.content.conductor.ClientHandler;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.content.conductor.vent.VentBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.EntityUtils;
import com.railwayteam.railways.util.ItemUtils;
import com.railwayteam.railways.util.Utils;
import com.railwayteam.railways.util.packet.CameraMovePacket;
import com.railwayteam.railways.util.packet.SetCameraViewPacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerItem;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ConductorEntity
extends AbstractGolem {
    public static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.fromString("B0FADEE5-4411-3475-ADD0-C4EA7E30D050"), "[Conductor]");
    private final FrequencyHolder frequencies = new FrequencyHolder();
    public static final WorldAttached<Set<ConductorEntity>> WITH_TOOLBOXES = new WorldAttached(w -> new HashSet());
    public static final EntityDataAccessor<Byte> COLOR = SynchedEntityData.m_135353_(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<BlockPos> BLOCK = SynchedEntityData.m_135353_(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Integer> JOB = SynchedEntityData.m_135353_(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> HOLDING_SCHEDULES = SynchedEntityData.m_135353_(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Map<String, Couple<EntityDataAccessor<ItemStack>>> FREQUENCY_DATA = new HashMap<String, Couple<EntityDataAccessor<ItemStack>>>();
    private static final Vec3i REACH;
    private ServerPlayer fakePlayer = null;
    MountedToolbox toolbox = null;
    private List<ItemStack> heldSchedules;
    public double firstGoodX;
    public double firstGoodY;
    public double firstGoodZ;
    public double lastGoodX;
    public double lastGoodY;
    public double lastGoodZ;
    public int receivedMovePacketCount;
    public int knownMovePacketCount;
    public double xLast;
    public double yLast;
    public double zLast;
    public double xRotLast;
    public double yRotLast;
    public int ventCooldown = 0;
    public static final List<Player> RECENTLY_DISMOUNTED_PLAYERS;
    @NotNull
    private WeakReference<ServerPlayer> currentlyViewing = new WeakReference<Object>(null);
    private int initialChunkLoadingDistance = 0;
    private boolean hasSentChunks = false;
    public SectionPos oldSectionPos = null;
    public float oBob;
    public float bob;
    @OnlyIn(value=Dist.CLIENT)
    public PlayerModel<?> visualBaseModel;
    @OnlyIn(value=Dist.CLIENT)
    public Player visualBaseEntity;
    private boolean rotateAnyway = false;
    private Float flyingSpeedOverride = null;
    protected FrequencyListener forwardListener;
    protected FrequencyListener backwardListener;
    protected FrequencyListener leftListener;
    protected FrequencyListener rightListener;
    protected FrequencyListener jumpListener;
    protected FrequencyListener sneakListener;

    public static boolean isPlayerDisguised(Player player) {
        if (player.m_150109_() == null) {
            return false;
        }
        ItemStack headStack = player.m_6844_(EquipmentSlot.HEAD);
        if (headStack.m_41619_()) {
            return false;
        }
        if (!CRTags.AllItemTags.CONDUCTOR_CAPS.matches(headStack)) {
            return false;
        }
        String hoverName = headStack.m_41786_().getString();
        return hoverName.startsWith("[sus]") || hoverName.equals("sus");
    }

    public static boolean canSpyInteract(BlockState blockState) {
        Block block = blockState.m_60734_();
        return blockState.m_204336_(BlockTags.f_13093_) || blockState.m_204336_(BlockTags.f_13036_) || block instanceof LeverBlock || block instanceof VentBlock || CRTags.AllBlockTags.CONDUCTOR_SPY_USABLE.matches(blockState);
    }

    public ItemStack getSecondaryHeadStack() {
        return ItemStack.f_41583_;
    }

    private void resetPosition() {
        this.firstGoodX = this.lastGoodX = this.m_20185_();
        this.firstGoodY = this.lastGoodY = this.m_20186_();
        this.firstGoodZ = this.lastGoodZ = this.m_20189_();
        this.knownMovePacketCount = this.receivedMovePacketCount;
    }

    public void doCheckFallDamage(double y, boolean onGround) {
        if (this.m_146899_()) {
            return;
        }
        BlockPos blockPos = this.m_20097_();
        super.m_7840_(y, onGround, this.f_19853_.m_8055_(blockPos), blockPos);
    }

    public void m_6135_() {
        super.m_6135_();
    }

    public void teleportToForce(double x, double y, double z) {
        ServerPlayer player;
        this.m_19890_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20199_().forEach(entity -> {
            for (Entity entity2 : entity.m_20197_()) {
                entity.m_7332_(entity2);
            }
        });
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().m_8387_(TicketType.f_9448_, new ChunkPos(this.m_20183_()), 5, (Object)this.m_19879_());
        }
        this.firstGoodX = x;
        this.firstGoodY = y;
        this.firstGoodZ = z;
        this.lastGoodX = x;
        this.lastGoodY = y;
        this.lastGoodZ = z;
        if (this.isPossessed() && (player = (ServerPlayer)this.currentlyViewing.get()) != null) {
            CRPackets.PACKETS.sendTo(player, (S2CPacket)new CameraMovePacket(this, new ServerboundMovePlayerPacket.PosRot(x, y, z, this.m_146908_(), this.m_146909_(), this.m_20096_())));
        }
    }

    public void setChunkLoadingDistance(int chunkLoadingDistance) {
        this.initialChunkLoadingDistance = chunkLoadingDistance;
    }

    public boolean hasSentChunks() {
        return this.hasSentChunks;
    }

    public void setHasSentChunks(boolean hasSentChunks) {
        this.hasSentChunks = hasSentChunks;
    }

    public static boolean hasRecentlyDismounted(Player player) {
        return RECENTLY_DISMOUNTED_PLAYERS.remove(player);
    }

    public boolean startViewing(ServerPlayer player) {
        ServerPlayer current = (ServerPlayer)this.currentlyViewing.get();
        if (current != null && current.m_8954_() == this && current.m_6084_() && current != player) {
            return false;
        }
        ServerLevel serverLevel = player.m_284548_();
        if (serverLevel != this.f_19853_) {
            return false;
        }
        this.currentlyViewing = new WeakReference<ServerPlayer>(player);
        this.oldSectionPos = null;
        SectionPos chunkPos = SectionPos.m_123199_((BlockPos)this.m_20183_());
        int viewDistance = player.f_8924_.m_6846_().m_11312_();
        Entity entity = player.m_8954_();
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)entity;
            conductor.stopViewing(player);
        }
        this.setChunkLoadingDistance(viewDistance);
        player.f_8926_ = this;
        CRPackets.PACKETS.sendTo(player, (S2CPacket)new SetCameraViewPacket((Entity)this));
        this.resetPosition();
        return true;
    }

    public void stopViewing(ServerPlayer player) {
        if (!this.f_19853_.f_46443_) {
            this.currentlyViewing.clear();
            player.f_8926_ = player;
            CRPackets.PACKETS.sendTo(player, (S2CPacket)new SetCameraViewPacket((Entity)player));
            RECENTLY_DISMOUNTED_PLAYERS.add((Player)player);
        }
    }

    public void onSpyInteract(BlockPos pos) {
        BlockState state;
        if (this.canReach((Vec3i)pos) && ConductorEntity.canSpyInteract(state = this.f_19853_.m_8055_(pos)) && this.fakePlayer != null) {
            boolean canUse;
            ClipContext context = new ClipContext(this.m_146892_(), new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.fakePlayer);
            BlockHitResult hitResult = this.f_19853_.m_45547_(context);
            if (!pos.equals((Object)hitResult.m_82425_())) {
                return;
            }
            boolean bl = canUse = state.m_60808_((BlockGetter)this.f_19853_, pos).m_83281_() || EntityUtils.handleUseEvent((Player)this.fakePlayer, InteractionHand.MAIN_HAND, hitResult);
            if (canUse) {
                Block block = state.m_60734_();
                if (block instanceof VentBlock) {
                    VentBlock ventBlock = (VentBlock)block;
                    ventBlock.teleportConductor(this.f_19853_, pos, (Entity)this, hitResult.m_82434_().m_122424_());
                } else {
                    state.m_60664_(this.f_19853_, (Player)this.fakePlayer, InteractionHand.MAIN_HAND, hitResult);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_5686_(float partialTicks) {
        if (ClientHandler.isPossessed(this)) {
            return this.m_146909_();
        }
        return super.m_5686_(partialTicks);
    }

    public boolean m_6047_() {
        return this.f_19853_.f_46443_ ? (this.visualBaseEntity != null ? this.visualBaseEntity.m_6047_() : super.m_6047_()) : super.m_6047_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_20115_(int flag, boolean set) {
        super.m_20115_(flag, set);
    }

    public boolean isPossessed() {
        return this.f_19853_.f_46443_ ? ClientHandler.isPossessed(this) : this.currentlyViewing.get() != null;
    }

    public boolean isPossessedAndClient() {
        return this.f_19853_.f_46443_ && this.isPossessed();
    }

    public void turnView(double yRot, double xRot) {
        float f = (float)xRot * 0.15f;
        float g = (float)yRot * 0.15f;
        this.rotateAnyway = true;
        this.m_146926_(this.m_146909_() + f);
        this.m_146922_(this.m_146908_() + g);
        this.rotateAnyway = true;
        this.m_146926_(Mth.m_14036_((float)this.m_146909_(), (float)-90.0f, (float)90.0f));
        this.f_19860_ += f;
        this.f_19859_ += g;
        this.f_19860_ = Mth.m_14036_((float)this.f_19860_, (float)-90.0f, (float)90.0f);
        if (this.m_20202_() != null) {
            this.m_20202_().m_7340_((Entity)this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_5675_(float partialTick) {
        return this.m_20159_() || !this.isPossessed() ? super.m_5675_(partialTick) : this.m_146908_();
    }

    private boolean consumeRotateAnyway() {
        if (this.rotateAnyway) {
            this.rotateAnyway = false;
            return true;
        }
        return false;
    }

    public void m_146926_(float xRot) {
        if (this.isPossessedAndClient() && !this.consumeRotateAnyway()) {
            return;
        }
        super.m_146926_(xRot);
    }

    protected boolean m_196406_(@NotNull Vec3 deltaMovement) {
        if (!this.isPossessedAndClient()) {
            return super.m_196406_(deltaMovement);
        }
        float f = this.m_146908_() * ((float)Math.PI / 180);
        double d0 = Mth.m_14031_((float)f);
        double d1 = Mth.m_14089_((float)f);
        double d2 = (double)this.f_20900_ * d1 - (double)this.f_20902_ * d0;
        double d3 = (double)this.f_20902_ * d1 + (double)this.f_20900_ * d0;
        double d4 = Mth.m_144952_((double)d2) + Mth.m_144952_((double)d3);
        double d5 = Mth.m_144952_((double)deltaMovement.f_82479_) + Mth.m_144952_((double)deltaMovement.f_82481_);
        if (!(d4 < (double)1.0E-5f) && !(d5 < (double)1.0E-5f)) {
            double d6 = d2 * deltaMovement.f_82479_ + d3 * deltaMovement.f_82481_;
            double d7 = Math.acos(d6 / Math.sqrt(d4 * d5));
            return d7 < 0.13962633907794952;
        }
        return false;
    }

    public void updatePossessionInputs() {
        if (this.isPossessedAndClient()) {
            this._updatePossessionInputs();
        }
    }

    private static float calculateImpulse(boolean input, boolean otherInput) {
        if (input == otherInput) {
            return 0.0f;
        }
        return input ? 1.0f : -1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void _updatePossessionInputs() {
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
        this.f_20902_ = ConductorEntity.calculateImpulse(ConductorPossessionController.wasUpPressed(), ConductorPossessionController.wasDownPressed());
        this.f_20900_ = ConductorEntity.calculateImpulse(ConductorPossessionController.wasLeftPressed(), ConductorPossessionController.wasRightPressed());
        if (!ConductorPossessionController.wasSprintPressed()) {
            this.f_20902_ *= 0.3f;
            this.f_20900_ *= 0.3f;
        }
        this.f_20899_ = ConductorPossessionController.wasJumpPressed();
        this.flyingSpeedOverride = Float.valueOf(0.2f);
        if (ConductorPossessionController.wasSprintPressed()) {
            this.flyingSpeedOverride = Float.valueOf(this.flyingSpeedOverride.floatValue() + 0.006f);
        }
    }

    protected float m_274460_() {
        return this.flyingSpeedOverride == null ? super.m_274460_() : this.flyingSpeedOverride.floatValue();
    }

    public void m_7334_(@NotNull Entity entity) {
        if (ConductorPossessionController.getPossessingConductor(entity) == this) {
            return;
        }
        super.m_7334_(entity);
    }

    public boolean m_6094_() {
        return super.m_6094_() && !this.isPossessed();
    }

    public boolean m_6109_() {
        return super.m_6109_() || this.isPossessedAndClient();
    }

    private boolean suffocatesAt(BlockPos pos) {
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB((double)pos.m_123341_(), aabb.f_82289_, (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, aabb.f_82292_, (double)pos.m_123343_() + 1.0).m_82406_(1.0E-7);
        return this.f_19853_.m_186437_((Entity)this, aabb1);
    }

    private void moveTowardsClosestSpace(double x, double z) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)this.m_20186_(), (double)z);
        if (this.suffocatesAt(blockpos)) {
            double d0 = x - (double)blockpos.m_123341_();
            double d1 = z - (double)blockpos.m_123343_();
            Direction direction = null;
            double d2 = Double.MAX_VALUE;
            Direction[] adirection = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH};
            for (Direction direction1 : adirection) {
                double d3 = direction1.m_122434_().m_6150_(d0, 0.0, d1);
                double d4 = direction1.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 - d3 : d3;
                double d = d4;
                if (!(d4 < d2) || this.suffocatesAt(blockpos.m_121945_(direction1))) continue;
                d2 = d4;
                direction = direction1;
            }
            if (direction != null) {
                Vec3 vec3 = this.m_20184_();
                if (direction.m_122434_() == Direction.Axis.X) {
                    this.m_20334_(0.1 * (double)direction.m_122429_(), vec3.f_82480_, vec3.f_82481_);
                } else {
                    this.m_20334_(vec3.f_82479_, vec3.f_82480_, 0.1 * (double)direction.m_122431_());
                }
            }
        }
    }

    public void m_8107_() {
        if (this.isPossessedAndClient()) {
            this.oBob = this.bob;
            this.f_20885_ = this.m_146908_();
            if (!this.f_19794_) {
                this.moveTowardsClosestSpace(this.m_20185_() - (double)this.m_20205_() * 0.35, this.m_20189_() + (double)this.m_20205_() * 0.35);
                this.moveTowardsClosestSpace(this.m_20185_() - (double)this.m_20205_() * 0.35, this.m_20189_() - (double)this.m_20205_() * 0.35);
                this.moveTowardsClosestSpace(this.m_20185_() + (double)this.m_20205_() * 0.35, this.m_20189_() - (double)this.m_20205_() * 0.35);
                this.moveTowardsClosestSpace(this.m_20185_() + (double)this.m_20205_() * 0.35, this.m_20189_() + (double)this.m_20205_() * 0.35);
            }
        }
        super.m_8107_();
        if (this.isPossessedAndClient()) {
            float f = !this.m_20096_() || this.m_21224_() || this.m_6069_() ? 0.0f : Math.min(0.1f, (float)this.m_20184_().m_165924_());
            this.bob += (f - this.bob) * 0.4f;
        }
    }

    protected void updateFrequencyListeners() {
        this.forwardListener = new FrequencyListener("forward");
        this.backwardListener = new FrequencyListener("backward");
        this.leftListener = new FrequencyListener("left");
        this.rightListener = new FrequencyListener("right");
        this.jumpListener = new FrequencyListener("jump");
        this.sneakListener = new FrequencyListener("sneak");
    }

    private List<ItemStack> getHeldSchedules() {
        if (this.heldSchedules == null) {
            this.heldSchedules = new ArrayList<ItemStack>();
        }
        return this.heldSchedules;
    }

    public ConductorEntity(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.m_274367_(0.5f);
    }

    public boolean isHoldingSchedules() {
        return !this.getHeldSchedules().isEmpty();
    }

    public boolean isHoldingSchedulesClient() {
        return (Boolean)this.f_19804_.m_135370_(HOLDING_SCHEDULES);
    }

    public void addSchedule(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        this.getHeldSchedules().add(stack.m_41777_());
        this.f_19804_.m_135381_(HOLDING_SCHEDULES, (Object)true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)ConductorEntity.idFrom(ConductorEntity.defaultColor()));
        this.f_19804_.m_135372_(BLOCK, (Object)this.m_20183_());
        this.f_19804_.m_135372_(JOB, (Object)Job.DEFAULT.ordinal());
        this.f_19804_.m_135372_(HOLDING_SCHEDULES, (Object)this.isHoldingSchedules());
        for (Map.Entry<String, Couple<EntityDataAccessor<ItemStack>>> entry : FREQUENCY_DATA.entrySet()) {
            for (boolean first : Iterate.trueAndFalse) {
                this.f_19804_.m_135372_((EntityDataAccessor)entry.getValue().get(first), (Object)ItemStack.f_41583_);
            }
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new ConductorLookedAtGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ConductorPonderBlockGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FollowToolboxPlayerGoal(this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new RemoteControlGoal(this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f){

            public boolean m_8036_() {
                return super.m_8036_() && !ConductorEntity.this.isPossessed();
            }

            public boolean m_8045_() {
                return super.m_8045_() && !ConductorEntity.this.isPossessed();
            }
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22285_, 8.0);
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.f_19853_)).remove((Object)this);
    }

    public void m_142036_() {
        ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.f_19853_)).remove((Object)this);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        LivingEntity living;
        if (this.m_20201_() instanceof CarriageContraptionEntity) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_150930_((Item)AllItems.WRENCH.get())) {
            pAmount = 10.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected int m_7302_(int pAir) {
        return pAir;
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pDimensions) {
        return pDimensions.f_20378_ * 0.76f;
    }

    public boolean canReach(Vec3i pos) {
        return pos.m_203193_((Position)this.m_20182_()) <= REACH.m_123331_(Vec3i.f_123288_);
    }

    protected boolean isToolbox(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ToolboxBlock;
    }

    public boolean isCarryingToolbox() {
        return this.toolbox != null;
    }

    public ItemStack getToolboxDisplayStack() {
        if (this.isCarryingToolbox()) {
            return this.toolbox.getDisplayStack();
        }
        return ItemStack.f_41583_;
    }

    protected void setToolbox(@Nullable MountedToolbox toolbox) {
        this.toolbox = toolbox;
        if (toolbox != null) {
            ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.f_19853_)).add(this);
        } else {
            ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.f_19853_)).remove((Object)this);
        }
    }

    @Nullable
    public MountedToolbox getToolbox() {
        return this.toolbox;
    }

    @NotNull
    public MountedToolbox getOrCreateToolboxHolder() {
        if (!this.isCarryingToolbox()) {
            this.setToolbox(new MountedToolbox(this, DyeColor.BROWN));
        }
        return this.toolbox;
    }

    public void equipToolbox(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof ToolboxBlock) {
            ToolboxBlock toolbox = (ToolboxBlock)item;
            this.setToolbox(new MountedToolbox(this, toolbox.getColor()));
            this.toolbox.readFromItem(stack);
            this.toolbox.sendData();
            this.setJob(Job.TOOLBOX_CARRIER);
        }
    }

    public void setJob(Job job) {
        this.m_20088_().m_135381_(JOB, (Object)job.ordinal());
    }

    public Job getJob() {
        return Job.values()[(Integer)this.m_20088_().m_135370_(JOB)];
    }

    public void m_6457_(@NotNull ServerPlayer pServerPlayer) {
        super.m_6457_(pServerPlayer);
        if (this.toolbox != null) {
            this.toolbox.sendData();
        }
    }

    public ItemStack unequipToolbox() {
        this.setJob(Job.DEFAULT);
        if (this.f_19853_.f_46443_ || this.toolbox == null) {
            if (this.toolbox != null) {
                this.toolbox.m_7651_();
            }
            this.setToolbox(null);
            return ItemStack.f_41583_;
        }
        this.toolbox.unequipTracked();
        ItemStack itemStack = this.toolbox.getCloneItemStack();
        this.toolbox.m_7651_();
        this.setToolbox(null);
        return itemStack;
    }

    protected void openToolbox(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MountedToolbox.openMenu(serverPlayer, this.toolbox);
        }
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        Item item = player.m_21120_(hand).m_41720_();
        if (item instanceof DyeItem) {
            DyeItem di = (DyeItem)item;
            this.setColor(di.m_41089_());
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_41720_().equals(AllBlocks.ANDESITE_CASING.asStack().m_41720_())) {
            if (this.m_21223_() < this.m_21233_()) {
                this.m_21153_(this.m_21233_());
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (!this.isCarryingToolbox() && this.isToolbox(player.m_21120_(hand)) && this.getJob() == Job.DEFAULT) {
                this.equipToolbox(player.m_21120_(hand));
                player.m_21120_(hand).m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (this.isCarryingToolbox()) {
                if (player.m_6144_() && player.m_21120_(hand).m_41619_()) {
                    player.m_21008_(hand, this.unequipToolbox());
                } else if (!this.f_19853_.f_46443_) {
                    this.openToolbox(player);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(hand).m_41619_() && !this.getHeldSchedules().isEmpty()) {
                for (ItemStack item2 : this.heldSchedules) {
                    if (player.m_36356_(item2)) continue;
                    player.m_36176_(item2, false);
                }
                this.f_19804_.m_135381_(HOLDING_SCHEDULES, (Object)false);
                this.getHeldSchedules().clear();
            } else {
                if (this.getJob() == Job.DEFAULT && AllBlocks.REDSTONE_LINK.isIn(player.m_21120_(hand))) {
                    this.setJob(Job.REMOTE_CONTROL);
                    player.m_21120_(hand).m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
                if (this.getJob() == Job.REMOTE_CONTROL) {
                    if (player.m_6144_() && player.m_21120_(hand).m_41619_()) {
                        player.m_21008_(hand, AllBlocks.REDSTONE_LINK.asStack());
                        this.setJob(Job.DEFAULT);
                    } else if (player.m_21120_(hand).m_41720_() instanceof LinkedControllerItem) {
                        int i = 0;
                        for (Consumer<Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> freq : this.frequencies.settersInOrder()) {
                            freq.accept(Optional.of(LinkedControllerItem.toFrequency((ItemStack)player.m_21120_(hand), (int)i)));
                            ++i;
                        }
                        this.updateFrequencyListeners();
                    }
                } else {
                    if (this.getJob() == Job.DEFAULT && AllItems.GOGGLES.isIn(player.m_21120_(hand))) {
                        this.setJob(Job.SPY);
                        player.m_21120_(hand).m_41774_(1);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.getJob() == Job.SPY && player.m_6144_() && player.m_21120_(hand).m_41619_()) {
                        player.m_21008_(hand, AllItems.GOGGLES.asStack());
                        this.setJob(Job.DEFAULT);
                    }
                }
            }
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12198_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return AllSoundEvents.CRUSHING_1.getMainEvent();
    }

    public void m_8119_() {
        Level level;
        this.resetPosition();
        SectionPos sectionPos = SectionPos.m_235861_((EntityAccess)this);
        if (!sectionPos.equals((Object)this.oldSectionPos)) {
            this.setHasSentChunks(false);
        }
        if (this.f_19853_.f_46443_) {
            ConductorPossessionController.tryUpdatePossession(this);
            this.updatePossessionInputs();
        }
        super.m_8119_();
        if (this.ventCooldown > 0) {
            --this.ventCooldown;
        }
        if ((level = this.f_19853_) instanceof ServerLevel) {
            Object t;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.fakePlayer == null) {
                this.fakePlayer = EntityUtils.createConductorFakePlayer(serverLevel);
            }
            if ((t = this.currentlyViewing.get()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)t;
                SectionPos chunkPos = SectionPos.m_123199_((BlockPos)this.m_20183_());
                int viewDistance = player.f_8924_.m_6846_().m_11312_();
                for (int x = chunkPos.m_123341_() - viewDistance; x <= chunkPos.m_123341_() + viewDistance; ++x) {
                    for (int z = chunkPos.m_123343_() - viewDistance; z <= chunkPos.m_123343_() + viewDistance; ++z) {
                        serverLevel.m_7726_().m_8387_(TicketType.f_9445_, new ChunkPos(x, z), 3, (Object)new ChunkPos(x, z));
                    }
                }
            }
        }
        if (this.toolbox != null) {
            this.toolbox.tick();
        }
    }

    public static ConductorEntity spawn(Level level, BlockPos pos, ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ConductorCapItem)) {
            return null;
        }
        ConductorCapItem cap = (ConductorCapItem)item;
        ConductorEntity result = new ConductorEntity((EntityType<? extends AbstractGolem>)((EntityType)CREntities.CONDUCTOR.get()), level);
        result.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        result.setColor(cap.color);
        result.m_255207_(stack);
        level.m_7967_((Entity)result);
        return result;
    }

    public boolean isInMinecart() {
        return this.m_20202_() instanceof AbstractMinecart;
    }

    public static DyeColor defaultColor() {
        return DyeColor.BLUE;
    }

    public void setColor(DyeColor color) {
        this.m_20088_().m_135381_(COLOR, (Object)ConductorEntity.idFrom(color));
    }

    public DyeColor getColor() {
        return ConductorEntity.colorFrom((Byte)this.f_19804_.m_135370_(COLOR));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCorrectEngineerCap(ItemStack hat) {
        if (hat.m_41619_()) {
            return true;
        }
        Item item = hat.m_41720_();
        if (!(item instanceof ConductorCapItem)) return false;
        ConductorCapItem cap = (ConductorCapItem)item;
        if (cap.color != this.getColor()) return false;
        return true;
    }

    boolean isLookingAtMe(Player player) {
        if (player.m_5833_()) {
            return false;
        }
        boolean looking = false;
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (this.isCorrectEngineerCap(helmet) || !ItemUtils.blocksEndermanView(helmet, player, null)) {
            Vec3 headLine;
            Vec3 playerView = player.m_20252_(1.0f).m_82541_();
            double angle = playerView.m_82526_(headLine = this.m_146892_().m_82546_(player.m_146892_()).m_82541_());
            looking = angle > 0.983 && player.m_142582_((Entity)this);
        }
        return looking;
    }

    public static DyeColor colorFrom(byte b) {
        if (b >= 16) {
            return null;
        }
        return DyeColor.m_41053_((int)b);
    }

    public static byte idFrom(DyeColor color) {
        int c = color.m_41060_();
        if (c >= 16) {
            return 16;
        }
        return (byte)c;
    }

    public boolean canUseBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13093_) || state.m_60713_(Blocks.f_50164_) || state.m_60734_() instanceof TrackSwitchBlock;
    }

    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        Job job = this.getJob();
        ItemStack holdingStack = this.unequipToolbox();
        if (!holdingStack.m_41619_()) {
            this.m_19983_(holdingStack);
        }
        if (this.isHoldingSchedules()) {
            for (ItemStack scheduleStack : this.getHeldSchedules()) {
                this.m_19983_(scheduleStack);
            }
        }
        if (job == Job.REMOTE_CONTROL) {
            this.m_19983_(AllBlocks.REDSTONE_LINK.asStack());
        } else if (job == Job.SPY) {
            this.m_19983_(AllItems.GOGGLES.asStack());
        }
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("target", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)this.m_20088_().m_135370_(BLOCK))));
        nbt.m_128344_("color", ((Byte)this.m_20088_().m_135370_(COLOR)).byteValue());
        if (this.toolbox != null) {
            CompoundTag toolboxTag = new CompoundTag();
            this.toolbox.write(toolboxTag, false);
            nbt.m_128365_("toolboxHolder", (Tag)toolboxTag);
        }
        if (this.getHeldSchedules().size() != 0) {
            ListTag schedulesTag = new ListTag();
            boolean hasItem = false;
            for (ItemStack heldSchedule : this.heldSchedules) {
                if (heldSchedule.m_41619_()) continue;
                schedulesTag.add((Object)heldSchedule.m_41739_(new CompoundTag()));
                hasItem = true;
            }
            if (hasItem) {
                nbt.m_128365_("heldSchedules", (Tag)schedulesTag);
            }
        }
        nbt.m_128359_("job", this.getJob().name());
        nbt.m_128365_("frequencies", (Tag)this.frequencies.write());
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("color", 1)) {
            this.m_20088_().m_135381_(COLOR, (Object)nbt.m_128445_("color"));
        }
        if (nbt.m_128425_("target", 10)) {
            this.m_20088_().m_135381_(BLOCK, (Object)NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("target")));
        }
        if (nbt.m_128425_("toolboxHolder", 10)) {
            this.setToolbox(MountedToolbox.read(this, nbt.m_128469_("toolboxHolder")));
        } else {
            this.setToolbox(null);
        }
        if (nbt.m_128425_("job", 8)) {
            this.setJob(Job.valueOf(nbt.m_128461_("job")));
        } else {
            this.setJob(Job.DEFAULT);
        }
        this.getHeldSchedules().clear();
        if (nbt.m_128425_("heldSchedules", 9)) {
            ListTag schedulesTag = nbt.m_128437_("heldSchedules", 10);
            for (int i = 0; i < schedulesTag.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)schedulesTag.m_128728_(i));
                if (stack.m_41619_()) continue;
                this.getHeldSchedules().add(stack);
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(HOLDING_SCHEDULES, (Object)this.isHoldingSchedules());
            this.frequencies.read(nbt.m_128469_("frequencies"));
            this.updateFrequencyListeners();
        }
    }

    static {
        for (String name : List.of("forward", "backward", "left", "right", "jump", "sneak")) {
            FREQUENCY_DATA.put(name, (Couple<EntityDataAccessor<ItemStack>>)Couple.create((Object)SynchedEntityData.m_135353_(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_), (Object)SynchedEntityData.m_135353_(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_)));
        }
        REACH = new Vec3i(3, 2, 3);
        RECENTLY_DISMOUNTED_PLAYERS = new ArrayList<Player>();
    }

    public class FrequencyListener
    implements IRedstoneLinkable {
        public final String key;
        @Nullable
        public final Couple<RedstoneLinkNetworkHandler.Frequency> frequency;
        public int receivedStrength = 0;

        public FrequencyListener(String key) {
            this.key = key;
            this.frequency = ConductorEntity.this.frequencies.entries().get(this.key).orElse(null);
            if (this.frequency != null) {
                Create.REDSTONE_LINK_NETWORK_HANDLER.addToNetwork((LevelAccessor)ConductorEntity.this.f_19853_, (IRedstoneLinkable)this);
            }
        }

        public int getTransmittedStrength() {
            return 0;
        }

        public void setReceivedStrength(int power) {
            this.receivedStrength = power;
        }

        public boolean isListening() {
            return true;
        }

        public boolean isAlive() {
            return ConductorEntity.this.m_6084_() && this.frequency != null;
        }

        public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
            return this.frequency;
        }

        public BlockPos getLocation() {
            return ConductorEntity.this.m_20183_();
        }

        public boolean isPowered() {
            return this.receivedStrength > 0;
        }
    }

    public class FrequencyHolder
    implements Iterable<Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> {
        public FrequencyHolder() {
        }

        public FrequencyHolder(@Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> forward, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> backward, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> left, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> right, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> jump, Couple<RedstoneLinkNetworkHandler.Frequency> sneak) {
            this.setForward(forward);
            this.setBackward(backward);
            this.setLeft(left);
            this.setRight(right);
            this.setJump(jump);
            this.setSneak(sneak);
        }

        @Override
        @NotNull
        public @NotNull Iterator<Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>> iterator() {
            return List.of(Optional.ofNullable(this.getForward()), Optional.ofNullable(this.getBackward()), Optional.ofNullable(this.getLeft()), Optional.ofNullable(this.getRight()), Optional.ofNullable(this.getJump()), Optional.ofNullable(this.getSneak())).iterator();
        }

        public Map<String, Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>> entries() {
            return Map.of("forward", Optional.ofNullable(this.getForward()), "backward", Optional.ofNullable(this.getBackward()), "left", Optional.ofNullable(this.getLeft()), "right", Optional.ofNullable(this.getRight()), "jump", Optional.ofNullable(this.getJump()), "sneak", Optional.ofNullable(this.getSneak()));
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public Map<String, Couple<@NotNull ItemStack>> stacks() {
            HashMap<String, @NotNull Couple> stacks = new HashMap<String, Couple>();
            for (Map.Entry<String, Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> entry : this.entries().entrySet()) {
                if (entry.getValue().isEmpty()) {
                    stacks.put(entry.getKey(), Couple.create((Object)ItemStack.f_41583_, (Object)ItemStack.f_41583_));
                    continue;
                }
                Couple<// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull RedstoneLinkNetworkHandler.Frequency> freqs = entry.getValue().get();
                stacks.put(entry.getKey(), Couple.create((Object)((RedstoneLinkNetworkHandler.Frequency)freqs.getFirst()).getStack(), (Object)((RedstoneLinkNetworkHandler.Frequency)freqs.getSecond()).getStack()));
            }
            return ImmutableMap.copyOf(stacks);
        }

        public Map<String, Consumer<Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>>> setters() {
            return Map.of("forward", freq -> this.setForward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "backward", freq -> this.setBackward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "left", freq -> this.setLeft((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "right", freq -> this.setRight((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "jump", freq -> this.setJump((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "sneak", freq -> this.setSneak((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))));
        }

        public List<Consumer<Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>>> settersInOrder() {
            return List.of(freq -> this.setForward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setBackward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setLeft((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setRight((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setJump((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setSneak((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))));
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry<String, Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> freq : this.entries().entrySet()) {
                if (!freq.getValue().isPresent()) continue;
                CompoundTag subTag = new CompoundTag();
                subTag.m_128365_("first", (Tag)((RedstoneLinkNetworkHandler.Frequency)freq.getValue().get().getFirst()).getStack().m_41739_(new CompoundTag()));
                subTag.m_128365_("second", (Tag)((RedstoneLinkNetworkHandler.Frequency)freq.getValue().get().getSecond()).getStack().m_41739_(new CompoundTag()));
                tag.m_128365_(freq.getKey(), (Tag)subTag);
            }
            return tag;
        }

        public FrequencyHolder read(CompoundTag tag) {
            for (Map.Entry<String, Consumer<Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>>> freq : this.setters().entrySet()) {
                if (tag.m_128425_(freq.getKey(), 10)) {
                    ItemStack first = ItemStack.m_41712_((CompoundTag)tag.m_128469_(freq.getKey()).m_128469_("first"));
                    ItemStack second = ItemStack.m_41712_((CompoundTag)tag.m_128469_(freq.getKey()).m_128469_("second"));
                    freq.getValue().accept(Optional.of(Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)first), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)second))));
                    continue;
                }
                freq.getValue().accept(Optional.empty());
            }
            return this;
        }

        private static Couple<ItemStack> freqToStacks(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> freqs) {
            if (freqs == null) {
                return Couple.create((Object)ItemStack.f_41583_, (Object)ItemStack.f_41583_);
            }
            return freqs.map(RedstoneLinkNetworkHandler.Frequency::getStack);
        }

        private static Couple<RedstoneLinkNetworkHandler.Frequency> stacksToFreq(Couple<ItemStack> stacks) {
            return stacks.map(RedstoneLinkNetworkHandler.Frequency::of);
        }

        private void set(String name, @Nullable Couple<RedstoneLinkNetworkHandler.Frequency> value) {
            Couple<ItemStack> stacks = FrequencyHolder.freqToStacks(value);
            Couple<EntityDataAccessor<ItemStack>> freqAccessors = FREQUENCY_DATA.get(name);
            for (boolean first : Iterate.trueAndFalse) {
                ConductorEntity.this.f_19804_.m_135381_((EntityDataAccessor)freqAccessors.get(first), (Object)((ItemStack)stacks.get(first)));
            }
        }

        private Couple<RedstoneLinkNetworkHandler.Frequency> get(String name) {
            Couple<EntityDataAccessor<ItemStack>> freqAccessors = FREQUENCY_DATA.get(name);
            return FrequencyHolder.stacksToFreq((Couple<ItemStack>)freqAccessors.map(arg_0 -> ((SynchedEntityData)ConductorEntity.this.f_19804_).m_135370_(arg_0)));
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getForward() {
            return this.get("forward");
        }

        public void setForward(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> forward) {
            this.set("forward", forward);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getBackward() {
            return this.get("backward");
        }

        public void setBackward(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> backward) {
            this.set("backward", backward);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getLeft() {
            return this.get("left");
        }

        public void setLeft(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> left) {
            this.set("left", left);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getRight() {
            return this.get("right");
        }

        public void setRight(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> right) {
            this.set("right", right);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getJump() {
            return this.get("jump");
        }

        public void setJump(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> jump) {
            this.set("jump", jump);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getSneak() {
            return this.get("sneak");
        }

        public void setSneak(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> sneak) {
            this.set("sneak", sneak);
        }
    }

    public static enum Job {
        REDSTONE_OPERATOR,
        TOOLBOX_CARRIER,
        REMOTE_CONTROL,
        SPY;

        public static final Job DEFAULT;

        static {
            DEFAULT = REDSTONE_OPERATOR;
        }
    }

    static class ConductorLookedAtGoal
    extends JobBasedGoal {
        @Nullable
        private LivingEntity target;

        public ConductorLookedAtGoal(ConductorEntity conductor) {
            super(conductor, Job.REDSTONE_OPERATOR);
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            for (Player player : this.conductor.f_19853_.m_6907_()) {
                if (!player.m_142582_((Entity)this.conductor)) continue;
                return this.conductor.m_20280_((Entity)player) < 256.0 && this.conductor.isLookingAtMe(player);
            }
            return false;
        }

        public void m_8056_() {
            Level level = this.conductor.f_19853_;
            BlockPos pos = (BlockPos)this.conductor.m_20088_().m_135370_(BLOCK);
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            ServerPlayer fake = this.conductor.fakePlayer;
            if (this.conductor.canReach((Vec3i)pos) && this.conductor.canUseBlock(state) && fake != null) {
                boolean canUse;
                ClipContext context = new ClipContext(this.conductor.m_146892_(), new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)fake);
                BlockHitResult hitResult = level.m_45547_(context);
                if (!pos.equals((Object)hitResult.m_82425_())) {
                    return;
                }
                boolean bl = canUse = state.m_60808_((BlockGetter)level, pos).m_83281_() || EntityUtils.handleUseEvent((Player)fake, InteractionHand.MAIN_HAND, hitResult);
                if (canUse) {
                    state.m_60664_(level, (Player)fake, InteractionHand.MAIN_HAND, hitResult);
                }
            }
        }

        public void m_8037_() {
            if (this.target != null) {
                this.conductor.f_21365_.m_148051_((Entity)this.target);
            }
        }
    }

    static class ConductorPonderBlockGoal
    extends JobBasedGoal {
        private BlockPos target;

        public ConductorPonderBlockGoal(ConductorEntity conductor) {
            super(conductor, Job.REDSTONE_OPERATOR);
            this.target = (BlockPos)conductor.f_19804_.m_135370_(BLOCK);
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            this.target = (BlockPos)this.conductor.f_19804_.m_135370_(BLOCK);
            if (this.conductor.canReach((Vec3i)this.target) && this.conductor.canUseBlock(this.conductor.f_19853_.m_8055_(this.target))) {
                return true;
            }
            for (int y = -REACH.m_123342_(); y < REACH.m_123342_(); ++y) {
                for (int x = -REACH.m_123341_(); x < REACH.m_123341_(); ++x) {
                    for (int z = -REACH.m_123343_(); z < REACH.m_123343_(); ++z) {
                        ClipContext context;
                        BlockHitResult hitResult;
                        BlockPos at = this.conductor.m_20183_().m_7918_(x, y, z);
                        BlockState state = this.conductor.f_19853_.m_8055_(at);
                        if (!this.conductor.canUseBlock(state) || !(hitResult = this.conductor.f_19853_.m_45547_(context = new ClipContext(this.conductor.m_146892_(), new Vec3((double)at.m_123341_(), (double)at.m_123342_(), (double)at.m_123343_()), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null))).m_82425_().equals((Object)at)) continue;
                        this.target = at;
                        this.conductor.f_19804_.m_135381_(BLOCK, (Object)this.target);
                        return true;
                    }
                }
            }
            return false;
        }

        public void m_8037_() {
            this.conductor.f_21365_.m_24946_((double)this.target.m_123341_(), (double)this.target.m_123342_(), (double)this.target.m_123343_());
        }
    }

    static class FollowToolboxPlayerGoal
    extends JobBasedGoal {
        protected final double speedModifier;
        @Nullable
        protected Player target;
        protected int timeToRecalcPath;

        public FollowToolboxPlayerGoal(ConductorEntity conductor, double speedModifier) {
            super(conductor, Job.TOOLBOX_CARRIER);
            this.speedModifier = speedModifier;
        }

        public void m_8037_() {
            super.m_8037_();
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (this.conductor.m_20280_((Entity)this.target) > 16.0) {
                    this.conductor.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
                } else {
                    this.conductor.m_21573_().m_26573_();
                }
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.conductor.isCarryingToolbox() && !this.conductor.getToolbox().getConnectedPlayers().isEmpty();
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && this.conductor.isCarryingToolbox() && this.conductor.getToolbox().getConnectedPlayers().contains(this.target) && this.target.m_6084_() && !this.target.m_5833_();
        }

        public void m_8056_() {
            super.m_8056_();
            List<Player> players = this.conductor.getToolbox().getConnectedPlayers();
            this.target = players.get(this.conductor.f_19796_.m_188503_(players.size()));
        }

        public void m_8041_() {
            super.m_8041_();
            this.target = null;
        }
    }

    static class RemoteControlGoal
    extends JobBasedGoal {
        protected final double speedModifier;
        protected Vec3 targetDirection = Vec3.f_82478_;
        protected double targetStrength = 15.0;
        private int honkPacketCooldown = 0;
        private boolean usedToHonk;

        public RemoteControlGoal(ConductorEntity conductor, double speedModifier) {
            super(conductor, Job.REMOTE_CONTROL);
            this.speedModifier = speedModifier;
        }

        protected double getGroundY(Vec3 vec) {
            BlockPos blockPos = BlockPos.m_274446_((Position)vec);
            return this.conductor.f_19853_.m_8055_(blockPos.m_7495_()).m_60795_() ? vec.f_82480_ : WalkNodeEvaluator.m_77611_((BlockGetter)this.conductor.f_19853_, (BlockPos)blockPos);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void m_8037_() {
            CarriageContraptionEntity cce;
            super.m_8037_();
            Pair<Vec3, Double> pair = this.calculateTarget();
            this.targetDirection = (Vec3)pair.getFirst();
            this.targetStrength = (Double)pair.getSecond();
            Vec3 target = this.conductor.m_20182_().m_82549_(this.targetDirection.m_82490_(2.0));
            Entity entity = this.conductor.m_20201_();
            if (entity instanceof CarriageContraptionEntity && (cce = (CarriageContraptionEntity)entity).getControllingPlayer().isEmpty() && (entity = cce.getContraption()) instanceof CarriageContraption) {
                CarriageContraption cc = (CarriageContraption)entity;
                if (this.conductor.fakePlayer != null) {
                    ScheduleRuntime runtime;
                    BlockPos seat = cc.getSeatOf(this.conductor.f_19820_);
                    if (seat == null) {
                        return;
                    }
                    Couple controlsPresent = (Couple)cc.conductorSeats.get(seat);
                    if (controlsPresent == null) {
                        return;
                    }
                    if (cce.getCarriage() != null && (runtime = cce.getCarriage().train.runtime).getSchedule() != null && !runtime.completed && !runtime.paused) {
                        return;
                    }
                    BlockPos controlsPos = null;
                    BlockPos reverseControlsPos = null;
                    if (((Boolean)controlsPresent.getFirst()).booleanValue()) {
                        controlsPos = seat.m_121945_(cc.getAssemblyDirection().m_122424_());
                    }
                    if (((Boolean)controlsPresent.getSecond()).booleanValue()) {
                        if (controlsPos == null) {
                            controlsPos = seat.m_121945_(cc.getAssemblyDirection());
                        } else {
                            reverseControlsPos = seat.m_121945_(cc.getAssemblyDirection());
                        }
                    }
                    if (controlsPos == null) {
                        return;
                    }
                    Set<Integer> controls = this.getControls();
                    if (reverseControlsPos != null && controls.contains(1) && !controls.contains(0)) {
                        controls.remove(1);
                        controls.add(0);
                        controlsPos = reverseControlsPos;
                    }
                    boolean isSprintKeyPressed = controls.remove(5);
                    cce.control(controlsPos, controls, (Player)this.conductor.fakePlayer);
                    Train train = cce.getCarriage().train;
                    if (isSprintKeyPressed && this.honkPacketCooldown-- <= 0) {
                        train.determineHonk(this.conductor.f_19853_);
                        if (train.lowHonk != null) {
                            Utils.sendHonkPacket(train, true);
                            this.honkPacketCooldown = 5;
                            this.usedToHonk = true;
                        }
                    }
                    if (isSprintKeyPressed) return;
                    if (!this.usedToHonk) return;
                    Utils.sendHonkPacket(train, false);
                    this.honkPacketCooldown = 0;
                    this.usedToHonk = false;
                    return;
                }
            }
            if (!(this.targetDirection.m_82556_() > 0.01)) return;
            this.conductor.m_21566_().m_6849_(target.f_82479_, this.getGroundY(target), target.f_82481_, this.speedModifier * this.targetStrength / 15.0);
        }

        private Set<Integer> getControls() {
            HashSet<Integer> controls = new HashSet<Integer>();
            if (this.conductor.forwardListener != null && this.conductor.forwardListener.isPowered()) {
                controls.add(0);
            }
            if (this.conductor.backwardListener != null && this.conductor.backwardListener.isPowered()) {
                controls.add(1);
            }
            if (this.conductor.leftListener != null && this.conductor.leftListener.isPowered()) {
                controls.add(2);
            }
            if (this.conductor.rightListener != null && this.conductor.rightListener.isPowered()) {
                controls.add(3);
            }
            if (this.conductor.jumpListener != null && this.conductor.jumpListener.isPowered()) {
                controls.add(4);
            }
            if (this.conductor.sneakListener != null && this.conductor.sneakListener.isPowered()) {
                controls.add(5);
            }
            return controls;
        }

        private Pair<Vec3, Double> calculateTarget() {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (this.conductor.forwardListener != null && this.conductor.forwardListener.isPowered()) {
                z -= (double)this.conductor.forwardListener.receivedStrength;
            }
            if (this.conductor.backwardListener != null && this.conductor.backwardListener.isPowered()) {
                z += (double)this.conductor.backwardListener.receivedStrength;
            }
            if (this.conductor.leftListener != null && this.conductor.leftListener.isPowered()) {
                x -= (double)this.conductor.leftListener.receivedStrength;
            }
            if (this.conductor.rightListener != null && this.conductor.rightListener.isPowered()) {
                x += (double)this.conductor.rightListener.receivedStrength;
            }
            if (this.conductor.jumpListener != null && this.conductor.jumpListener.isPowered()) {
                y += (double)this.conductor.jumpListener.receivedStrength;
            }
            if (this.conductor.sneakListener != null && this.conductor.sneakListener.isPowered()) {
                y -= (double)this.conductor.sneakListener.receivedStrength;
            }
            double avgStrength = 0.0;
            int count = 0;
            if (x != 0.0) {
                avgStrength += Math.abs(x);
                ++count;
            }
            if (y != 0.0) {
                avgStrength += Math.abs(y);
                ++count;
            }
            if (z != 0.0) {
                avgStrength += Math.abs(z);
                ++count;
            }
            return Pair.of((Object)new Vec3(x, Math.max(0.0, y), z).m_82490_(0.06666666666666667), (Object)(count == 0 ? 0.0 : avgStrength / (double)count));
        }

        public void m_8056_() {
            super.m_8056_();
            Pair<Vec3, Double> pair = this.calculateTarget();
            this.targetDirection = (Vec3)pair.getFirst();
            this.targetStrength = (Double)pair.getSecond();
        }

        public void m_8041_() {
            super.m_8041_();
            this.targetDirection = Vec3.f_82478_;
            this.targetStrength = 15.0;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class JobBasedGoal
    extends Goal {
        private final Job job;
        protected final ConductorEntity conductor;

        public JobBasedGoal(ConductorEntity conductor, Job job) {
            this.conductor = conductor;
            this.job = job;
        }

        public boolean m_8036_() {
            return this.conductor.getJob() == this.job && !this.conductor.isPossessed();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }
}

