/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.cycle_menu;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class TagCycleTracker {
    private final List<class_6862<class_1792>> CYCLING_TAGS = new ArrayList<class_6862<class_1792>>();
    private final Map<class_6862<class_1792>, List<class_1792>> CYCLES = new HashMap<class_6862<class_1792>, List<class_1792>>();
    private final Map<class_1792, class_6862<class_1792>> REVERSE_LOOKUP = new HashMap<class_1792, class_6862<class_1792>>();
    private boolean cyclesComputed = false;

    public void registerCycle(class_6862<class_1792> tag) {
        if (!this.CYCLING_TAGS.contains(tag)) {
            this.CYCLING_TAGS.add(tag);
        }
    }

    public void scheduleRecompute() {
        this.cyclesComputed = false;
    }

    public void computeCycles() {
        this.CYCLES.clear();
        this.REVERSE_LOOKUP.clear();
        this.CYCLING_TAGS.forEach(tag -> this.CYCLES.put((class_6862<class_1792>)tag, new ArrayList()));
        class_7923.field_41178.method_40270().forEachOrdered(item -> {
            for (class_6862<class_1792> tag : this.CYCLING_TAGS) {
                if (!item.method_40220(tag)) continue;
                this.CYCLES.get(tag).add((class_1792)item.comp_349());
                this.REVERSE_LOOKUP.put((class_1792)item.comp_349(), tag);
            }
        });
        this.cyclesComputed = true;
    }

    @Nullable
    public class_6862<class_1792> getCycleTag(class_1792 item) {
        if (!this.cyclesComputed) {
            this.computeCycles();
        }
        return this.REVERSE_LOOKUP.get(item);
    }

    public List<class_1792> getCycle(class_6862<class_1792> tag) {
        if (!this.cyclesComputed) {
            this.computeCycles();
        }
        return this.CYCLES.getOrDefault(tag, (List<class_1792>)ImmutableList.of());
    }
}

