/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.ModSetup;
import com.railwayteam.railways.base.data.CRTagGen;
import com.railwayteam.railways.base.data.RailwaysHatOffsetGenerator;
import com.railwayteam.railways.base.data.compat.emi.EmiExcludedTagGen;
import com.railwayteam.railways.base.data.compat.emi.EmiRecipeDefaultsGen;
import com.railwayteam.railways.base.data.lang.CRLangGen;
import com.railwayteam.railways.base.data.recipe.RailwaysMechanicalCraftingRecipeGen;
import com.railwayteam.railways.base.data.recipe.RailwaysSequencedAssemblyRecipeGen;
import com.railwayteam.railways.base.data.recipe.RailwaysStandardRecipeGen;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.fabric.RailwaysImpl;
import com.railwayteam.railways.multiloader.Loader;
import com.railwayteam.railways.registry.CRCommands;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.MethodVarHandleUtils;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2403;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class Railways {
    public static final String MOD_ID = "railways";
    public static final String ID_NAME = "Railways";
    public static final String NAME = "Steam 'n' Rails";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Railways");
    public static final int DATA_FIXER_VERSION = 2;
    private static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"railways");

    private static void migrateConfig(Path path, Function<String, String> converter) {
        block9: {
            try {
                String migrated;
                String str = new String(Files.readAllBytes(path));
                if (!str.contains("#General settings") && !str.contains("[general]")) break block9;
                try {
                    migrated = converter.apply(new String(Files.readAllBytes(path)));
                }
                catch (IOException e) {
                    break block9;
                }
                try (FileWriter writer = new FileWriter(path.toFile());){
                    writer.write(migrated);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void init() {
        String createVersion = MethodVarHandleUtils.getStaticField(Create.class, "VERSION", String.class, "UNKNOWN");
        LOGGER.info("{} v{} initializing! Commit hash: {} on Create version: {} on platform: {}", new Object[]{NAME, "1.6.8", "1cac86965a13b06cfb26445158a32bccf7b73d93", createVersion, Loader.getFormatted()});
        Path configDir = Utils.configDir();
        Path clientConfigDir = configDir.resolve("railways-client.toml");
        Railways.migrateConfig(clientConfigDir, CRConfigs::migrateClient);
        Path commonConfigDir = configDir.resolve("railways-common.toml");
        Railways.migrateConfig(commonConfigDir, CRConfigs::migrateCommon);
        ModSetup.register();
        Railways.finalizeRegistrate();
        Railways.registerCommands(CRCommands::register);
        CRPackets.PACKETS.registerC2SListener();
        if (Utils.isDevEnv() && !Mods.BYG.isLoaded && !Mods.SODIUM.isLoaded && !Utils.isEnvVarTrue("DATAGEN")) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
    }

    public static class_2960 asResource(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void gatherData(class_2403.class_7856 gen) {
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, CRTagGen::generateBlockTags);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, CRTagGen::generateItemTags);
        REGISTRATE.addDataGenerator(ProviderType.LANG, CRLangGen::generate);
        PonderLocalization.provideRegistrateLang((AbstractRegistrate)REGISTRATE);
        gen.method_46566(RailwaysSequencedAssemblyRecipeGen::new);
        gen.method_46566(RailwaysStandardRecipeGen::new);
        gen.method_46566(RailwaysMechanicalCraftingRecipeGen::create);
        gen.method_46566(EmiExcludedTagGen::new);
        gen.method_46566(EmiRecipeDefaultsGen::new);
        gen.method_46566(RailwaysHatOffsetGenerator::new);
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void finalizeRegistrate() {
        RailwaysImpl.finalizeRegistrate();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerCommands(BiConsumer<CommandDispatcher<class_2168>, Boolean> consumer) {
        RailwaysImpl.registerCommands(consumer);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((class_1792)item))));
    }
}

