/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.bogey_menu.handler.BogeyMenuHandlerServer;
import com.railwayteam.railways.content.handcar.HandcarBlock;
import com.railwayteam.railways.mixin_interfaces.IIndexedSchedule;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={StationBlockEntity.class}, remap=false)
public abstract class MixinStationBlockEntity
extends SmartBlockEntity {
    private Train dropScheduleTrain;

    @Shadow
    @Nullable
    public abstract GlobalStation getStation();

    private MixinStationBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"trackClicked"}, at={@At(value="HEAD")})
    private void storePlayer(class_1657 player, class_1268 hand, ITrackBlock track, class_2680 state, class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        BogeyMenuHandlerServer.setCurrentPlayer(player.method_5667());
    }

    @Inject(method={"trackClicked"}, at={@At(value="RETURN")})
    private void clearPlayer(class_1657 player, class_1268 hand, ITrackBlock track, class_2680 state, class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        BogeyMenuHandlerServer.setCurrentPlayer(null);
    }

    @Inject(method={"trackClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", remap=true)}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=true, require=0)
    private void railways$setBogeyData(class_1657 player, class_1268 hand, ITrackBlock track, class_2680 state, class_2338 pos, CallbackInfoReturnable<Boolean> cir, class_3341 bb, class_2338 up, class_2338 down, int bogeyOffset, class_1799 handItem, boolean upsideDown, class_2338 targetPos) {
        TrackMaterial.TrackType trackType;
        if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            return;
        }
        Pair<BogeyStyle, BogeySizes.BogeySize> styleData = BogeyMenuHandlerServer.getStyle(player.method_5667());
        BogeyStyle style = (BogeyStyle)styleData.getFirst();
        Optional<BogeyStyle> mappedStyleOptional = CRBogeyStyles.getMapped(style, trackType = track.getMaterial().trackType, true);
        if (mappedStyleOptional.isPresent()) {
            style = mappedStyleOptional.get();
        }
        if (style == AllBogeyStyles.STANDARD) {
            return;
        }
        class_2586 class_25862 = this.field_11863.method_8321(targetPos);
        if (class_25862 instanceof AbstractBogeyBlockEntity) {
            AbstractBogeyBlockEntity bogeyBE = (AbstractBogeyBlockEntity)class_25862;
            bogeyBE.setBogeyStyle(style);
        }
    }

    @Inject(method={"tryDisassembleTrain"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/GlobalStation;getPresentTrain()Lcom/simibubi/create/content/trains/entity/Train;")})
    private void storeTrainForDropping(class_3222 sender, CallbackInfoReturnable<Boolean> cir) {
        this.dropScheduleTrain = this.getStation() == null ? null : this.getStation().getPresentTrain();
    }

    @Inject(method={"tryDisassembleTrain"}, at={@At(value="RETURN")})
    private void clearDropTrain(class_3222 sender, CallbackInfoReturnable<Boolean> cir) {
        this.dropScheduleTrain = null;
    }

    @Redirect(method={"dropSchedule"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/GlobalStation;getPresentTrain()Lcom/simibubi/create/content/trains/entity/Train;"), require=0)
    private Train returnOverridenTrain(GlobalStation instance) {
        Train train = instance.getPresentTrain();
        if (train == null) {
            train = this.dropScheduleTrain;
        }
        this.dropScheduleTrain = null;
        return train;
    }

    @Inject(method={"assemble"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;", ordinal=0)}, require=0)
    private void allowAssemblingWithoutControls(UUID playerUUID, CallbackInfo ci, @Local(name={"typeOfFirstBogey"}) AbstractBogeyBlock<?> typeOfFirstBogey, @Local(name={"atLeastOneForwardControls"}) LocalBooleanRef atLeastOneForwardControls) {
        if (typeOfFirstBogey instanceof HandcarBlock) {
            atLeastOneForwardControls.set(true);
        }
    }

    @Inject(method={"applyAutoSchedule"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/schedule/ScheduleRuntime;setSchedule(Lcom/simibubi/create/content/trains/schedule/Schedule;Z)V")})
    private void setScheduleIndexOnAutoSchedule(CallbackInfo ci, @Local Train imminentTrain) {
        int idx = 0;
        ((IIndexedSchedule)imminentTrain).railways$setIndex(0);
        for (Carriage carriage : imminentTrain.carriages) {
            if (carriage.presentConductors.either(b -> b)) {
                ((IIndexedSchedule)imminentTrain).railways$setIndex(idx);
                if (!Utils.isDevEnv()) break;
                Railways.LOGGER.info("[SET_INDEX {}] on train {} called in MixinStationBlockEntity#setScheduleIndexOnAutoSchedule", (Object)idx, (Object)imminentTrain.name.getString());
                break;
            }
            ++idx;
        }
    }
}

