/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.base.item.DyedItemList;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.bank.IDCardItem;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BankingGuideItem;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.EnumMap;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class NumismaticsItems {
    private static final CreateRegistrate REGISTRATE = Numismatics.registrate();
    public static final EnumMap<Coin, ItemEntry<CoinItem>> COINS = new EnumMap(Coin.class);
    public static final DyedItemList<CardItem> CARDS;
    public static final DyedItemList<IDCardItem> ID_CARDS;
    public static final ItemEntry<BankingGuideItem> BANKING_GUIDE;

    private static ItemEntry<CoinItem> makeCoin(Coin coin) {
        return REGISTRATE.item(coin.getName(), CoinItem.create(coin)).tag(new class_6862[]{NumismaticsTags.AllItemTags.COINS.tag}).lang(coin.getDisplayName()).properties(p -> p.method_7894(coin.rarity)).model((c, p) -> p.generated((NonNullSupplier)c, new class_2960[]{p.modLoc("item/coin/" + coin.getName())})).register();
    }

    public static ItemEntry<CoinItem> getCoin(Coin coin) {
        return COINS.get((Object)coin);
    }

    public static void register() {
        Numismatics.LOGGER.info("Registering items for Create: Numismatics");
    }

    static {
        for (Coin coin : Coin.values()) {
            COINS.put(coin, NumismaticsItems.makeCoin(coin));
        }
        CARDS = new DyedItemList<CardItem>(color -> {
            String colorName = color.method_15434();
            return ((ItemBuilder)REGISTRATE.item(colorName + "_card", p -> new CardItem((class_1792.class_1793)p, (class_1767)color)).properties(p -> p.method_7889(1)).tag(new class_6862[]{NumismaticsTags.AllItemTags.CARDS.tag}).lang(TextUtils.titleCaseConversion(color.method_7792()) + " Card").model((c, p) -> p.generated((NonNullSupplier)c, new class_2960[]{Numismatics.asResource("item/card/" + colorName + "_card")})).onRegisterAfter(class_7924.field_41197, v -> ItemDescription.useKey((class_1935)v, (String)"item.numismatics.bank_card"))).register();
        });
        ID_CARDS = new DyedItemList<IDCardItem>(color -> {
            String colorName = color.method_15434();
            return ((ItemBuilder)REGISTRATE.item(colorName + "_id_card", p -> new IDCardItem((class_1792.class_1793)p, (class_1767)color)).properties(p -> p.method_7889(16)).tag(new class_6862[]{NumismaticsTags.AllItemTags.ID_CARDS.tag}).lang(TextUtils.titleCaseConversion(color.method_7792()) + " ID Card").model((c, p) -> p.generated((NonNullSupplier)c, new class_2960[]{Numismatics.asResource("item/id_card/" + colorName + "_id_card")})).onRegisterAfter(class_7924.field_41197, v -> ItemDescription.useKey((class_1935)v, (String)"item.numismatics.id_card"))).register();
        });
        BANKING_GUIDE = REGISTRATE.item("banking_guide", BankingGuideItem::new).lang("Banking Guide").register();
    }
}

