/*
 * Decompiled with CFR 0.152.
 */
package com.sudolev.interiors;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.sudolev.interiors.content.registry.CIBlocks;
import com.sudolev.interiors.content.registry.CIEntities;
import com.sudolev.interiors.content.registry.CITab;
import com.sudolev.interiors.foundation.data.CIDatagen;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="interiors")
public final class CreateInteriors {
    public static final String ID = "interiors";
    public static final String NAME = CreateInteriors.getModProperty(IModInfo::getDisplayName);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)NAME);
    public static final String VERSION = CreateInteriors.getModProperty(IModInfo::getVersion);
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"interiors");

    public CreateInteriors() {
        IEventBus forge = MinecraftForge.EVENT_BUS;
        IEventBus mod = REGISTRATE.getModEventBus();
        LOGGER.info("{} v{} initializing", (Object)NAME, (Object)VERSION);
        CITab.register(mod);
        CIBlocks.register();
        CIEntities.register();
        forge.register((Object)this);
        mod.addListener(EventPriority.LOWEST, CIDatagen::gatherData);
        REGISTRATE.registerEventListeners(mod);
    }

    private static String getModProperty(Function<IModInfo, ?> f) {
        List infoList = ModList.get().getModFileById(ID).getMods();
        if (infoList.size() > 1 && LOGGER != null) {
            LOGGER.error("Multiple mods for ID: interiors");
        }
        for (IModInfo info : infoList) {
            if (!info.getModId().equals(ID)) continue;
            return f.apply(info).toString();
        }
        return "UNKNOWN";
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE));
    }
}

