/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.LargeDieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.entity.BlockEntityRegistry;
import com.jesz.createdieselgenerators.blocks.entity.LargeDieselGeneratorValueBox;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.jesz.createdieselgenerators.sounds.SoundRegistry;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LargeDieselGeneratorBlockEntity
extends GeneratingKineticBlockEntity {
    public WeakReference<LargeDieselGeneratorBlockEntity> controller = new WeakReference<Object>(null);
    BlockPos controllerPos = null;
    int tick;
    public int length;
    int lastLength;
    Fluid lastFluid;
    public SmartFluidTankBehaviour tank;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public AbstractComputerBehaviour computerBehaviour;
    int soundCounter = 0;
    boolean validFuel;

    public LargeDieselGeneratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)LargeDieselGeneratorBlock.PIPE)).booleanValue()) {
            LargeDieselGeneratorBlockEntity controller = (LargeDieselGeneratorBlockEntity)((Object)this.controller.get());
            if (cap == ForgeCapabilities.FLUID_HANDLER && (side == Direction.UP || side == null)) {
                if (controller != null) {
                    return controller.tank.getCapability().cast();
                }
                return this.tank.getCapability().cast();
            }
        }
        return super.getCapability(cap, side);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Tick", this.tick);
        if (this.controllerPos != null) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos));
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tick = compound.m_128451_("Tick");
        this.controllerPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)Lang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new LargeDieselGeneratorValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void onDirectionChanged() {
        LargeDieselGeneratorBlockEntity controller = (LargeDieselGeneratorBlockEntity)((Object)this.controller.get());
        if (controller == null) {
            return;
        }
        LargeDieselGeneratorBlockEntity lastEngine = this.getBackEngine();
        if (lastEngine == null) {
            return;
        }
        while (lastEngine != null) {
            lastEngine.movementDirection.setValue(this.movementDirection.getValue());
            lastEngine = lastEngine.getBackEngine();
        }
    }

    public void initialize() {
        this.updateConnectivity();
        super.initialize();
    }

    public float calculateAddedStressCapacity() {
        float capacity = 0.0f;
        if (this.f_58858_.equals((Object)this.controllerPos) && this.getGeneratedSpeed() != 0.0f && this.validFuel) {
            capacity = FuelTypeManager.getGeneratedStress((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) / Math.abs(this.getGeneratedSpeed()) * (float)this.length;
        }
        this.lastCapacityProvided = capacity;
        return capacity;
    }

    public float getGeneratedSpeed() {
        if (!this.validFuel || !this.f_58858_.equals((Object)this.controllerPos)) {
            return 0.0f;
        }
        return LargeDieselGeneratorBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * FuelTypeManager.getGeneratedSpeed((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid())), (Direction)((Direction)this.m_58900_().m_61143_(LargeDieselGeneratorBlock.HORIZONTAL_FACING)));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        LargeDieselGeneratorBlockEntity controller = (LargeDieselGeneratorBlockEntity)((Object)this.controller.get());
        if (!IRotate.StressImpact.isEnabled() || controller == null) {
            return added;
        }
        float stressBase = controller.calculateAddedStressCapacity();
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return added;
        }
        if (controller != this) {
            Lang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float stressTotal = Math.abs(controller.getGeneratedSpeed() * stressBase);
            Lang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controller.tank.getCapability().cast());
    }

    public void tick() {
        if (((Boolean)this.m_58900_().m_61143_((Property)DieselGeneratorBlock.POWERED)).booleanValue()) {
            this.validFuel = false;
        } else {
            boolean bl = this.validFuel = FuelTypeManager.getGeneratedSpeed((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) != 0.0f;
        }
        if (!this.tank.getPrimaryHandler().getFluid().getFluid().m_6212_(this.lastFluid) || this.length != this.lastLength) {
            this.lastFluid = this.tank.getPrimaryHandler().getFluid().getFluid();
            this.lastLength = this.length;
            this.reActivateSource = true;
        }
        super.tick();
        LargeDieselGeneratorBlockEntity controller = (LargeDieselGeneratorBlockEntity)((Object)this.controller.get());
        if (controller == null) {
            return;
        }
        if (controller != this) {
            this.tank.getPrimaryHandler().drain(controller.tank.getPrimaryHandler().fill(this.tank.getPrimaryHandler().getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.soundCounter > FuelTypeManager.getSoundSpeed(controller.tank.getPrimaryHandler().getFluid().getFluid()) && controller.validFuel && !((Boolean)this.m_58900_().m_61143_((Property)DieselGeneratorBlock.SILENCED)).booleanValue()) {
            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (SoundEvent)SoundRegistry.DIESEL_ENGINE_SOUND.get(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
            this.soundCounter = 0;
        } else {
            ++this.soundCounter;
        }
        ++this.tick;
        if (this.tick >= 20) {
            this.tick = 0;
            if (this.validFuel) {
                if (this.tank.getPrimaryHandler().getFluid().getAmount() >= FuelTypeManager.getBurnRate((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) * this.length) {
                    this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)this.tank.getPrimaryHandler().getFluid(), (int)(this.tank.getPrimaryHandler().getFluid().getAmount() - FuelTypeManager.getBurnRate((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid()) * this.length)));
                } else {
                    this.tank.getPrimaryHandler().setFluid(FluidStack.EMPTY);
                }
            }
        }
    }

    public LargeDieselGeneratorBlockEntity getBackEngine() {
        LargeDieselGeneratorBlockEntity be;
        Direction facing = (Direction)this.m_58900_().m_61143_(LargeDieselGeneratorBlock.HORIZONTAL_FACING);
        if (facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            facing = facing.m_122424_();
        }
        return (be = (LargeDieselGeneratorBlockEntity)this.f_58857_.m_141902_(this.f_58858_.m_121945_(facing), (BlockEntityType)BlockEntityRegistry.LARGE_DIESEL_ENGINE.get()).orElse(null)) == null ? null : (((Direction)be.m_58900_().m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_() ? null : be);
    }

    public LargeDieselGeneratorBlockEntity getFrontEngine() {
        LargeDieselGeneratorBlockEntity be;
        Direction facing = (Direction)this.m_58900_().m_61143_(LargeDieselGeneratorBlock.HORIZONTAL_FACING);
        if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            facing = facing.m_122424_();
        }
        return (be = (LargeDieselGeneratorBlockEntity)this.f_58857_.m_141902_(this.f_58858_.m_121945_(facing), (BlockEntityType)BlockEntityRegistry.LARGE_DIESEL_ENGINE.get()).orElse(null)) == null ? null : (((Direction)be.m_58900_().m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122434_() ? null : be);
    }

    public void updateConnectivity() {
        LargeDieselGeneratorBlockEntity frontEngine = this.getFrontEngine();
        if (frontEngine != null) {
            frontEngine.updateConnectivity();
            return;
        }
        LargeDieselGeneratorBlockEntity backEngine = this.getBackEngine();
        this.controller = new WeakReference<LargeDieselGeneratorBlockEntity>(this);
        this.controllerPos = this.f_58858_;
        if (backEngine == null) {
            this.length = 1;
            return;
        }
        LargeDieselGeneratorBlockEntity lastEngine = backEngine;
        int length = 1;
        while (lastEngine != null) {
            lastEngine = lastEngine.getBackEngine();
            ++length;
        }
        this.length = length;
        for (lastEngine = backEngine; lastEngine != null; lastEngine = lastEngine.getBackEngine()) {
            lastEngine.length = length;
            lastEngine.controller = this.controller;
            lastEngine.controllerPos = this.controllerPos;
        }
    }

    public void removed() {
        for (LargeDieselGeneratorBlockEntity lastEngine = this.getBackEngine(); lastEngine != null; lastEngine = lastEngine.getBackEngine()) {
            this.tank.getPrimaryHandler().drain(lastEngine.tank.getPrimaryHandler().fill(this.tank.getPrimaryHandler().getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            lastEngine.length = 1;
            lastEngine.controller = new WeakReference<Object>(null);
        }
    }
}

