/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks;

import com.jesz.createdieselgenerators.blocks.entity.BlockEntityRegistry;
import com.jesz.createdieselgenerators.blocks.entity.OilBarrelBlockEntity;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.ForgeSoundType;

public class OilBarrelBlock
extends Block
implements IBE<OilBarrelBlockEntity>,
IWrenchable {
    public static final EnumProperty<OilBarrelColor> OIL_BARREL_COLOR = EnumProperty.m_61587_((String)"color", OilBarrelColor.class);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final SoundType SILENCED_METAL = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_12062_, () -> SoundEvents.f_12068_, () -> SoundEvents.f_12065_, () -> SoundEvents.f_12064_, () -> SoundEvents.f_12063_);

    public OilBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(OIL_BARREL_COLOR, (Comparable)((Object)OilBarrelColor.NONE)));
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, OilBarrelBlockEntity::updateConnectivity);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
        if (state.m_60734_() instanceof OilBarrelBlock && !context.m_43723_().m_6144_()) {
            return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
        }
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OIL_BARREL_COLOR, AXIS});
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof OilBarrelBlockEntity)) {
                return;
            }
            OilBarrelBlockEntity tankBE = (OilBarrelBlockEntity)be;
            world.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity be;
        if (context.m_43719_().m_122434_() != state.m_61143_(AXIS) && (be = context.m_43725_().m_7702_(context.m_8083_())) instanceof OilBarrelBlockEntity) {
            OilBarrelBlockEntity tankBE = (OilBarrelBlockEntity)be;
            context.m_43725_().m_46747_(context.m_8083_());
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
        return super.onWrenched(state, context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult r;
        ItemStack stackInHand = player.m_21120_(hand);
        if (stackInHand.m_204117_(Tags.Items.DYES_WHITE) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.WHITE)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_ORANGE) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.ORANGE)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_MAGENTA) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.MAGENTA)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_LIGHT_BLUE) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.LIGHT_BLUE)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_YELLOW) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.YELLOW)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_LIME) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.LIME)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_PINK) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.PINK)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_GRAY) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.GRAY)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_LIGHT_GRAY) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.LIGHT_GRAY)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_CYAN) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.CYAN)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_PURPLE) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.PURPLE)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_BLUE) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.BLUE)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_BROWN) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.BROWN)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_GREEN) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.GREEN)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_RED) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.RED)) != null) {
            return r;
        }
        if (stackInHand.m_204117_(Tags.Items.DYES_BLACK) && (r = this.tryDye(state, level, pos, player, stackInHand, OilBarrelColor.BLACK)) != null) {
            return r;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public InteractionResult tryDye(BlockState state, Level level, BlockPos pos, Player player, ItemStack stack, OilBarrelColor color) {
        if (state.m_61143_(OIL_BARREL_COLOR) == color) {
            OilBarrelBlockEntity be;
            OilBarrelBlockEntity controllerBE;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof OilBarrelBlockEntity && (controllerBE = (be = (OilBarrelBlockEntity)blockEntity).getControllerBE()) != null) {
                boolean successful = false;
                for (int x = 0; x < controllerBE.getWidth(); ++x) {
                    for (int z = 0; z < controllerBE.getWidth(); ++z) {
                        BlockPos offsetPos = state.m_61143_(AXIS) == Direction.Axis.X ? new BlockPos(pos.m_123341_(), be.getController().m_123342_() + x, be.getController().m_123343_() + z) : (state.m_61143_(AXIS) == Direction.Axis.Y ? be.getController().m_7918_(x, 0, z).m_175288_(pos.m_123342_()) : new BlockPos(be.getController().m_123341_() + x, be.getController().m_123342_() + z, pos.m_123343_()));
                        BlockState blockState = level.m_8055_(offsetPos);
                        if (!(blockState.m_60734_() instanceof OilBarrelBlock) || stack.m_41619_() || blockState.m_61143_(OIL_BARREL_COLOR) == color) continue;
                        level.m_7731_(offsetPos, (BlockState)state.m_61124_(OIL_BARREL_COLOR, (Comparable)((Object)color)), 2);
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        successful = true;
                    }
                }
                if (successful) {
                    return InteractionResult.SUCCESS;
                }
            }
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_(OIL_BARREL_COLOR, (Comparable)((Object)color)), 2);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return null;
    }

    public Class<OilBarrelBlockEntity> getBlockEntityClass() {
        return OilBarrelBlockEntity.class;
    }

    public BlockEntityType<? extends OilBarrelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockEntityRegistry.OIL_BARREL.get();
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public static enum OilBarrelColor implements StringRepresentable
    {
        WHITE,
        ORANGE,
        MAGENTA,
        LIGHT_BLUE,
        YELLOW,
        LIME,
        PINK,
        GRAY,
        LIGHT_GRAY,
        CYAN,
        PURPLE,
        BLUE,
        BROWN,
        GREEN,
        RED,
        BLACK,
        NONE;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

