/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.renderer;

import com.jesz.createdieselgenerators.PartialModels;
import com.jesz.createdieselgenerators.blocks.entity.PumpjackBearingBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.PumpjackCrankBlockEntity;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec2;

public class PumpjackCrankInstance
extends KineticBlockEntityInstance<PumpjackCrankBlockEntity>
implements DynamicInstance {
    protected final ModelData crank = (ModelData)this.getTransformMaterial().getModel(PartialModels.PUMPJACK_CRANK_SMALL).createInstance();
    protected final ModelData crank_rod = (ModelData)this.getTransformMaterial().getModel(PartialModels.PUMPJACK_CRANK_ROD_SMALL).createInstance();
    protected final ModelData large_crank = (ModelData)this.getTransformMaterial().getModel(PartialModels.PUMPJACK_CRANK_LARGE).createInstance();
    protected final ModelData large_crank_rod = (ModelData)this.getTransformMaterial().getModel(PartialModels.PUMPJACK_CRANK_ROD_LARGE).createInstance();
    protected final RotatingData shaft = this.setup((RotatingData)this.getRotatingMaterial().getModel(this.shaft()).createInstance());

    public PumpjackCrankInstance(MaterialManager materialManager, PumpjackCrankBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
    }

    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks() * 0.0f;
        float angle = AngleHelper.angleLerp((double)partialTicks, (double)((PumpjackCrankBlockEntity)this.blockEntity).prevAngle, (double)((PumpjackCrankBlockEntity)this.blockEntity).angle);
        PoseStack ms = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        msr.translate((Vec3i)this.getInstancePosition());
        boolean isXAxis = ((Direction)this.blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_() == Direction.Axis.X;
        double v = (double)(((isXAxis ? angle : -angle) + 90.0f) / 180.0f) * Math.PI;
        double sin = Math.sin(v) * (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? 0.8125 : 1.125);
        double cos = Math.cos(v) * (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? 0.8125 : 1.125);
        if (((PumpjackCrankBlockEntity)this.blockEntity).bearingPos == null) {
            if (isXAxis) {
                ((TransformStack)msr.translate(0.5, 1.25, 0.0)).rotateZ((double)angle);
            } else {
                ((TransformStack)((TransformStack)msr.translate(0.0, 1.25, 0.5)).rotateY(90.0)).rotateZ((double)angle);
            }
            (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.crank : this.large_crank).setTransform(ms);
            (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.large_crank : this.crank).setEmptyTransform();
            double dstY = -1000.0 - sin - 1.25 - (double)this.pos.m_123342_();
            double dstX = (double)this.pos.m_123341_() - cos - 0.5 - (double)this.pos.m_123341_();
            double dstZ = (double)this.pos.m_123343_() - cos - 0.5 - (double)this.pos.m_123343_();
            ms = new PoseStack();
            msr = TransformStack.cast((PoseStack)ms);
            msr.translate((Vec3i)this.getInstancePosition());
            if (isXAxis) {
                ((TransformStack)((TransformStack)msr.translate(0.5, 1.25, 0.0)).translate(cos, sin, 0.0)).rotateZ(Math.atan2(dstY, dstX) * 180.0 / Math.PI - 90.0);
                if (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 1) {
                    msr.translate(0.0, 0.375, 0.0);
                }
            } else {
                ((TransformStack)((TransformStack)((TransformStack)msr.translate(0.0, 1.25, 0.5)).translate(0.0, sin, cos)).rotateY(90.0)).rotateZ(Math.atan2(dstZ, dstY) * 180.0 / Math.PI);
                if (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 1) {
                    msr.translate(0.0, 0.375, 0.0);
                }
            }
            (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.crank_rod : this.large_crank_rod).setTransform(ms);
            (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.large_crank_rod : this.crank_rod).setEmptyTransform();
            return;
        }
        PumpjackBearingBlockEntity bearing = (PumpjackBearingBlockEntity)((Object)((PumpjackCrankBlockEntity)this.blockEntity).bearing.get());
        float interpolatedAngle = 0.0f;
        if (bearing != null) {
            interpolatedAngle = bearing.getInterpolatedAngle(partialTicks);
        }
        if (!isXAxis) {
            interpolatedAngle *= -1.0f;
        }
        Vec2 crankBearingLocation = new Vec2((float)(((PumpjackCrankBlockEntity)this.blockEntity).crankBearingLocation.f_82479_ * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI) - ((PumpjackCrankBlockEntity)this.blockEntity).crankBearingLocation.f_82480_ * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f, (float)(((PumpjackCrankBlockEntity)this.blockEntity).crankBearingLocation.f_82479_ * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI) + ((PumpjackCrankBlockEntity)this.blockEntity).crankBearingLocation.f_82480_ * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f);
        crankBearingLocation = isXAxis ? crankBearingLocation.m_165910_(new Vec2((float)((PumpjackCrankBlockEntity)this.blockEntity).bearingPos.m_123341_(), (float)((PumpjackCrankBlockEntity)this.blockEntity).bearingPos.m_123342_())) : crankBearingLocation.m_165910_(new Vec2((float)((PumpjackCrankBlockEntity)this.blockEntity).bearingPos.m_123343_(), (float)((PumpjackCrankBlockEntity)this.blockEntity).bearingPos.m_123342_()));
        if (isXAxis) {
            ((TransformStack)msr.translate(0.5, 1.25, 0.0)).rotateZ((double)angle);
        } else {
            ((TransformStack)((TransformStack)msr.translate(0.0, 1.25, 0.5)).rotateY(90.0)).rotateZ((double)angle);
        }
        (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.crank : this.large_crank).setTransform(ms);
        (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.large_crank : this.crank).setEmptyTransform();
        ms = new PoseStack();
        msr = TransformStack.cast((PoseStack)ms);
        msr.translate((Vec3i)this.getInstancePosition());
        double dstY = (double)crankBearingLocation.f_82471_ - sin - 1.25 - (double)this.pos.m_123342_();
        double dstX = (double)crankBearingLocation.f_82470_ - cos - 0.5 - (double)this.pos.m_123341_();
        double dstZ = (double)crankBearingLocation.f_82470_ - cos - 0.5 - (double)this.pos.m_123343_();
        if (isXAxis) {
            ((TransformStack)((TransformStack)msr.translate(0.5, 1.25, 0.0)).translate(cos, sin, 0.0)).rotateZ(Math.atan2(dstY, dstX) * 180.0 / Math.PI - 90.0);
            if (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 1) {
                msr.translate(Math.cos(Math.atan2(dstZ, dstY)) * 0.4375, Math.sin(Math.atan2(dstZ, dstY)) * 0.375, 0.0);
            }
        } else {
            ((TransformStack)((TransformStack)((TransformStack)msr.translate(0.0, 1.25, 0.5)).translate(0.0, sin, cos)).rotateY(90.0)).rotateZ(Math.atan2(dstZ, dstY) * 180.0 / Math.PI);
            if (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 1) {
                msr.translate(0.0, Math.cos(Math.atan2(dstY, dstX)) * -0.375, Math.sin(Math.atan2(dstY, dstX)) * 0.375);
            }
        }
        (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.crank_rod : this.large_crank_rod).setTransform(ms);
        (((PumpjackCrankBlockEntity)this.blockEntity).crankSize.getValue() == 0 ? this.large_crank_rod : this.crank_rod).setEmptyTransform();
    }

    public void update() {
        this.updateRotation(this.shaft);
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.shaft, this.crank, this.crank_rod, this.large_crank_rod, this.large_crank});
    }

    public void remove() {
        this.shaft.delete();
        this.crank.delete();
        this.crank_rod.delete();
        this.large_crank_rod.delete();
        this.large_crank.delete();
    }
}

