/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.PumpjackBearingBBlock;
import com.jesz.createdieselgenerators.blocks.PumpjackHeadBlock;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PumpjackBearingBlockEntity
extends MechanicalBearingBlockEntity {
    public BlockPos bearingBPos = BlockPos.f_121853_;
    public BlockPos crankPos = BlockPos.f_121853_;
    public boolean isLarge;
    public float crankSpeed;
    public float crankAngle;
    private float prevAngle;

    public PumpjackBearingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void applyRotation() {
        this.movedContraption.setAngle(this.angle);
    }

    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.m_14179_((float)(partialTicks + 0.5f), (float)this.prevAngle, (float)this.angle);
        }
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        float angularSpeed = this.getAngularSpeed();
        if (this.sequencedAngleLimit >= 0.0) {
            angularSpeed = (float)Mth.m_14008_((double)angularSpeed, (double)(-this.sequencedAngleLimit), (double)this.sequencedAngleLimit);
        }
        return Mth.m_14179_((float)partialTicks, (float)this.angle, (float)(this.angle + angularSpeed));
    }

    public void assemble() {
        if (((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() == Direction.Axis.Y) {
            return;
        }
        this.crankPos = BlockPos.f_121853_;
        this.bearingBPos = BlockPos.f_121853_;
        this.crankSpeed = 0.0f;
        this.angle = 0.0f;
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof BearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
        BearingContraption contraption = new BearingContraption(false, direction);
        AtomicInteger hinges = new AtomicInteger(0);
        AtomicInteger heads = new AtomicInteger(0);
        AtomicInteger hingeDistance = new AtomicInteger(0);
        AtomicInteger hingeHeight = new AtomicInteger(0);
        try {
            contraption.searchMovedStructure(this.f_58857_, this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)), null);
        }
        catch (AssemblyException e) {
            return;
        }
        contraption.getBlocks().forEach((pos, info) -> {
            if (info.f_74676_().m_60734_() instanceof PumpjackHeadBlock) {
                heads.set(heads.get() + 1);
            } else if (info.f_74676_().m_60734_() instanceof PumpjackBearingBBlock && ((Direction)info.f_74676_().m_61143_((Property)PumpjackBearingBBlock.FACING)).m_122434_() == ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122427_().m_122434_()) {
                int f = Math.abs(pos.m_123343_());
                if (((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() == Direction.Axis.Z) {
                    f = Math.abs(pos.m_123341_());
                }
                hingeHeight.set(pos.m_123342_());
                hingeDistance.set(f);
                hinges.set(hinges.get() + 1);
            }
        });
        if (hinges.get() == 0) {
            this.lastException = new AssemblyException((Component)Component.m_237115_((String)"createdieselgenerators.gui.assembly.exception.bearing_missing"));
        } else if (hinges.get() > 1) {
            this.lastException = new AssemblyException((Component)Component.m_237115_((String)"createdieselgenerators.gui.assembly.exception.too_many_bearings"));
        } else if (heads.get() == 0) {
            this.lastException = new AssemblyException((Component)Component.m_237115_((String)"createdieselgenerators.gui.assembly.exception.head_missing"));
        } else if (heads.get() > 1) {
            this.lastException = new AssemblyException((Component)Component.m_237115_((String)"createdieselgenerators.gui.assembly.exception.too_many_heads"));
        } else if (hingeDistance.get() < 4) {
            this.lastException = new AssemblyException((Component)Component.m_237115_((String)"createdieselgenerators.gui.assembly.exception.arm_too_short"));
        } else if (hingeDistance.get() > 16) {
            this.lastException = new AssemblyException((Component)Component.m_237115_((String)"createdieselgenerators.gui.assembly.exception.arm_too_long"));
        } else if (hingeHeight.get() != 0) {
            this.lastException = new AssemblyException((Component)Component.m_237115_((String)"createdieselgenerators.gui.assembly.exception.back_bearing_not_centered"));
        } else {
            super.assemble();
            return;
        }
        this.sendData();
    }

    public void tick() {
        this.prevAngle = this.angle;
        if (this.f_58857_.f_46443_) {
            this.clientAngleDiff /= 2.0f;
        }
        if (!this.f_58857_.f_46443_ && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                if (this.movedContraption == null || this.movedContraption.getContraption().getBlocks().isEmpty()) {
                    if (this.movedContraption != null) {
                        this.movedContraption.getContraption().stop(this.f_58857_);
                    }
                    this.disassemble();
                    return;
                }
            } else {
                this.assemble();
            }
        }
        if (!this.running) {
            return;
        }
        if (this.movedContraption == null || !this.movedContraption.isStalled()) {
            int f = Math.abs(this.bearingBPos.m_123343_());
            if (((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() == Direction.Axis.Z) {
                f = Math.abs(this.bearingBPos.m_123341_());
            }
            float b = 0.0f;
            if (f == 4) {
                b = 13.0f;
            }
            if (f == 5) {
                b = 10.0f;
            }
            if (f == 6) {
                b = 8.2f;
            }
            if (f == 7) {
                b = 7.0f;
            }
            if (f == 8) {
                b = 6.0f;
            }
            if (f == 9) {
                b = 5.3f;
            }
            if (f == 10) {
                b = 4.9f;
            }
            if (f == 11) {
                b = 4.4f;
            }
            if (f == 12) {
                b = 4.0f;
            }
            if (f == 13) {
                b = 3.7f;
            }
            if (f == 14) {
                b = 3.4f;
            }
            if (f == 15) {
                b = 3.2f;
            }
            if (f == 16) {
                b = 3.0f;
            }
            float[] angleAnimation = new float[]{0.0f, 70.0f, 130.0f, 180.0f, 220.0f, 255.0f, 280.0f, 300.0f, 260.0f, 199.0f, 127.0f, 67.0f};
            if (this.isLarge) {
                angleAnimation = new float[]{0.0f, 27.0f, 60.0f, 90.0f, 120.0f, 145.0f, 166.0f, 189.0f, 205.0f, 220.0f, 240.0f, 260.0f, 280.0f, 305.0f, 330.0f, 310.0f, 290.0f, 245.0f, 200.0f, 163.0f, 127.0f, 93.0f, 60.0f, 30.0f};
            }
            int lIndex = (int)Math.abs(Math.floor((double)this.crankAngle / (360.0 / (double)angleAnimation.length)) % (double)angleAnimation.length);
            float partialAngle = (float)Math.abs(Math.abs((double)this.crankAngle / (360.0 / (double)angleAnimation.length)) - (double)lIndex);
            float newCrankAngle = ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() == Direction.Axis.Z && this.bearingBPos.m_123341_() < 0 || ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() == Direction.Axis.X && this.bearingBPos.m_123343_() > 0 ? AngleHelper.angleLerp((double)partialAngle, (double)angleAnimation[(angleAnimation.length - lIndex) % angleAnimation.length], (double)angleAnimation[(angleAnimation.length - (lIndex + 1)) % angleAnimation.length]) : AngleHelper.angleLerp((double)partialAngle, (double)angleAnimation[lIndex], (double)angleAnimation[(lIndex + 1) % angleAnimation.length]);
            float a = (float)Math.pow(Math.sin((double)newCrankAngle / (360.0 / (double)angleAnimation.length) / Math.PI / (this.isLarge ? 4.4 : 2.2)), 2.0) * 2.0f + 1.0f;
            if ((double)Math.abs(newCrankAngle) >= 359.5) {
                a = 0.99f;
            }
            this.angle = (a * b - b) * ((float)((((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() == Direction.Axis.Z ? -1 : 1) * ((((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() == Direction.Axis.Z ? this.bearingBPos.m_123341_() : this.bearingBPos.m_123343_()) < 0 ? -1 : 1)) * (this.isLarge ? 1.5f : 1.0f));
        }
        if (this.movedContraption != null) {
            this.applyRotation();
        }
    }

    public boolean isStalled() {
        if (this.movedContraption == null) {
            return false;
        }
        return this.movedContraption.isStalled();
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void attach(ControlledContraptionEntity contraption) {
        BlockState blockState = this.m_58900_();
        if (!(contraption.getContraption() instanceof BearingContraption)) {
            return;
        }
        if (!blockState.m_61138_((Property)DirectionalKineticBlock.FACING)) {
            return;
        }
        this.movedContraption = contraption;
        this.m_6596_();
        BlockPos anchor = this.f_58858_.m_121945_((Direction)blockState.m_61143_((Property)DirectionalKineticBlock.FACING));
        this.movedContraption.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        if (!this.f_58857_.f_46443_) {
            this.running = true;
            this.sendData();
        }
    }

    public void assembleNextTick() {
        this.assembleNextTick = true;
    }
}

