/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.jei;

import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.compat.jei.AnimatedDieselEngineElement;
import com.jesz.createdieselgenerators.compat.jei.DieselEngineJeiRecipeType;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

@ParametersAreNonnullByDefault
public class DieselEngineCategory
implements IRecipeCategory<DieselEngineJeiRecipeType> {
    IGuiHelper guiHelper;
    AnimatedDieselEngineElement engine = new AnimatedDieselEngineElement();

    public DieselEngineCategory(IGuiHelper helper) {
        this.guiHelper = helper;
    }

    public RecipeType<DieselEngineJeiRecipeType> getRecipeType() {
        return DieselEngineJeiRecipeType.DIESEL_COMBUSTION;
    }

    public class_2561 getTitle() {
        return Components.translatable((String)"createdieselgenerators.recipe.diesel_combustion");
    }

    public IDrawable getBackground() {
        return new EmptyBackground(177, 70);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)BlockRegistry.DIESEL_ENGINE.asStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DieselEngineJeiRecipeType recipe, IFocusGroup iFocusGroup) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 10).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)FabricTypes.FLUID_STACK, (Object)CreateRecipeCategory.toJei((FluidStack)CreateRecipeCategory.withImprovedVisibility((FluidStack)new FluidStack(recipe.fluid, 1000L))))).addTooltipCallback(CreateRecipeCategory.addFluidTooltip((long)recipe.burnRate));
    }

    public void draw(DieselEngineJeiRecipeType recipe, IRecipeSlotsView iRecipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_ARROW.render(graphics, 82, 40);
        AllGuiTextures.JEI_SHADOW.render(graphics, 28, 52);
        byte enginesEnabled = (byte)((DieselGeneratorBlock.EngineTypes.NORMAL.enabled() ? 1 : 0) + (DieselGeneratorBlock.EngineTypes.MODULAR.enabled() ? 1 : 0) + (DieselGeneratorBlock.EngineTypes.HUGE.enabled() ? 1 : 0));
        int currentEngineIndex = AnimationTickHolder.getTicks() % 120 / 20;
        List<DieselGeneratorBlock.EngineTypes> enabledEngines = Arrays.stream(DieselGeneratorBlock.EngineTypes.values()).filter(DieselGeneratorBlock.EngineTypes::enabled).toList();
        DieselGeneratorBlock.EngineTypes currentEngine = enabledEngines.get(currentEngineIndex % enginesEnabled);
        float currentSpeed = FuelTypeManager.getGeneratedSpeed(currentEngine, recipe.fluid);
        float currentCapacity = FuelTypeManager.getGeneratedStress(currentEngine, recipe.fluid);
        float currentBurn = FuelTypeManager.getBurnRate(currentEngine, recipe.fluid);
        graphics.method_51439(class_310.method_1551().field_1772, (class_2561)Lang.number((double)currentBurn).component().method_10852((class_2561)class_2561.method_43471((String)"createdieselgenerators.generic.unit.mbps")), 5, 40, 0x888888, false);
        graphics.method_51439(class_310.method_1551().field_1772, (class_2561)Lang.number((double)(currentCapacity / currentSpeed)).component().method_27693("x").method_10852((class_2561)class_2561.method_43471((String)"create.generic.unit.rpm")), 125, 41, 0x888888, false);
        graphics.method_51439(class_310.method_1551().field_1772, (class_2561)Lang.number((double)currentSpeed).component().method_10852((class_2561)class_2561.method_43471((String)"create.generic.unit.rpm")), 85, 33, 0x888888, false);
        graphics.method_51439(class_310.method_1551().field_1772, (class_2561)Lang.number((double)currentCapacity).component().method_10852((class_2561)class_2561.method_43471((String)"create.generic.unit.stress")), 81, 50, 0x888888, false);
        this.engine.draw(graphics, 47, 62);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 40, 15);
    }
}

