/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.TagRegistry;
import com.jesz.createdieselgenerators.world.OilChunksSavedData;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2429;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class PumpjackHoleBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation,
SidedStorageBlockEntity {
    class_2680 state;
    SmartFluidTankBehaviour tank;
    public int headPos = 0;
    public int bearingPos = 0;
    public boolean started = false;
    byte tt = 0;
    public int pipeLength = 0;
    boolean valid = false;
    public int oilAmount = 0;
    public int storedOilAmount = 0;

    public PumpjackHoleBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.state = state;
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.tank.write(compound, false);
        compound.method_10569("StoredOilAmount", this.storedOilAmount);
        compound.method_10569("OilAmount", this.oilAmount);
        compound.method_10556("Started", this.started);
    }

    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (this.valid) {
            return false;
        }
        Lang.builder().add(Components.translatable((String)"createdieselgenerators.goggle.problem_encountered")).style(class_124.field_1065).forGoggles(tooltip);
        Lang.builder().add(Components.translatable((String)"createdieselgenerators.goggle.pumpjack_invalid_pipes")).style(class_124.field_1080).forGoggles(tooltip);
        return true;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!this.valid || !this.started) {
            return false;
        }
        Lang.builder().add(Components.translatable((String)"createdieselgenerators.goggle.oil_amount")).style(class_124.field_1080).forGoggles(tooltip);
        Lang.number((double)this.oilAmount).add(Lang.translate((String)"generic.unit.buckets", (Object[])new Object[0])).style(class_124.field_1065).forGoggles(tooltip);
        return true;
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.read(compound, false);
        this.storedOilAmount = compound.method_10550("StoredOilAmount");
        this.oilAmount = compound.method_10550("OilAmount");
        this.started = compound.method_10577("Started");
    }

    public void handleUpdateTag(class_2487 compound) {
        super.handleUpdateTag(compound);
        this.oilAmount = compound.method_10550("OilAmount");
        this.started = compound.method_10577("Started");
    }

    public void tick() {
        super.tick();
        this.tt = (byte)(this.tt + 1);
        if (this.tt >= 20) {
            int pipeLength = 0;
            this.tt = 0;
            boolean v = false;
            for (int i = 0; i < this.method_11016().method_10264() - this.field_11863.method_31607(); ++i) {
                ++pipeLength;
                class_2680 bs = this.field_11863.method_8320(this.method_11016().method_10087(i + 1));
                if (bs.method_26204() instanceof class_2429 || bs.method_26204() instanceof EncasedPipeBlock) {
                    if (((Boolean)bs.method_11654((class_2769)class_2741.field_12519)).booleanValue() && ((Boolean)bs.method_11654((class_2769)class_2741.field_12546)).booleanValue()) continue;
                    break;
                }
                if (bs.method_26204() instanceof GlassFluidPipeBlock) {
                    if (bs.method_11654((class_2769)class_2741.field_12496) == class_2350.class_2351.field_11052) continue;
                    break;
                }
                if (bs.method_26164(AllTags.optionalTag((class_2378)class_7923.field_41175, (class_2960)new class_2960("createdieselgenerators:pumpjack_pipe")))) continue;
                if (!bs.method_26164(AllTags.optionalTag((class_2378)class_7923.field_41175, (class_2960)new class_2960("createdieselgenerators:oil_deposit")))) break;
                v = true;
                break;
            }
            this.pipeLength = v ? pipeLength : 0;
            this.valid = v;
        }
    }

    public class_238 getRenderBoundingBox() {
        return super.getRenderBoundingBox().method_1014((double)this.pipeLength);
    }

    public class_2487 method_16887() {
        class_2487 compound = super.method_16887();
        compound.method_10569("OilAmount", this.oilAmount);
        compound.method_10556("Started", this.started);
        return compound;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (long)1000L);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public void tickFluid(boolean isCrankLarge) {
        if (!this.field_11863.field_9236 && this.valid) {
            class_1923 chunkPos = new class_1923(this.method_11016());
            OilChunksSavedData sd = OilChunksSavedData.load((class_3218)this.field_11863);
            int amount = sd.getChunkOilAmount(chunkPos);
            if (amount == -1) {
                amount = CreateDieselGenerators.getOilAmount((class_3218)this.field_11863, (class_6880<class_1959>)this.field_11863.method_23753(new class_2338(chunkPos.field_9181 * 16, 64, chunkPos.field_9180 * 16)), chunkPos.field_9181, chunkPos.field_9180, ((class_3218)this.field_11863).method_8412());
            }
            this.oilAmount = amount;
            this.started = true;
            if (amount == 0) {
                return;
            }
            if (this.storedOilAmount == 0) {
                sd.setChunkAmount(chunkPos, amount - 1);
                this.oilAmount = amount - 1;
                this.storedOilAmount = 1000;
            }
            int subtractedAmount = class_3532.method_15340((int)((int)(100.0f * Math.abs((float)this.headPos / (float)this.bearingPos)) * (isCrankLarge ? 2 : 1)), (int)0, (int)1000);
            this.storedOilAmount = this.storedOilAmount < subtractedAmount ? 0 : (int)((float)this.storedOilAmount - 100.0f / Math.abs((float)this.headPos / (float)this.bearingPos));
            class_6862<class_3611> fluidTag = TagRegistry.FluidTags.PUMPJACK_OUTPUT.tag;
            Optional<class_3611> stackList = class_7923.field_41173.method_10220().filter(fluid -> FluidHelper.isTag((class_3611)fluid, (class_6862)fluidTag)).findFirst();
            if (stackList.isEmpty()) {
                return;
            }
            FluidStack oilStack = new FluidStack(stackList.get(), (long)subtractedAmount);
            TransferUtil.insertFluid((Storage)this.tank.getPrimaryHandler(), (FluidStack)oilStack);
        }
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 side) {
        if (side == class_2350.field_11043 && ((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12489)).booleanValue()) {
            return this.tank.getCapability();
        }
        if (side == class_2350.field_11034 && ((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12487)).booleanValue()) {
            return this.tank.getCapability();
        }
        if (side == class_2350.field_11035 && ((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12540)).booleanValue()) {
            return this.tank.getCapability();
        }
        if (side == class_2350.field_11039 && ((Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12527)).booleanValue()) {
            return this.tank.getCapability();
        }
        return null;
    }
}

