/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.LargeDieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.entity.LargeDieselGeneratorValueBox;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.jesz.createdieselgenerators.sounds.SoundRegistry;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class LargeDieselGeneratorBlockEntity
extends GeneratingKineticBlockEntity
implements SidedStorageBlockEntity {
    class_2680 state;
    public boolean validFuel;
    public int stacked;
    boolean end = true;
    public WeakReference<LargeDieselGeneratorBlockEntity> forw;
    public WeakReference<LargeDieselGeneratorBlockEntity> back;
    public WeakReference<LargeDieselGeneratorBlockEntity> frontEngine = new WeakReference<Object>(null);
    public SmartFluidTankBehaviour tank;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public AbstractComputerBehaviour computerBehaviour;
    int partialSecond;
    int t = 0;
    int totalSize = 0;

    public LargeDieselGeneratorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.forw = new WeakReference<Object>(null);
        this.back = new WeakReference<Object>(null);
        this.state = state;
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        if (((Boolean)this.state.method_11654((class_2769)LargeDieselGeneratorBlock.PIPE)).booleanValue()) {
            LargeDieselGeneratorBlockEntity frontEngine = (LargeDieselGeneratorBlockEntity)((Object)this.frontEngine.get());
            if (face == class_2350.field_11036) {
                if (frontEngine != null) {
                    return frontEngine.tank.getCapability();
                }
                return this.tank.getCapability();
            }
        }
        return null;
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("PartialSecond", this.partialSecond);
        this.tank.write(compound, false);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.partialSecond = compound.method_10550("PartialSecond");
        this.tank.read(compound, false);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (class_2561)Lang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new LargeDieselGeneratorValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged(true));
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (long)1000L);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void onDirectionChanged(boolean first) {
        LargeDieselGeneratorBlockEntity frontEngine = (LargeDieselGeneratorBlockEntity)((Object)this.frontEngine.get());
        if (frontEngine == null) {
            return;
        }
        if (first && this.getEngineFor() != null) {
            frontEngine.movementDirection.setValue(this.movementDirection.getValue());
            frontEngine.onDirectionChanged(false);
            return;
        }
        this.movementDirection.setValue(frontEngine.movementDirection.getValue());
        if (this.getEngineBack() != null) {
            this.getEngineBack().onDirectionChanged(false);
        }
    }

    public void initialize() {
        super.initialize();
        this.updateStacked();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float calculateAddedStressCapacity() {
        if (this.getGeneratedSpeed() == 0.0f || !this.end) {
            return 0.0f;
        }
        if (((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.POWERED)).booleanValue()) {
            return 0.0f;
        }
        return FuelTypeManager.getGeneratedStress((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()) / Math.abs(this.getGeneratedSpeed()) * (float)this.stacked;
    }

    public float getGeneratedSpeed() {
        if (!this.end) {
            return 0.0f;
        }
        if (((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.POWERED)).booleanValue()) {
            return 0.0f;
        }
        return LargeDieselGeneratorBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * FuelTypeManager.getGeneratedSpeed((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid())), (class_2350)((class_2350)this.method_11010().method_11654((class_2769)LargeDieselGeneratorBlock.FACING)));
    }

    public void updateStacked() {
        LargeDieselGeneratorBlockEntity engineForward = this.getEngineFor();
        LargeDieselGeneratorBlockEntity engineBack = this.getEngineBack();
        if (engineBack == null) {
            this.totalSize = 1;
            this.stacked = 1;
        } else {
            this.stacked = engineBack.stacked + 1;
        }
        if (engineForward == null) {
            this.totalSize = this.stacked;
            this.setEveryEnginesFront();
        } else {
            engineForward.updateStacked();
        }
    }

    public void setEveryEnginesFront() {
        LargeDieselGeneratorBlockEntity engineForward = this.getEngineFor();
        LargeDieselGeneratorBlockEntity engineBack = this.getEngineBack();
        if (engineForward == null) {
            this.frontEngine = new WeakReference<LargeDieselGeneratorBlockEntity>(this);
        } else {
            this.frontEngine = engineForward.frontEngine;
            this.totalSize = engineForward.totalSize;
        }
        if (engineBack != null) {
            engineBack.setEveryEnginesFront();
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        LargeDieselGeneratorBlockEntity frontEngine = (LargeDieselGeneratorBlockEntity)((Object)this.frontEngine.get());
        if (!IRotate.StressImpact.isEnabled() || frontEngine == null) {
            return added;
        }
        float stressBase = frontEngine.calculateAddedStressCapacity();
        if (class_3532.method_15347((float)stressBase, (float)0.0f)) {
            return added;
        }
        if (frontEngine != this) {
            Lang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
            float stressTotal = Math.abs(frontEngine.getGeneratedSpeed() * stressBase);
            Lang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(class_124.field_1075).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(class_124.field_1063)).forGoggles(tooltip, 1);
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, frontEngine.tank.getCapability());
    }

    public void tick() {
        super.tick();
        LargeDieselGeneratorBlockEntity engineForward = this.getEngineFor();
        this.state = this.method_11010();
        this.end = engineForward == null;
        this.reActivateSource = true;
        LargeDieselGeneratorBlockEntity frontEngine = (LargeDieselGeneratorBlockEntity)((Object)this.frontEngine.get());
        if (!this.tank.isEmpty() && engineForward != null && frontEngine != null) {
            TransferUtil.insertFluid((Storage)this.tank.getPrimaryHandler(), (FluidStack)this.tank.getPrimaryHandler().getFluid());
            TransferUtil.extractFluid((Storage)this.tank.getPrimaryHandler(), (FluidStack)this.tank.getPrimaryHandler().getFluid());
        }
        if (((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.POWERED)).booleanValue()) {
            this.validFuel = false;
        } else {
            boolean bl = this.validFuel = FuelTypeManager.getGeneratedSpeed((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()) != 0.0f;
        }
        if (frontEngine != null && this.t > FuelTypeManager.getSoundSpeed(frontEngine.tank.getPrimaryHandler().getFluid().getFluid()) && frontEngine.validFuel && !((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.SILENCED)).booleanValue() && (this.stacked % 6 == 0 || this.end)) {
            this.field_11863.method_8486((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), SoundRegistry.DIESEL_ENGINE_SOUND.getMainEvent(), class_3419.field_15245, 0.5f, 1.0f, false);
            this.t = 0;
        } else {
            ++this.t;
        }
        ++this.partialSecond;
        if (this.partialSecond >= 20) {
            this.partialSecond = 0;
            if (this.validFuel) {
                if (this.tank.getPrimaryHandler().getFluid().getAmount() >= (long)(FuelTypeManager.getBurnRate((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()) * this.stacked)) {
                    this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)this.tank.getPrimaryHandler().getFluid(), (long)(this.tank.getPrimaryHandler().getFluid().getAmount() - (long)(FuelTypeManager.getBurnRate((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()) * this.stacked))));
                } else {
                    this.tank.getPrimaryHandler().setFluid(FluidStack.EMPTY);
                }
            }
        }
    }

    public LargeDieselGeneratorBlockEntity getEngineFor() {
        LargeDieselGeneratorBlockEntity engine = (LargeDieselGeneratorBlockEntity)((Object)this.forw.get());
        if (engine == null || engine.method_11015() || engine.state.method_11654((class_2769)LargeDieselGeneratorBlock.FACING) == this.state.method_11654((class_2769)LargeDieselGeneratorBlock.FACING)) {
            class_2350 facing;
            class_2586 be;
            if (engine != null) {
                this.forw = new WeakReference<Object>(null);
            }
            if ((be = this.field_11863.method_8321(this.field_11867.method_10093((facing = (class_2350)this.state.method_11654((class_2769)LargeDieselGeneratorBlock.FACING)).method_10166() == class_2350.class_2351.field_11051 ? class_2350.field_11035 : class_2350.field_11034))) instanceof LargeDieselGeneratorBlockEntity) {
                LargeDieselGeneratorBlockEntity engineBE;
                engine = engineBE = (LargeDieselGeneratorBlockEntity)be;
                this.forw = new WeakReference<LargeDieselGeneratorBlockEntity>(engine);
            }
        }
        if (engine != null && ((class_2350)engine.state.method_11654((class_2769)LargeDieselGeneratorBlock.FACING)).method_10166() != ((class_2350)this.state.method_11654((class_2769)LargeDieselGeneratorBlock.FACING)).method_10166()) {
            this.forw = new WeakReference<Object>(null);
            return null;
        }
        return engine;
    }

    public LargeDieselGeneratorBlockEntity getEngineBack() {
        LargeDieselGeneratorBlockEntity engine = (LargeDieselGeneratorBlockEntity)((Object)this.back.get());
        if (engine == null || engine.method_11015()) {
            class_2350 facing;
            class_2586 be;
            if (engine != null) {
                this.back = new WeakReference<Object>(null);
            }
            if ((be = this.field_11863.method_8321(this.field_11867.method_10093((facing = (class_2350)this.state.method_11654((class_2769)LargeDieselGeneratorBlock.FACING)).method_10166() == class_2350.class_2351.field_11051 ? class_2350.field_11043 : class_2350.field_11039))) instanceof LargeDieselGeneratorBlockEntity) {
                LargeDieselGeneratorBlockEntity engineBE;
                engine = engineBE = (LargeDieselGeneratorBlockEntity)be;
                this.back = new WeakReference<LargeDieselGeneratorBlockEntity>(engine);
            }
        }
        if (engine != null && ((class_2350)engine.state.method_11654((class_2769)LargeDieselGeneratorBlock.FACING)).method_10166() != ((class_2350)this.state.method_11654((class_2769)LargeDieselGeneratorBlock.FACING)).method_10166()) {
            this.back = new WeakReference<Object>(null);
            return null;
        }
        return engine;
    }
}

