/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.DistillationTankBlock;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.recipes.DistillationRecipe;
import com.jesz.createdieselgenerators.recipes.RecipeRegistry;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3611;

public class DistillationTankBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Fluid,
IHaveGoggleInformation,
SidedStorageBlockEntity {
    private static final int MAX_SIZE = 3;
    public float progress;
    public int heat;
    protected boolean forceFluidLevelUpdate = true;
    public SmartFluidTank tankInventory = this.createInventory();
    protected FluidTank exposedTank;
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity = false;
    public boolean window = false;
    protected int luminosity;
    protected int width = 1;
    protected int height = 1;
    protected class_2338 bottomCPos;
    int processingTime = -1;
    DistillationRecipe currentRecipe;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat fluidLevel;
    public boolean hasDistillationC;

    public DistillationTankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.refreshCapability();
    }

    private class_2338 getBottomControllerPos() {
        if (this.isBottom()) {
            return this.getController();
        }
        class_2586 class_25862 = this.field_11863.method_8321(this.method_11016().method_10074());
        if (class_25862 instanceof DistillationTankBlockEntity) {
            DistillationTankBlockEntity be = (DistillationTankBlockEntity)class_25862;
            return be.getBottomControllerPos();
        }
        return this.getController();
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(DistillationTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    public int getTemperature() {
        int width = this.getControllerBE().width;
        int heatN = 0;
        if (this.getController() == null || width == 0) {
            return 0;
        }
        for (int xOffset = 0; xOffset < width; ++xOffset) {
            for (int zOffset = 0; zOffset < width; ++zOffset) {
                class_2338 pos = this.getController().method_10069(xOffset, -1, zOffset);
                class_2680 blockState = this.field_11863.method_8320(pos);
                float heat = BoilerHeaters.getActiveHeat((class_1937)this.field_11863, (class_2338)pos, (class_2680)blockState);
                heatN += (int)heat;
            }
        }
        return class_3532.method_15340((int)(heatN / (width * width)), (int)0, (int)100);
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863.field_9236) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((class_2586)this);
    }

    private void startProcessing() {
        if (this.currentRecipe == null) {
            return;
        }
        this.processingTime = this.currentRecipe.getProcessingDuration();
        if (!this.field_11863.field_9236) {
            this.sendData();
        }
    }

    public void tick() {
        this.bottomCPos = this.getBottomControllerPos();
        if (this.isController() && this.isBottom()) {
            if (this.processingTime > -1 && this.currentRecipe != null) {
                boolean canFill = true;
                for (int i = 0; i < this.currentRecipe.getFluidResults().size() * (Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get(); ++i) {
                    class_2586 class_25862 = this.field_11863.method_8321(this.method_11016().method_10086(i + 1));
                    if (class_25862 instanceof DistillationTankBlockEntity) {
                        DistillationTankBlockEntity be = (DistillationTankBlockEntity)class_25862;
                        if (be.getControllerBE().width != this.getControllerBE().width) {
                            canFill = false;
                            break;
                        }
                        if (i % (Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get() == 0 && be.getTank(0).getFluidAmount() <= DistillationTankBlockEntity.getCapacityMultiplier() * (long)this.width * (long)this.width - ((FluidStack)this.currentRecipe.getFluidResults().get(i / (Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get())).getAmount()) continue;
                        canFill = false;
                        break;
                    }
                    canFill = false;
                    break;
                }
                if (canFill) {
                    this.processingTime -= class_3532.method_15340((int)((Boolean)ConfigRegistry.DISTILLATION_WIDE_TANK_FASTER.get() != false ? this.width * this.width : 1), (int)1, (int)this.processingTime);
                }
                if (this.tankInventory.getFluid().getAmount() < ((FluidIngredient)this.currentRecipe.getFluidIngredients().get(0)).getRequiredAmount() || this.getHeat(this.currentRecipe.getRequiredHeat()) > this.heat) {
                    this.currentRecipe = null;
                    this.processingTime = -1;
                    this.onFluidStackChanged(this.tankInventory.getFluid());
                }
            }
            if (this.processingTime == 0 && this.currentRecipe != null) {
                if (this.tankInventory.getFluid().getAmount() >= ((FluidIngredient)this.currentRecipe.getFluidIngredients().get(0)).getRequiredAmount() && this.getHeat(this.currentRecipe.getRequiredHeat()) <= this.heat) {
                    TransferUtil.extractAnyFluid((Storage)this.tankInventory, (long)((FluidIngredient)this.currentRecipe.getFluidIngredients().get(0)).getRequiredAmount());
                    if (this.currentRecipe != null) {
                        class_2586 class_25863;
                        for (int i = 0; i < this.currentRecipe.getFluidResults().size() * (Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get() && (class_25863 = this.field_11863.method_8321(this.method_11016().method_10086(i + 1))) instanceof DistillationTankBlockEntity; ++i) {
                            DistillationTankBlockEntity be = (DistillationTankBlockEntity)class_25863;
                            if (be.getControllerBE().width != this.getControllerBE().width) break;
                            if (i % (Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get() != 0) continue;
                            TransferUtil.insertFluid((Storage)be.tankInventory, (FluidStack)((FluidStack)this.currentRecipe.getFluidResults().get(i / (Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get())));
                        }
                    }
                }
                this.currentRecipe = null;
                this.processingTime = -1;
                this.onFluidStackChanged(this.tankInventory.getFluid());
            }
            if (this.currentRecipe == null || this.width != 0 && this.currentRecipe.getProcessingDuration() != 0) {
                this.progress = this.currentRecipe != null ? (float)this.processingTime / ((float)this.currentRecipe.getProcessingDuration() / (float)(this.width * this.width)) : 0.0f;
            }
        }
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.method_11016();
        } else if (!this.lastKnownPos.equals((Object)this.field_11867) && this.field_11867 != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
    }

    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    public void initialize() {
        super.initialize();
        this.updateTemperature();
        List<class_1860<?>> r = this.getMatchingRecipes();
        if (!r.isEmpty()) {
            this.currentRecipe = (DistillationRecipe)r.get(0);
            if (this.processingTime <= 0) {
                this.startProcessing();
            }
        }
        this.sendData();
        if (this.field_11863.field_9236) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    protected List<class_1860<?>> getMatchingRecipes() {
        List list = RecipeFinder.get((Object)new Object(), (class_1937)this.field_11863, recipe -> recipe.method_17716() == RecipeRegistry.DISTILLATION.getType());
        Stream<class_1860> list1 = list.stream().filter(r -> !((DistillationRecipe)((Object)r)).getFluidIngredients().isEmpty());
        Stream<class_1860> list2 = list1.filter(r -> ((FluidIngredient)((DistillationRecipe)((Object)r)).getFluidIngredients().get(0)).getMatchingFluidStacks().contains(this.tankInventory.getFluid()));
        Stream<class_1860> list3 = list2.filter(r -> ((FluidIngredient)((DistillationRecipe)((Object)r)).getFluidIngredients().get(0)).getRequiredAmount() <= this.tankInventory.getFluidAmount());
        List<class_1860<?>> list4 = list3.filter(r -> this.getHeat(((DistillationRecipe)((Object)r)).getRequiredHeat()) <= this.heat).toList();
        return list4;
    }

    int getHeat(HeatCondition heatCondition) {
        if (heatCondition == HeatCondition.SUPERHEATED) {
            return 2;
        }
        if (heatCondition == HeatCondition.HEATED) {
            return 1;
        }
        return 0;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.method_11002()) {
            return;
        }
        if (this.processingTime <= -1) {
            List<class_1860<?>> r = this.getMatchingRecipes();
            if (!r.isEmpty()) {
                this.currentRecipe = (DistillationRecipe)r.get(0);
                this.startProcessing();
            } else {
                this.currentRecipe = null;
            }
        }
        FluidVariantAttributeHandler handler = FluidVariantAttributes.getHandlerOrDefault((class_3611)newFluidStack.getFluid());
        FluidVariant variant = newFluidStack.getType();
        int luminosity = (int)((float)handler.getLuminance(variant) / 1.2f);
        boolean reversed = handler.isLighterThanAir(variant);
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    DistillationTankBlockEntity tankAt = (DistillationTankBlockEntity)ConnectivityHandler.partAt((class_2591)this.method_11017(), (class_1922)this.field_11863, (class_2338)pos);
                    if (tankAt == null) continue;
                    this.field_11863.method_8455(pos, tankAt.method_11010().method_26204());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.field_11863.field_9236) {
            this.method_5431();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public DistillationTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        class_2586 blockEntity = this.field_11863.method_8321(this.controller);
        if (blockEntity instanceof DistillationTankBlockEntity) {
            return (DistillationTankBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity((long)blocks * DistillationTankBlockEntity.getCapacityMultiplier());
        long overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0L) {
            TransferUtil.extract((Storage)this.tankInventory, (Object)((FluidVariant)this.tankInventory.variant), (long)overflow);
        }
        this.forceFluidLevelUpdate = true;
    }

    public void removeController(boolean keepFluids) {
        if (this.field_11863.field_9236) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluid());
        class_2680 state = this.method_11010();
        if (DistillationTankBlock.isTank(state)) {
            state = (class_2680)state.method_11657((class_2769)DistillationTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (class_2680)state.method_11657((class_2769)DistillationTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (class_2680)state.method_11657(DistillationTankBlock.SHAPE, (Comparable)(this.window ? FluidTankBlock.Shape.WINDOW : FluidTankBlock.Shape.PLAIN));
            this.method_10997().method_8652(this.field_11867, state, 6);
        }
        this.refreshCapability();
        this.method_5431();
        this.sendData();
    }

    public void toggleWindows() {
        DistillationTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.setWindows(!be.window);
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        if (window && (Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get() != 1 && (this.getBottomControllerPos().method_10264() + 1 - this.field_11867.method_10264()) % (Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get() != 0) {
            return;
        }
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = this.field_11863.method_8320(pos);
                    if (!DistillationTankBlock.isTank(blockState)) continue;
                    FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            FluidTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(xOffset - zOffset) == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                    }
                    this.field_11863.method_8652(pos, (class_2680)blockState.method_11657(DistillationTankBlock.SHAPE, (Comparable)shape), 22);
                    this.field_11863.method_8398().method_12130().method_15513(pos);
                }
            }
        }
    }

    public void setController(class_2338 controller) {
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.method_5431();
        this.sendData();
    }

    private void refreshCapability() {
        this.exposedTank = this.handlerForCapability();
    }

    private FluidTank handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0L));
    }

    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    protected class_238 createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().method_1012((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if ((Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get() != 1 && (this.getBottomControllerPos().method_10264() + 1 - this.field_11867.method_10264()) % (Integer)ConfigRegistry.DISTILLATION_LEVEL_HEIGHT.get() != 0) {
            return false;
        }
        DistillationTankBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerBE.getFluidStorage(null));
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        this.hasDistillationC = compound.method_10577("HasDistillationC");
        class_2338 controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.method_10545("Uninitialized");
        this.luminosity = compound.method_10550("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.method_10545("LastKnownPos")) {
            this.lastKnownPos = class_2512.method_10691((class_2487)compound.method_10562("LastKnownPos"));
        }
        if (compound.method_10545("Controller")) {
            this.controller = class_2512.method_10691((class_2487)compound.method_10562("Controller"));
        }
        if (this.isController()) {
            this.window = compound.method_10577("Window");
            this.width = compound.method_10550("Size");
            this.height = compound.method_10550("Height");
            this.tankInventory.setCapacity((long)this.getTotalTankSize() * DistillationTankBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.method_10562("TankContent"));
            if (this.tankInventory.getSpace() < 0L) {
                try (Transaction t = TransferUtil.getTransaction();){
                    this.tankInventory.extract((FluidVariant)this.tankInventory.variant, -this.tankInventory.getSpace(), (TransactionContext)t);
                    t.commit();
                }
            }
        }
        if (compound.method_10545("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.method_11002()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(DistillationTankBlockEntity.getCapacityMultiplier() * (long)this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.method_10545("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
            this.processingTime = compound.method_10550("Progress");
        }
        if (this.luminosity != prevLum && this.method_11002()) {
            this.field_11863.method_8398().method_12130().method_15513(this.field_11867);
        }
        if (compound.method_10545("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
        this.updateTemperature();
        List<class_1860<?>> r = this.getMatchingRecipes();
        if (!r.isEmpty()) {
            this.currentRecipe = (DistillationRecipe)r.get(0);
            if (this.processingTime <= 0) {
                this.startProcessing();
            }
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("HasDistillationC", this.hasDistillationC);
        if (this.updateConnectivity) {
            compound.method_10556("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controller));
        }
        if (this.isController()) {
            compound.method_10556("Window", this.window);
            compound.method_10566("TankContent", (class_2520)this.tankInventory.writeToNBT(new class_2487()));
            compound.method_10569("Size", this.width);
            compound.method_10569("Height", this.height);
            compound.method_10569("Progress", this.processingTime);
        }
        compound.method_10569("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.method_10556("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.method_10556("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public int getTotalTankSize() {
        return this.width * this.width;
    }

    public static long getCapacityMultiplier() {
        return 648000L;
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        class_2680 state = this.method_11010();
        if (DistillationTankBlock.isTank(state)) {
            state = (class_2680)state.method_11657((class_2769)DistillationTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getBottomConnectivity()));
            state = (class_2680)state.method_11657((class_2769)DistillationTankBlock.TOP, (Comparable)Boolean.valueOf(this.getTopConnectivity()));
            this.field_11863.method_8652(this.method_11016(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.method_5431();
    }

    private boolean getBottomConnectivity() {
        DistillationTankBlockEntity controllerBE;
        DistillationTankBlockEntity be;
        DistillationTankBlockEntity otherControllerBE;
        class_2586 class_25862 = this.field_11863.method_8321(this.method_11016().method_10074());
        if (class_25862 instanceof DistillationTankBlockEntity && (otherControllerBE = (be = (DistillationTankBlockEntity)class_25862).getControllerBE()) != null && (controllerBE = this.getControllerBE()) != null && controllerBE.method_11016().method_10074().equals((Object)otherControllerBE.method_11016())) {
            return controllerBE.getWidth() != otherControllerBE.getWidth();
        }
        return true;
    }

    private boolean getTopConnectivity() {
        DistillationTankBlockEntity controllerBE;
        DistillationTankBlockEntity be;
        DistillationTankBlockEntity otherControllerBE;
        class_2586 class_25862 = this.field_11863.method_8321(this.method_11016().method_10084());
        if (class_25862 instanceof DistillationTankBlockEntity && (otherControllerBE = (be = (DistillationTankBlockEntity)class_25862).getControllerBE()) != null && (controllerBE = this.getControllerBE()) != null && controllerBE.method_11016().method_10084().equals((Object)otherControllerBE.method_11016())) {
            return controllerBE.getWidth() != otherControllerBE.getWidth();
        }
        return true;
    }

    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public class_2350.class_2351 getMainConnectionAxis() {
        return class_2350.class_2351.field_11052;
    }

    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052) {
            return 1;
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public long getTankSize(int tank) {
        return DistillationTankBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public FluidTank getTank(int tank) {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 direction) {
        if (this.exposedTank == null) {
            this.refreshCapability();
        }
        return this.exposedTank;
    }

    public void updateVerticalMulti() {
        class_2586 class_25862;
        class_2680 state = this.method_11010();
        if (DistillationTankBlock.isTank(state)) {
            state = (class_2680)state.method_11657((class_2769)DistillationTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getBottomConnectivity()));
            if ((state = (class_2680)state.method_11657((class_2769)DistillationTankBlock.TOP, (Comparable)Boolean.valueOf(this.getTopConnectivity()))) != this.method_11010()) {
                this.field_11863.method_8652(this.method_11016(), state, 3);
            }
        }
        if ((class_25862 = this.field_11863.method_8321(this.method_11016().method_10074())) instanceof DistillationTankBlockEntity) {
            DistillationTankBlockEntity be = (DistillationTankBlockEntity)class_25862;
            be.updateVerticalMulti();
        }
    }

    public boolean isBottom() {
        DistillationTankBlockEntity be;
        class_2586 class_25862 = this.field_11863.method_8321(this.method_11016().method_10074());
        return !(class_25862 instanceof DistillationTankBlockEntity && (be = (DistillationTankBlockEntity)class_25862).getWidth() == this.getWidth());
    }

    public void updateTemperature() {
        if (!this.isBottom()) {
            return;
        }
        if (this.isController()) {
            this.heat = this.getTemperature();
            this.sendData();
            if (this.processingTime <= -1) {
                List<class_1860<?>> r = this.getMatchingRecipes();
                if (!r.isEmpty()) {
                    this.currentRecipe = (DistillationRecipe)r.get(0);
                    this.startProcessing();
                } else {
                    this.currentRecipe = null;
                }
            }
            return;
        }
        DistillationTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.updateTemperature();
    }
}

