/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class CanisterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
SidedStorageBlockEntity {
    CapacityEnchantedFluidTankBehaviour tank;
    class_2680 state;
    private class_2561 customName;
    private int capacityEnchantLevel;
    private class_2499 enchantmentTag;

    public CanisterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.state = state;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidStorage(null));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = CapacityEnchantedFluidTankBehaviour.single(this, Math.abs((Integer)ConfigRegistry.CANISTER_CAPACITY.get()), (Integer)ConfigRegistry.CANISTER_CAPACITY_ENCHANTMENT.get());
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("CapacityEnchantment", this.capacityEnchantLevel);
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        if (this.enchantmentTag != null) {
            compound.method_10566("Enchantments", (class_2520)this.enchantmentTag);
        }
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.capacityEnchantLevel = compound.method_10550("CapacityEnchantment");
        if (compound.method_10545("Enchantments")) {
            this.enchantmentTag = compound.method_10554("Enchantments", 10);
        }
        if (compound.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"));
        }
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public class_2561 getCustomName() {
        return this.customName;
    }

    public class_2499 getEnchantmentTag() {
        return this.enchantmentTag;
    }

    public void setEnchantmentTag(class_2499 enchantmentTag) {
        this.enchantmentTag = enchantmentTag;
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
        this.tank.getPrimaryHandler().setCapacity((long)(this.tank.baseCapacity + this.tank.capacityAddition * capacityEnchantLevel));
    }

    public static class CapacityEnchantedFluidTankBehaviour
    extends SmartFluidTankBehaviour {
        int capacityAddition;
        int baseCapacity;

        public CapacityEnchantedFluidTankBehaviour(BehaviourType<SmartFluidTankBehaviour> type, SmartBlockEntity be, int tanks, int tankCapacity, boolean enforceVariety, int capacityAddition) {
            super(type, be, tanks, (long)tankCapacity, enforceVariety);
            this.capacityAddition = capacityAddition;
            this.baseCapacity = tankCapacity;
        }

        public static CapacityEnchantedFluidTankBehaviour single(SmartBlockEntity be, int capacity, int capacityAddition) {
            return new CapacityEnchantedFluidTankBehaviour((BehaviourType<SmartFluidTankBehaviour>)TYPE, be, 1, capacity, false, capacityAddition);
        }

        public void read(class_2487 compound, boolean clientPacket) {
            super.read(compound, clientPacket);
            if (compound.method_10545("CapacityEnchantment")) {
                this.getPrimaryHandler().setCapacity((long)(this.baseCapacity + compound.method_10550("CapacityEnchantment") * this.capacityAddition));
            }
        }
    }
}

