/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.CreateDecoMod;
import com.github.talrey.createdeco.api.CDTags;
import com.github.talrey.createdeco.api.Coins;
import com.github.talrey.createdeco.items.CoinStackItem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ItemRegistry {
    public static ItemEntry<Item> ANDESITE_SHEET;
    public static ItemEntry<Item> ZINC_SHEET;
    public static ItemEntry<Item> NETHERITE_SHEET;
    public static ItemEntry<Item> NETHERITE_NUGGET;
    public static ItemEntry<Item> INDUSTRIAL_IRON_NUGGET;
    public static ItemEntry<Item> INDUSTRIAL_IRON_INGOT;
    public static ItemEntry<Item> INDUSTRIAL_IRON_SHEET;
    public static HashMap<String, Function<String, Item>> METAL_TYPES;
    public static HashMap<String, Function<String, Item>> COIN_METALS;
    public static HashMap<String, ItemEntry<Item>> COINS;
    public static HashMap<String, ItemEntry<CoinStackItem>> COINSTACKS;

    public static void init() {
        CreateDecoMod.LOGGER.info("Registering items for Create Deco");
        CreateDecoMod.REGISTRATE.defaultCreativeTab("props_tab");
        ItemRegistry.registerSheets();
        ItemRegistry.registerNuggets();
        ItemRegistry.registerIngots();
        METAL_TYPES.put("Andesite", str -> (Item)AllItems.ANDESITE_ALLOY.get());
        METAL_TYPES.put("Zinc", str -> (Item)AllItems.ZINC_INGOT.get());
        METAL_TYPES.put("Copper", str -> Items.f_151052_);
        METAL_TYPES.put("Brass", str -> (Item)AllItems.BRASS_INGOT.get());
        METAL_TYPES.put("Iron", str -> Items.f_42416_);
        METAL_TYPES.put("Industrial Iron", str -> (Item)INDUSTRIAL_IRON_INGOT.get());
        COIN_METALS.put("Gold", str -> Items.f_42417_);
        COIN_METALS.put("Netherite", str -> Items.f_42418_);
        METAL_TYPES.forEach(ItemRegistry::registerCoins);
        COIN_METALS.forEach(ItemRegistry::registerCoins);
    }

    private static void registerSheets() {
        ANDESITE_SHEET = CreateDecoMod.REGISTRATE.item("andesite_sheet", Item::new).tag(new TagKey[]{CDTags.of((String)"andesite", (String)"plates").tag}).lang("Andesite Alloy Sheet").register();
        ZINC_SHEET = CreateDecoMod.REGISTRATE.item("zinc_sheet", Item::new).tag(new TagKey[]{CDTags.of((String)"zinc", (String)"plates").tag}).lang("Zinc Sheet").register();
        NETHERITE_SHEET = CreateDecoMod.REGISTRATE.item("netherite_sheet", Item::new).properties(Item.Properties::m_41486_).tag(new TagKey[]{CDTags.of((String)"netherite", (String)"plates").tag}).lang("Netherite Sheet").register();
        INDUSTRIAL_IRON_SHEET = CreateDecoMod.REGISTRATE.item("industrial_iron_sheet", Item::new).tag(new TagKey[]{CDTags.of((String)"industrial_iron", (String)"plates").tag}).lang("Industrial Iron Sheet").register();
    }

    private static void registerNuggets() {
        NETHERITE_NUGGET = CreateDecoMod.REGISTRATE.item("netherite_nugget", Item::new).properties(Item.Properties::m_41486_).tag(new TagKey[]{CDTags.of((String)"netherite", (String)"nuggets").tag}).lang("Netherite Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, RecipeCategory.MISC, () -> Items.f_42418_)).register();
        INDUSTRIAL_IRON_NUGGET = CreateDecoMod.REGISTRATE.item("industrial_iron_nugget", Item::new).tag(new TagKey[]{CDTags.of((String)"industrial_iron", (String)"nuggets").tag}).lang("Industrial Iron Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, RecipeCategory.MISC, INDUSTRIAL_IRON_INGOT)).register();
    }

    private static void registerIngots() {
        INDUSTRIAL_IRON_INGOT = CreateDecoMod.REGISTRATE.item("industrial_iron_ingot", Item::new).tag(new TagKey[]{CDTags.of((String)"industrial_iron", (String)"ingots").tag}).lang("Industrial Iron Ingot").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, RecipeCategory.MISC, (NonNullSupplier)AllBlocks.INDUSTRIAL_IRON_BLOCK)).register();
    }

    private static void registerCoins(String metal, Function<String, Item> getter) {
        if (metal.equals("Andesite")) {
            return;
        }
        COINS.put(metal, (ItemEntry<Item>)Coins.buildCoinItem(CreateDecoMod.REGISTRATE, (NonNullSupplier<Item>)((NonNullSupplier)() -> (Item)COINSTACKS.get(metal).get()), metal).register());
        COINSTACKS.put(metal, (ItemEntry<CoinStackItem>)Coins.buildCoinStackItem(CreateDecoMod.REGISTRATE, (NonNullSupplier<Item>)((NonNullSupplier)() -> (Item)COINS.get(metal).get()), metal).register());
    }

    static {
        METAL_TYPES = new HashMap();
        COIN_METALS = new HashMap();
        COINS = new HashMap();
        COINSTACKS = new HashMap();
    }
}

