/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.charging;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SequencedAssemblyChargingRecipeSerializer
extends ProcessingRecipeSerializer<ChargingRecipe> {
    private static final String RESULT_KEY = "result";
    private static final String SEQUENCED_ASSEMBLY_RESULT_KEY = "results";
    private static final String INGREDIENT_KEY = "input";
    private static final String SEQUENCED_ASSEMBLY_INGREDIENT_KEY = "ingredients";

    public SequencedAssemblyChargingRecipeSerializer(ProcessingRecipeBuilder.ProcessingRecipeFactory<ChargingRecipe> factory) {
        super(factory);
    }

    protected void writeToJson(JsonObject json, ChargingRecipe recipe) {
        super.writeToJson(json, (ProcessingRecipe)recipe);
    }

    protected class_1799 readOutput(JsonObject json) {
        JsonElement results;
        if (json.has(RESULT_KEY)) {
            JsonElement result = json.get(RESULT_KEY);
            if (result.isJsonObject() && result.getAsJsonObject().has("item")) {
                return class_1869.method_35228((JsonObject)result.getAsJsonObject());
            }
        } else if (json.has(SEQUENCED_ASSEMBLY_RESULT_KEY) && (results = json.get(SEQUENCED_ASSEMBLY_RESULT_KEY)).isJsonArray() && !results.getAsJsonArray().isEmpty()) {
            JsonObject result = results.getAsJsonArray().get(0).getAsJsonObject();
            if (!result.has("count")) {
                result.add("count", (JsonElement)new JsonPrimitive((Number)1));
            }
            return class_1869.method_35228((JsonObject)result);
        }
        return class_1799.field_8037;
    }

    protected class_1856 readIngredient(JsonObject json) {
        JsonElement jsonArray;
        if (json.has(INGREDIENT_KEY)) {
            return class_1856.method_52177((JsonElement)json.get(INGREDIENT_KEY).getAsJsonObject());
        }
        if (json.has(SEQUENCED_ASSEMBLY_INGREDIENT_KEY) && (jsonArray = json.get(SEQUENCED_ASSEMBLY_INGREDIENT_KEY)).isJsonArray() && !jsonArray.getAsJsonArray().isEmpty()) {
            return class_1856.method_52177((JsonElement)jsonArray.getAsJsonArray().get(0));
        }
        return class_1856.field_9017;
    }

    protected ChargingRecipe readFromJson(class_2960 recipeId, JsonObject json) {
        class_1799 output = this.readOutput(json);
        class_1856 input = this.readIngredient(json);
        int energy = json.get("energy").getAsInt();
        int maxChargeRate = Integer.MAX_VALUE;
        if (json.has("maxChargeRate")) {
            maxChargeRate = json.get("maxChargeRate").getAsInt();
        }
        return new ChargingRecipe(recipeId, input, output, energy, maxChargeRate);
    }

    protected void writeToBuffer(class_2540 buffer, ChargingRecipe recipe) {
        buffer.writeInt(recipe.maxChargeRate);
        recipe.ingredient.method_8088(buffer);
        buffer.method_10793(recipe.output);
        buffer.writeInt(recipe.energy);
    }

    protected ChargingRecipe readFromBuffer(class_2960 recipeId, class_2540 buffer) {
        int maxChargeRate = buffer.readInt();
        class_1856 input = class_1856.method_8086((class_2540)buffer);
        class_1799 output = buffer.method_10819();
        int energy = buffer.readInt();
        return new ChargingRecipe(recipeId, input, output, energy, maxChargeRate);
    }
}

