/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.rolling_mill;

import com.google.common.collect.ImmutableList;
import com.mrh0.createaddition.blocks.rolling_mill.RollingMillBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.recipe.rolling.RollingRecipe;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class RollingMillBlockEntity
extends KineticBlockEntity
implements SidedStorageBlockEntity {
    private static final Object rollingRecipesKey = new Object();
    public ProcessingInventory inventory = new ProcessingInventory(this::start);
    private int recipeIndex;
    private class_1799 playEvent;

    public RollingMillBlockEntity(class_2591<? extends RollingMillBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.playEvent = class_1799.field_8037;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.method_5442() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        float processingSpeed = class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnParticles();
        }
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return;
            }
            this.playEvent = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        class_243 itemMovement = this.getItemMovementVec();
        class_2350 itemMovementFacing = this.getEjectDirection();
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
            class_1799 tryExportingToBeltFunnel;
            class_1799 stack = this.inventory.getStackInSlot(slot);
            if (stack.method_7960() || (tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, itemMovementFacing.method_10153(), false)) == null) continue;
            if (tryExportingToBeltFunnel.method_7947() != stack.method_7947()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.method_7960()) continue;
            return;
        }
        class_2338 nextPos = this.field_11867.method_10093(itemMovementFacing);
        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((class_1922)this.field_11863, (class_2338)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.field_11863.field_9236 && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
                class_1799 remainder;
                class_1799 stack = this.inventory.getStackInSlot(slot);
                if (stack.method_7960() || class_1799.method_7973((class_1799)(remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)), (class_1799)stack)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.method_5431();
                this.sendData();
            }
            return;
        }
        class_243 outPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(itemMovement.method_1021(0.5).method_1031(0.0, 0.5, 0.0));
        class_243 outMotion = itemMovement.method_1021(0.0625).method_1031(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlotCount(); ++slot) {
            class_1799 stack = this.inventory.getStackInSlot(slot);
            if (stack.method_7960()) continue;
            class_1542 entityIn = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351, outPos.field_1350, stack);
            entityIn.method_18799(outMotion);
            this.field_11863.method_8649((class_1297)entityIn);
        }
        this.inventory.clear();
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((class_1937)this.field_11863, (class_2338)this.field_11867, (Storage)this.inventory);
    }

    public void spawnParticles() {
        class_1799 stackInSlot = this.playEvent.method_7972();
        if (stackInSlot.method_7960()) {
            return;
        }
        class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
        assert (this.field_11863 != null);
        float angle = this.field_11863.field_9229.method_43057() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((class_243)offset, (double)angle, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate((class_243)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 center = offset.method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly((class_243)target.method_1020(offset), (class_5819)this.field_11863.field_9229, (float)0.0078125f);
        this.field_11863.method_8406((class_2394)data, center.field_1352, center.field_1351, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    public class_243 getItemMovementVec() {
        class_2350 dir = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
        boolean alongX = dir == class_2350.field_11043 || dir == class_2350.field_11035;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new class_243((double)(offset * (alongX ? -1 : 0)), 0.0, (double)(offset * (alongX ? 0 : 1)));
    }

    private void applyRecipe() {
        List<class_1860<?>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        class_1860<?> recipe = recipes.get(this.recipeIndex);
        int rolls = this.inventory.getStackInSlot(0).method_7947();
        this.inventory.clear();
        ArrayList list = new ArrayList();
        for (int roll = 0; roll < rolls; ++roll) {
            List results = new LinkedList();
            if (recipe instanceof RollingRecipe) {
                results = ((RollingRecipe)recipe).rollResults();
            }
            for (int i = 0; i < results.size(); ++i) {
                class_1799 stack = (class_1799)results.get(i);
                ItemHelper.addToList((class_1799)stack, list);
            }
        }
        for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlotCount(); ++slot) {
            this.inventory.setStackInSlot(slot + 1, (class_1799)list.get(slot));
        }
    }

    private List<? extends class_1860<?>> getRecipes() {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((class_1937)this.field_11863, (class_1799)this.inventory.getStackInSlot(0), CARecipes.ROLLING_TYPE.get(), RollingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return ImmutableList.of((Object)((Object)((RollingRecipe)((Object)assemblyRecipe.get()))));
        }
        Predicate types = RecipeConditions.isOfType((class_3956[])new class_3956[]{CARecipes.ROLLING_TYPE.get()});
        List startedSearch = RecipeFinder.get((Object)rollingRecipesKey, (class_1937)this.field_11863, (Predicate)types);
        return startedSearch.stream().filter(RecipeConditions.firstIngredientMatches((class_1799)this.inventory.getStackInSlot(0))).filter(r -> !AllRecipeTypes.shouldIgnoreInAutomation((class_1860)r)).collect(Collectors.toList());
    }

    public void insertItem(class_1542 entity) {
        if (!this.inventory.method_5442()) {
            return;
        }
        if (!entity.method_5805()) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        this.inventory.clear();
        try (Transaction t = TransferUtil.getTransaction();){
            class_1799 contained = entity.method_6983();
            long inserted = this.inventory.insert(ItemVariant.of((class_1799)contained), (long)contained.method_7947(), (TransactionContext)t);
            if ((long)contained.method_7947() == inserted) {
                entity.method_31472();
            } else {
                entity.method_6979(ItemHandlerHelper.copyStackWithSize((class_1799)contained, (int)((int)((long)contained.method_7947() - inserted))));
            }
            t.commit();
        }
    }

    public void start(class_1799 inserted) {
        class_1860<?> recipe;
        if (this.inventory.method_5442()) {
            return;
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        List<class_1860<?>> recipes = this.getRecipes();
        boolean valid = !recipes.isEmpty();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        if ((recipe = recipes.get(this.recipeIndex)) instanceof RollingRecipe) {
            time = ((RollingRecipe)recipe).getProcessingDuration();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.method_7947() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    private class_2350 getEjectDirection() {
        RollingMillBlock block = (RollingMillBlock)this.method_11010().method_26204();
        float speed = this.getSpeed();
        block.getRotationAxis(this.method_11010());
        boolean rotation = speed >= 0.0f;
        class_2350 ejectDirection = class_2350.field_11036;
        switch (block.getRotationAxis(this.method_11010())) {
            case field_11048: {
                ejectDirection = rotation ? class_2350.field_11035 : class_2350.field_11043;
                break;
            }
            case field_11051: {
                ejectDirection = rotation ? class_2350.field_11039 : class_2350.field_11034;
            }
        }
        return ejectDirection;
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        compound.method_10569("RecipeIndex", this.recipeIndex);
        super.write(compound, clientPacket);
        if (!clientPacket || this.playEvent.method_7960()) {
            return;
        }
        compound.method_10566("PlayEvent", NBTSerializer.serializeNBT((Object)this.playEvent));
        this.playEvent = class_1799.field_8037;
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
        this.recipeIndex = compound.method_10550("RecipeIndex");
        if (compound.method_10545("PlayEvent")) {
            this.playEvent = class_1799.method_7915((class_2487)compound.method_10562("PlayEvent"));
        }
    }

    public int getProcessingSpeed() {
        return class_3532.method_15340((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.inventory;
    }

    private boolean canProcess(class_1799 stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        class_1799 stack2 = this.playEvent;
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper(tester);
        Optional sequenced = SequencedAssemblyRecipe.getRecipe((class_1937)this.field_11863, (class_1799)stack, CARecipes.ROLLING_TYPE.get(), RollingRecipe.class);
        if (sequenced.isPresent()) {
            return true;
        }
        assert (this.field_11863 != null);
        return this.find(inventoryIn, this.field_11863).isPresent();
    }

    public Optional<RollingRecipe> find(RecipeWrapper inv, class_1937 world) {
        Optional sequenced = SequencedAssemblyRecipe.getRecipe((class_1937)this.field_11863, (class_1799)inv.method_5438(0), CARecipes.ROLLING_TYPE.get(), RollingRecipe.class);
        if (sequenced.isPresent()) {
            return sequenced;
        }
        return world.method_8433().method_8132(CARecipes.ROLLING_TYPE.get(), (class_1263)inv, world);
    }

    public static int getProcessingDuration() {
        return (Integer)Config.ROLLING_MILL_PROCESSING_DURATION.get();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)((Integer)Config.ROLLING_MILL_STRESS.get()).intValue();
        return impact;
    }
}

