/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.tooltip;

import com.copycatsplus.copycats.foundation.tooltip.CopycatCharacteristics;
import com.copycatsplus.copycats.foundation.tooltip.fabric.CopycatDescriptionImpl;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class CopycatDescription {
    public static final Map<class_1792, List<CopycatCharacteristics>> ITEM_CHARACTERISTICS = new HashMap<class_1792, List<CopycatCharacteristics>>();
    protected final class_1792 item;
    private class_2477 cachedLanguage = null;
    private Map<String, List<Object>> cachedArgs = new HashMap<String, List<Object>>();
    private Map<CopycatCharacteristics, Pair<List<class_2561>, List<class_2561>>> descriptions;
    @Nullable
    private List<class_2561> shortDescription = null;
    @Nullable
    private List<class_2561> longDescription = null;

    public static void register(class_1935 item, CopycatCharacteristics ... characteristics) {
        ITEM_CHARACTERISTICS.put(item.method_8389(), List.of(characteristics));
    }

    public static <T extends class_1935> NonNullConsumer<? super T> register(CopycatCharacteristics ... characteristics) {
        return item -> CopycatDescription.register((class_1935)item.method_8389(), characteristics);
    }

    protected CopycatDescription(class_1792 item) {
        this.item = item;
    }

    private void loadDescriptions(class_1792 item) {
        List<CopycatCharacteristics> characteristics = ITEM_CHARACTERISTICS.get(item);
        if (characteristics == null) {
            this.shortDescription = new ArrayList<class_2561>();
            this.longDescription = new ArrayList<class_2561>();
            return;
        }
        this.shortDescription = new ArrayList<class_2561>(characteristics.size());
        this.longDescription = new ArrayList<class_2561>(characteristics.size() * 2);
        for (CopycatCharacteristics characteristic : characteristics) {
            Pair<List<class_2561>, List<class_2561>> pair = this.descriptions.get((Object)characteristic);
            if (pair == null) continue;
            this.shortDescription.addAll((Collection)pair.getFirst());
            this.longDescription.addAll((Collection)pair.getFirst());
            this.longDescription.addAll((Collection)pair.getSecond());
        }
        String[] holdDesc = Lang.translateDirect((String)"tooltip.holdForDescription", (Object[])new Object[]{"$"}).getString().split("\\$");
        class_5250 keyShift = Lang.translateDirect((String)"tooltip.keyShift", (Object[])new Object[0]);
        for (boolean shift : Iterate.falseAndTrue) {
            class_5250 tabBuilder = Components.empty();
            tabBuilder.method_10852((class_2561)Components.literal((String)holdDesc[0]).method_27692(class_124.field_1063));
            tabBuilder.method_10852((class_2561)keyShift.method_27662().method_27692(shift ? class_124.field_1068 : class_124.field_1080));
            tabBuilder.method_10852((class_2561)Components.literal((String)holdDesc[1]).method_27692(class_124.field_1063));
            (shift ? this.longDescription : this.shortDescription).add(0, (class_2561)tabBuilder);
            (shift ? this.longDescription : this.shortDescription).add(1, Components.immutableEmpty());
        }
    }

    public void modify(class_1792 item, List<class_2561> tooltip) {
        if (this.shouldInvalidateCache()) {
            this.populateDescriptions();
            this.loadDescriptions(item);
        }
        if (this.shortDescription == null || this.longDescription == null) {
            this.loadDescriptions(item);
        }
        if (class_437.method_25442()) {
            if (this.longDescription != null) {
                tooltip.addAll(1, this.longDescription);
            }
        } else if (this.shortDescription != null) {
            tooltip.addAll(1, this.shortDescription);
        }
    }

    private boolean shouldInvalidateCache() {
        class_2477 currentLanguage = class_2477.method_10517();
        HashMap<String, List<Object>> newArgs = new HashMap<String, List<Object>>();
        for (CopycatCharacteristics characteristics : CopycatCharacteristics.all()) {
            newArgs.put(characteristics.method_15434(), Arrays.stream(characteristics.getArgs()).map(Supplier::get).toList());
        }
        if (!currentLanguage.equals(this.cachedLanguage) || !newArgs.equals(this.cachedArgs)) {
            this.cachedLanguage = currentLanguage;
            this.cachedArgs = newArgs;
            return true;
        }
        return false;
    }

    private void populateDescriptions() {
        this.descriptions = new HashMap<CopycatCharacteristics, Pair<List<class_2561>, List<class_2561>>>();
        for (CopycatCharacteristics characteristics : CopycatCharacteristics.all()) {
            String titleKey = characteristics.getTitleKey();
            String descKey = characteristics.getDescriptionKey();
            if (!this.cachedLanguage.method_4678(titleKey) || !this.cachedLanguage.method_4678(descKey)) continue;
            this.descriptions.put(characteristics, (Pair<List<class_2561>, List<class_2561>>)Pair.of(List.of(Components.literal((String)("- " + this.cachedLanguage.method_48307(titleKey))).method_27692(class_124.field_1080)), (Object)TooltipHelper.cutStringTextComponent((String)String.format(this.cachedLanguage.method_48307(descKey), this.cachedArgs.get(characteristics.method_15434()).toArray()), (TooltipHelper.Palette)TooltipHelper.Palette.STANDARD_CREATE)));
        }
    }

    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static TooltipModifier create(class_1935 item) {
        return CopycatDescriptionImpl.create(item);
    }
}

