/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.config;

import com.copycatsplus.copycats.config.CClient;
import com.copycatsplus.copycats.config.CCommon;
import com.copycatsplus.copycats.config.SyncConfigBase;
import com.copycatsplus.copycats.config.fabric.CCConfigsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class CCConfigs {
    public static final Map<ModConfig.Type, SyncConfigBase> CONFIGS = new EnumMap<ModConfig.Type, SyncConfigBase>(ModConfig.Type.class);
    protected static CClient client;
    protected static CCommon common;

    public static CClient client() {
        return client;
    }

    public static CCommon common() {
        return common;
    }

    public static <T> Supplier<T> safeGetter(Supplier<T> getter, T defaultValue) {
        return () -> {
            try {
                return getter.get();
            }
            catch (IllegalStateException | NullPointerException ex) {
                return defaultValue;
            }
        };
    }

    public static SyncConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    public static <T extends SyncConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            SyncConfigBase config = (SyncConfigBase)((Object)((Object)factory.get()));
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        SyncConfigBase config = (SyncConfigBase)((Object)specPair.getLeft());
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)((Object)config);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void register() {
        CCConfigsImpl.register();
    }
}

