/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.systems.fluid;

import com.hypherionmc.craterlib.core.systems.fluid.CraterFluidTank;
import com.hypherionmc.craterlib.core.systems.fluid.FluidHolder;
import com.hypherionmc.craterlib.core.systems.fluid.ICraterFluidHandler;
import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class ForgeWrappedFluidTank
extends CraterFluidTank
implements IFluidTank,
IFluidHandler {
    public ForgeWrappedFluidTank(int capacity) {
        super(capacity);
    }

    public ForgeWrappedFluidTank(int capacity, Predicate<FluidStack> predicate) {
        super(capacity, (FluidHolder p) -> predicate.test(new FluidStack(p.getFluid(), p.getAmount())));
    }

    @NotNull
    public FluidStack getFluid() {
        return new FluidStack(this.getFluidInTank().getFluid(), this.getTankLevel());
    }

    public int getFluidAmount() {
        return this.getTankLevel();
    }

    public int getCapacity() {
        return this.getTankCapacity();
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.isValidFluid(new FluidHolder(stack.getFluid(), stack.getAmount()));
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tankInt) {
        return new FluidStack(this.getFluidInTank().getFluid(), this.getTankLevel());
    }

    public int getTankCapacity(int tankInt) {
        return this.getTankCapacity();
    }

    public boolean isFluidValid(int tankInt, @NotNull FluidStack stack) {
        return this.isValidFluid(new FluidHolder(stack.getFluid(), stack.getAmount()));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.insert(new FluidHolder(resource.getFluid(), resource.getAmount()), action.simulate() ? ICraterFluidHandler.FluidAction.SIMULATE : ICraterFluidHandler.FluidAction.EXECUTE);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidHolder extracted = this.extract(maxDrain, action.simulate() ? ICraterFluidHandler.FluidAction.SIMULATE : ICraterFluidHandler.FluidAction.EXECUTE);
        return new FluidStack(extracted.getFluid(), extracted.getAmount());
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidHolder holder = this.extract(new FluidHolder(resource.getFluid(), resource.getAmount()), action.simulate() ? ICraterFluidHandler.FluidAction.SIMULATE : ICraterFluidHandler.FluidAction.EXECUTE);
        return new FluidStack(holder.getFluid(), holder.getAmount());
    }
}

