/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu.slot;

import net.blay09.mods.cookingforblockheads.menu.slot.FakeSlot;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CraftMatrixFakeSlot
extends FakeSlot {
    private static final float ITEM_SWITCH_TIME = 80.0f;
    private final NonNullList<ItemStack> visibleStacks = NonNullList.m_122779_();
    private float visibleItemTime;
    private int visibleItemIndex;
    private boolean isLocked;
    private boolean available = true;

    public CraftMatrixFakeSlot(Container container, int slotId, int x, int y) {
        super(container, slotId, x, y);
    }

    public void setIngredient(@Nullable NonNullList<ItemStack> ingredients) {
        ItemStack prevLockStack = this.isLocked ? this.m_7993_() : ItemStack.f_41583_;
        this.visibleStacks.clear();
        if (ingredients != null) {
            for (ItemStack itemStack : ingredients) {
                if (itemStack.m_41619_()) continue;
                itemStack.m_41764_(1);
                this.visibleStacks.add((Object)itemStack);
            }
        }
        this.visibleItemTime = 0.0f;
        this.visibleItemIndex = !this.visibleStacks.isEmpty() ? this.f_40219_ % this.visibleStacks.size() : 0;
        this.isLocked = false;
        if (!prevLockStack.m_41619_()) {
            for (int i = 0; i < this.visibleStacks.size(); ++i) {
                if (!ItemStack.m_41656_((ItemStack)((ItemStack)this.visibleStacks.get(i)), (ItemStack)prevLockStack)) continue;
                this.visibleItemIndex = i;
                this.isLocked = true;
            }
        }
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void updateSlot(float partialTicks) {
        if (!this.isLocked) {
            this.visibleItemTime += partialTicks;
            if (this.visibleItemTime >= 80.0f) {
                ++this.visibleItemIndex;
                if (this.visibleItemIndex >= this.visibleStacks.size()) {
                    this.visibleItemIndex = 0;
                }
                this.visibleItemTime = 0.0f;
            }
        }
    }

    @Override
    public ItemStack m_7993_() {
        return this.visibleStacks.size() > 0 ? (ItemStack)this.visibleStacks.get(this.visibleItemIndex) : ItemStack.f_41583_;
    }

    @Override
    public boolean m_6657_() {
        return this.visibleStacks.size() > 0;
    }

    public boolean m_6659_() {
        return this.visibleStacks.size() > 0;
    }

    public NonNullList<ItemStack> getVisibleStacks() {
        return this.visibleStacks;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public void scrollDisplayList(int i) {
        this.isLocked = true;
        this.visibleItemIndex += i;
        if (this.visibleItemIndex >= this.visibleStacks.size()) {
            this.visibleItemIndex = 0;
        } else if (this.visibleItemIndex < 0) {
            this.visibleItemIndex = this.visibleStacks.size() - 1;
        }
    }
}

