REIEvents.hide("item", event => {
    event.hide([
        /railways:.+_incomplete_conductor_cap/,
        /railways:track_incomplete/
    ]);
});

REIEvents.groupEntries(event => {
    // Combine all the identical items with NBT differences.
    const useNbt = ["painting", "potion", "enchanted_book", "splash_potion", "tipped_arrow", "lingering_potion",
        "suspicious_stew", "supplementaries:bunting"];

    useNbt.forEach(id => {
        const item = Item.of(id)
        const { namespace, path } = Utils.id(item.id)
        event.groupSameItem(`kubejs:rei_groups/${namespace}/${path}`, item.displayName, item)
    });

    // Combine all conductor hats.
    event.groupItems("kubejs:rei_groups/railways/hats", "Conductor Hats", [
        /railways:.+conductor_cap/
    ])

    // Combine all the chipped tags.
    const chippedTags = ["cyan_carpet", "special_lantern", "acacia_planks", "orange_wool", "glass", "cherry_planks",
        "end_stone", "stripped_oak_log", "spruce_leaves", "white_concrete", "crimson_door", "coal_block", "black_wool",
        "ladder", "blue_stained_glass", "pointed_dripstone", "purple_terracotta", "oak_door", "lantern", "packed_ice",
        "black_terracotta", "waxed_weathered_copper", "red_glazed_terracotta", "purple_glazed_terracotta",
        "red_sandstone", "warped_wart_block", "spruce_planks", "special_soul_lantern", "prismarine", "magenta_wool",
        "birch_log", "mangrove_trapdoor", "orange_concrete", "cherry_log", "bricks", "nether_bricks", "yellow_concrete",
        "bamboo_planks", "mangrove_roots", "deepslate", "brown_terracotta", "blue_concrete", "magenta_stained_glass",
        "raw_copper_block", "diamond_block", "gravel", "light_gray_stained_glass_pane", "yellow_stained_glass_pane",
        "orange_carpet", "magenta_concrete", "hay_block", "waxed_exposed_copper_block", "blue_terracotta",
        "white_carpet", "black_stained_glass_pane", "green_concrete", "blue_wool", "redstone_block", "dirt",
        "light_gray_stained_glass", "amethyst_block", "red_nether_bricks", "iron_bars", "pink_stained_glass_pane",
        "warped_planks", "warped_trapdoor", "cyan_terracotta", "dark_oak_door", "acacia_leaves", "brown_wool",
        "blue_ice", "lime_stained_glass_pane", "black_glazed_terracotta", "purple_wool", "glowstone", "barrel",
        "light_blue_concrete", "lime_terracotta", "yellow_wool", "cyan_glazed_terracotta", "lodestone", "spruce_log",
        "ochre_froglight", "cyan_stained_glass", "red_wool", "sandstone", "white_stained_glass",
        "cyan_stained_glass_pane", "redstone_lamp", "brown_glazed_terracotta", "lily_pad", "orange_terracotta",
        "crimson_trapdoor", "crimson_planks", "dark_oak_planks", "light_gray_concrete", "warped_roots", "birch_planks",
        "oak_leaves", "jungle_door", "shroomlight", "stripped_cherry_log", "melon", "red_mushroom", "tuff",
        "green_glazed_terracotta", "soul_lantern", "orange_glazed_terracotta", "brown_stained_glass", "brown_mushroom",
        "orange_stained_glass", "pink_terracotta", "moss_block", "cherry_trapdoor", "crimson_fungus", "magenta_carpet",
        "light_gray_terracotta", "basalt", "red_stained_glass", "verdant_froglight", "raw_iron_block", "pink_carpet",
        "gray_stained_glass_pane", "pink_wool", "magenta_terracotta", "gilded_blackstone", "white_terracotta",
        "purple_stained_glass", "mangrove_planks", "light_gray_glazed_terracotta", "warped_door", "ancient_debris",
        "soul_sand", "magenta_stained_glass_pane", "calcite", "granite", "warped_stem", "cobblestone", "blue_carpet",
        "yellow_glazed_terracotta", "jack_o_lantern", "dried_kelp_block", "white_wool", "crimson_roots",
        "mushroom_stem", "terracotta", "light_gray_carpet", "light_blue_glazed_terracotta", "yellow_terracotta",
        "oak_planks", "andesite", "bone_block", "purpur_block", "emerald_block", "warped_fungus", "gray_terracotta",
        "stripped_acacia_log", "sponge", "dark_oak_leaves", "black_concrete", "blue_stained_glass_pane",
        "lime_glazed_terracotta", "gray_wool", "red_concrete", "cyan_concrete", "diorite", "sand",
        "blue_glazed_terracotta", "sea_lantern", "red_terracotta", "dripstone_block", "lime_wool", "gray_concrete",
        "vine", "cobweb", "yellow_stained_glass", "green_stained_glass_pane", "netherrack", "brown_mushroom_block",
        "stripped_jungle_log", "bookshelf", "borderless_bricks", "brown_carpet", "pumpkin", "pink_stained_glass",
        "dark_oak_trapdoor", "light_gray_wool", "mud", "red_carpet", "purple_stained_glass_pane",
        "light_blue_stained_glass", "crimson_stem", "waxed_copper_block", "cherry_door", "jungle_planks",
        "dark_prismarine", "red_stained_glass_pane", "oak_log", "quartz_block", "lime_concrete", "bamboo_door",
        "pink_glazed_terracotta", "waxed_oxidized_copper", "mossy_stone_bricks", "pearlescent_froglight",
        "jungle_leaves", "stripped_spruce_log", "green_terracotta", "clay", "acacia_door", "snow_block",
        "gray_glazed_terracotta", "nether_wart_block", "torch", "stripped_warped_stem", "black_stained_glass",
        "nether_sprouts", "acacia_log", "dark_oak_log", "packed_mud", "mossy_cobblestone", "spruce_trapdoor",
        "gray_carpet", "lime_stained_glass", "lapis_block", "light_blue_stained_glass_pane", "carved_pumpkin",
        "purple_concrete", "green_stained_glass", "green_wool", "jungle_trapdoor", "white_stained_glass_pane",
        "spruce_door", "brown_concrete", "blackstone", "crying_obsidian", "magma_block", "stripped_dark_oak_log",
        "acacia_trapdoor", "oak_trapdoor", "red_mushroom_block", "ice", "orange_stained_glass_pane", "birch_leaves",
        "redstone_torch", "magenta_glazed_terracotta", "jungle_log", "birch_door", "gray_stained_glass",
        "stripped_mangrove_log", "raw_gold_block", "stripped_birch_log", "light_blue_wool", "smooth_stone",
        "yellow_carpet", "glass_pane", "brown_stained_glass_pane", "stripped_crimson_stem", "purple_carpet",
        "pink_concrete", "lime_carpet", "iron_block", "black_carpet", "mud_bricks", "birch_trapdoor", "cyan_wool",
        "mangrove_door", "light_blue_terracotta", "green_carpet", "obsidian", "mangrove_log", "white_glazed_terracotta",
        "stone", "bamboo_trapdoor", "gold_block", "light_blue_carpet", "netherite_block"];

    chippedTags.forEach(tag =>
        event.groupItemsByTag(`kubejs:rei_groups/chipped/${tag}`,
            tag.split("_").filter(x => x.length > 0).map((x) => (x.charAt(0).toUpperCase() + x.slice(1))).join(" "),
            `chipped:${tag}`));

    const tags = ["railways:locometal", "storagedrawers:drawers", "comforts:sleeping_bags", "comforts:hammocks",
        "fwaystones:waystones", "supplementaries:flags", "supplementaries:presents", "supplementaries:awnings",
        "supplementaries:candle_holders", "supplementaries:sign_posts"];

    tags.forEach(tag =>
        event.groupItemsByTag(`kubejs:rei_groups/${tag.split(":").join("/")}`,
            tag.split(":")[1].split("_").filter(x => x.length > 0).map((x) => (x.charAt(0).toUpperCase() + x.slice(1))).join(" "),
            tag));
});