/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.measuring;

import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.util.BlockHitResultUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public enum MeasuringType implements IToolModeGroup
{
    BIT((Component)LocalStrings.TapeMeasureBit.getText(), new ResourceLocation("chiselsandbits", "textures/icons/bit.png"), blockHitResult -> BlockHitResultUtils.getCenterOfHitObject(blockHitResult, StateEntrySize.current().getSizePerBitScalingVector()), (from, to, hitFace) -> new Vec3(Math.min(from.m_7096_(), to.m_7096_()) - (double)StateEntrySize.current().getSizePerHalfBit(), Math.min(from.m_7098_(), to.m_7098_()) - (double)StateEntrySize.current().getSizePerHalfBit(), Math.min(from.m_7094_(), to.m_7094_()) - (double)StateEntrySize.current().getSizePerHalfBit()), (from, to, hitFace) -> new Vec3(Math.max(from.m_7096_(), to.m_7096_()) + (double)StateEntrySize.current().getSizePerHalfBit(), Math.max(from.m_7098_(), to.m_7098_()) + (double)StateEntrySize.current().getSizePerHalfBit(), Math.max(from.m_7094_(), to.m_7094_()) + (double)StateEntrySize.current().getSizePerHalfBit()), true),
    BLOCK((Component)LocalStrings.TapeMeasureBlock.getText(), new ResourceLocation("chiselsandbits", "textures/icons/block.png"), blockHitResult -> BlockHitResultUtils.getCenterOfHitObject(blockHitResult, VectorUtils.ONE), (from, to, hitFace) -> new Vec3(Math.min(from.m_7096_(), to.m_7096_()) - 0.499, Math.min(from.m_7098_(), to.m_7098_()) - 0.499, Math.min(from.m_7094_(), to.m_7094_()) - 0.499), (from, to, hitFace) -> new Vec3(Math.max(from.m_7096_(), to.m_7096_()) + 0.499, Math.max(from.m_7098_(), to.m_7098_()) + 0.499, Math.max(from.m_7094_(), to.m_7094_()) + 0.499), true),
    DISTANCE((Component)LocalStrings.TapeMeasureDistance.getText(), new ResourceLocation("chiselsandbits", "textures/icons/line.png"), IClickedPositionAdapter.identity(), (from, to, hitFace) -> from, (from, to, hitFace) -> to, false);

    private final Component displayName;
    private final ResourceLocation icon;
    private final IClickedPositionAdapter clickedPositionAdapter;
    private final IPositionAdapter finalStartPositionAdapter;
    private final IPositionAdapter finalEndPositionAdapter;
    private final boolean needsNormalization;

    private MeasuringType(Component displayName, ResourceLocation icon, IClickedPositionAdapter startPositionAdapter, IPositionAdapter finalStartPositionAdapter, IPositionAdapter finalEndPositionAdapter, boolean needsNormalization) {
        this.displayName = displayName;
        this.icon = icon;
        this.clickedPositionAdapter = startPositionAdapter;
        this.finalStartPositionAdapter = finalStartPositionAdapter;
        this.finalEndPositionAdapter = finalEndPositionAdapter;
        this.needsNormalization = needsNormalization;
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Vec3 adaptClickedPosition(@NotNull BlockHitResult blockHitResult) {
        return this.clickedPositionAdapter.adapt(blockHitResult);
    }

    @NotNull
    public Vec3 adaptStartCorner(@NotNull Vec3 startPosition, @NotNull Vec3 endPosition, @NotNull Direction hitFace) {
        return this.finalStartPositionAdapter.adapt(startPosition, endPosition, hitFace);
    }

    @NotNull
    public Vec3 adaptEndCorner(@NotNull Vec3 startPosition, @NotNull Vec3 endPosition, @NotNull Direction hitFace) {
        return this.finalEndPositionAdapter.adapt(startPosition, endPosition, hitFace);
    }

    public Vec3 getResolution() {
        return new Vec3(1.0, 1.0, 1.0);
    }

    public boolean isNeedsNormalization() {
        return this.needsNormalization;
    }

    @FunctionalInterface
    private static interface IClickedPositionAdapter {
        public static IClickedPositionAdapter identity() {
            return HitResult::m_82450_;
        }

        @NotNull
        public Vec3 adapt(@NotNull BlockHitResult var1);
    }

    @FunctionalInterface
    private static interface IPositionAdapter {
        @NotNull
        public Vec3 adapt(@NotNull Vec3 var1, @NotNull Vec3 var2, @NotNull Direction var3);
    }
}

