/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.integration.modmenu;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.base.CharmonyConfig;
import svenhjol.charmony.base.DefaultFeature;
import svenhjol.charmony.base.Log;
import svenhjol.charmony.base.Mods;
import svenhjol.charmony.client.ClientFeature;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.helper.TextHelper;
import svenhjol.charmony.iface.IClientMod;
import svenhjol.charmony.iface.ICommonMod;
import svenhjol.charmony.iface.ILog;
import svenhjol.charmony.iface.IMod;

public class CharmoniumModMenuPlugin<F extends DefaultFeature>
implements ModMenuApi {
    public String modId() {
        return "charmonium";
    }

    public Optional<IClientMod> client() {
        return Mods.optionalClient((String)this.modId());
    }

    public Optional<ICommonMod> common() {
        return Mods.optionalCommon((String)this.modId());
    }

    public ILog log() {
        return Mods.optionalCommon((String)this.modId()).map(IMod::log).orElse((ILog)new Log(this.modId()));
    }

    public List<F> getFeatures() {
        ArrayList<DefaultFeature> features = new ArrayList<DefaultFeature>();
        this.common().ifPresent(m -> features.addAll(m.loader().getFeatures()));
        this.client().ifPresent(m -> features.addAll(m.loader().getFeatures()));
        features.sort(Comparator.comparing(DefaultFeature::name));
        return features;
    }

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)TextHelper.translatable((String)("cloth." + this.modId() + ".title")));
            LinkedList<F> features = new LinkedList<F>(this.getFeatures());
            features.sort(Comparator.comparing(DefaultFeature::name));
            builder.setSavingRunnable(() -> {
                LinkedList<CommonFeature> commonFeatures = new LinkedList<CommonFeature>();
                LinkedList<ClientFeature> clientFeatures = new LinkedList<ClientFeature>();
                for (DefaultFeature feature : features) {
                    if (feature instanceof CommonFeature) {
                        CommonFeature common = (CommonFeature)feature;
                        commonFeatures.add(common);
                        continue;
                    }
                    if (!(feature instanceof ClientFeature)) continue;
                    ClientFeature client = (ClientFeature)feature;
                    clientFeatures.add(client);
                }
                this.common().ifPresent(m -> m.config().writeConfig(commonFeatures));
                this.client().ifPresent(m -> m.config().writeConfig(clientFeatures));
            });
            ConfigCategory category = builder.getOrCreateCategory((class_2561)TextHelper.translatable((String)("cloth.category." + this.modId() + ".title")));
            for (DefaultFeature feature : features) {
                SubCategoryBuilder subcategory = null;
                boolean enabled = false;
                String name = feature.name();
                String description = feature.description();
                Map<Field, Object> properties = this.getFeatureConfigProperties(feature);
                if (feature.canBeDisabled()) {
                    subcategory = this.startSubcategory(builder, name, description);
                    subcategory.add((AbstractConfigListEntry)builder.entryBuilder().startTextDescription((class_2561)class_2561.method_43470((String)description)).build());
                    class_5250 toggleFeatureName = TextHelper.translatable((String)("cloth.category." + this.modId() + ".feature_enabled"), (Object[])new Object[]{name});
                    boolean defaultValue = feature.isEnabledByDefault();
                    enabled = feature.isEnabledInConfig();
                    BooleanToggleBuilder featureEntryBuilder = builder.entryBuilder().startBooleanToggle((class_2561)toggleFeatureName, enabled).setDefaultValue(() -> defaultValue).setSaveConsumer(arg_0 -> ((DefaultFeature)feature).setEnabledInConfig(arg_0));
                    if (featureEntryBuilder != null) {
                        featureEntryBuilder.requireRestart();
                        subcategory.add((AbstractConfigListEntry)featureEntryBuilder.build());
                    }
                }
                for (Map.Entry<Field, Object> entry : properties.entrySet()) {
                    if (subcategory == null) {
                        subcategory = this.startSubcategory(builder, name, description);
                    }
                    Field prop = entry.getKey();
                    Object value = entry.getValue();
                    Configurable annotation = prop.getDeclaredAnnotation(Configurable.class);
                    class_5250 propName = TextHelper.literal((String)annotation.name());
                    class_5250 propDescription = TextHelper.literal((String)TextHelper.splitOverLines((String)annotation.description()));
                    boolean requireRestart = annotation.requireRestart();
                    BooleanToggleBuilder fieldBuilder = null;
                    if (value instanceof Boolean) {
                        fieldBuilder = builder.entryBuilder().startBooleanToggle((class_2561)propName, ((Boolean)value).booleanValue()).setDefaultValue(() -> (Boolean)this.tryGetDefault(prop)).setTooltip(new class_2561[]{propDescription}).setSaveConsumer(val -> this.trySetProp(prop, val));
                    } else if (value instanceof Integer) {
                        fieldBuilder = builder.entryBuilder().startIntField((class_2561)propName, ((Integer)value).intValue()).setDefaultValue(() -> (Integer)this.tryGetDefault(prop)).setTooltip(new class_2561[]{propDescription}).setSaveConsumer(val -> this.trySetProp(prop, val));
                    } else if (value instanceof Double) {
                        fieldBuilder = builder.entryBuilder().startDoubleField((class_2561)propName, ((Double)value).doubleValue()).setDefaultValue(() -> (Double)this.tryGetDefault(prop)).setTooltip(new class_2561[]{propDescription}).setSaveConsumer(val -> this.trySetProp(prop, val));
                    } else if (value instanceof Float) {
                        fieldBuilder = builder.entryBuilder().startFloatField((class_2561)propName, ((Float)value).floatValue()).setDefaultValue(() -> (Float)this.tryGetDefault(prop)).setTooltip(new class_2561[]{propDescription}).setSaveConsumer(val -> this.trySetProp(prop, val));
                    } else if (value instanceof String) {
                        fieldBuilder = builder.entryBuilder().startTextField((class_2561)propName, (String)value).setDefaultValue(() -> (String)this.tryGetDefault(prop)).setTooltip(new class_2561[]{propDescription}).setSaveConsumer(val -> this.trySetProp(prop, val));
                    } else if (value instanceof List) {
                        fieldBuilder = builder.entryBuilder().startStrList((class_2561)propName, (List)value).setDefaultValue(() -> (List)this.tryGetDefault(prop)).setTooltip(new class_2561[]{propDescription}).setSaveConsumer(val -> this.trySetProp(prop, val));
                    }
                    if (fieldBuilder == null) continue;
                    fieldBuilder.requireRestart(requireRestart);
                    subcategory.add(fieldBuilder.build());
                }
                if (subcategory == null) continue;
                category.addEntry((AbstractConfigListEntry)subcategory.build());
            }
            return builder.build();
        };
    }

    private Map<Field, Object> getFeatureConfigProperties(F feature) {
        LinkedHashMap<Field, Object> properties = new LinkedHashMap<Field, Object>();
        ArrayList<Field> classFields = new ArrayList<Field>(Arrays.asList(feature.getClass().getDeclaredFields()));
        classFields.forEach(prop -> {
            try {
                Configurable annotation = prop.getDeclaredAnnotation(Configurable.class);
                if (annotation == null) {
                    return;
                }
                Object value = prop.get(null);
                properties.put((Field)prop, value);
            }
            catch (Exception e) {
                this.log().error(this.getClass(), "Failed to read config property " + prop.getName() + " in " + feature.name(), new Object[0]);
            }
        });
        return properties;
    }

    private void trySetProp(Field prop, Object val) {
        try {
            prop.set(null, val);
        }
        catch (IllegalAccessException e) {
            this.log().error(this.getClass(), e.getMessage(), new Object[0]);
        }
    }

    private Object tryGetDefault(Field prop) {
        return CharmonyConfig.getDefaultFieldValues().getOrDefault(prop, null);
    }

    private SubCategoryBuilder startSubcategory(ConfigBuilder builder, String name, String description) {
        SubCategoryBuilder subcategory = builder.entryBuilder().startSubCategory((class_2561)class_2561.method_43470((String)name));
        subcategory.add((AbstractConfigListEntry)builder.entryBuilder().startTextDescription((class_2561)class_2561.method_43470((String)description)).build());
        return subcategory;
    }
}

