/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.feature.biome_ambience;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import svenhjol.charmonium.feature.biome_ambience.sounds.Badlands;
import svenhjol.charmonium.feature.biome_ambience.sounds.Beach;
import svenhjol.charmonium.feature.biome_ambience.sounds.Caves;
import svenhjol.charmonium.feature.biome_ambience.sounds.Desert;
import svenhjol.charmonium.feature.biome_ambience.sounds.Forest;
import svenhjol.charmonium.feature.biome_ambience.sounds.Icy;
import svenhjol.charmonium.feature.biome_ambience.sounds.Jungle;
import svenhjol.charmonium.feature.biome_ambience.sounds.Mountains;
import svenhjol.charmonium.feature.biome_ambience.sounds.Ocean;
import svenhjol.charmonium.feature.biome_ambience.sounds.Plains;
import svenhjol.charmonium.feature.biome_ambience.sounds.River;
import svenhjol.charmonium.feature.biome_ambience.sounds.Savanna;
import svenhjol.charmonium.feature.biome_ambience.sounds.Swamp;
import svenhjol.charmonium.feature.biome_ambience.sounds.Taiga;
import svenhjol.charmonium.feature.biome_ambience.sounds.TheEnd;
import svenhjol.charmonium.sound.BiomeSound;
import svenhjol.charmonium.sound.ISoundType;
import svenhjol.charmonium.sound.SoundHandler;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.client.ClientFeature;
import svenhjol.charmony_api.event.ClientEntityJoinEvent;
import svenhjol.charmony_api.event.ClientEntityLeaveEvent;
import svenhjol.charmony_api.event.ClientTickEvent;

public class BiomeAmbience
extends ClientFeature {
    public static List<class_2960> VALID_DIMENSIONS = new ArrayList<class_2960>();
    private static final ISoundType<BiomeSound> BADLANDS = new Badlands();
    private static final ISoundType<BiomeSound> BEACH = new Beach();
    private static final ISoundType<BiomeSound> CAVES = new Caves();
    private static final ISoundType<BiomeSound> DESERT = new Desert();
    private static final ISoundType<BiomeSound> FOREST = new Forest();
    private static final ISoundType<BiomeSound> ICY = new Icy();
    private static final ISoundType<BiomeSound> JUNGLE = new Jungle();
    private static final ISoundType<BiomeSound> MOUNTAINS = new Mountains();
    private static final ISoundType<BiomeSound> OCEAN = new Ocean();
    private static final ISoundType<BiomeSound> PLAINS = new Plains();
    private static final ISoundType<BiomeSound> RIVER = new River();
    private static final ISoundType<BiomeSound> SAVANNA = new Savanna();
    private static final ISoundType<BiomeSound> SWAMP = new Swamp();
    private static final ISoundType<BiomeSound> TAIGA = new Taiga();
    private static final ISoundType<BiomeSound> THE_END = new TheEnd();
    private Handler handler;
    @Configurable(name="Above ground for ambience silencing", description="Number of blocks above the ground that biome ambience will be silenced.\nSet to zero to disable.", requireRestart=false)
    public static int cullSoundAboveGround = 32;
    @Configurable(name="Biome sound blending", description="Number of blocks to check for neighbouring biomes.\nSet to zero to disable.", requireRestart=false)
    public static int biomeBlend = 32;
    @Configurable(name="Volume scaling", description="Affects the volume of all biome ambient sounds. 1.0 is full volume.", requireRestart=false)
    public static double volumeScaling = 0.55;
    @Configurable(name="Valid dimensions", description="Dimensions in which biome ambience will be played.")
    public static List<String> dimensions = Arrays.asList("minecraft:overworld", "minecraft:the_end");

    public String description() {
        return "Plays ambient background sound according to the biome and time of day.";
    }

    public void runWhenEnabled() {
        ClientEntityJoinEvent.INSTANCE.handle(this::handleClientEntityJoin);
        ClientEntityLeaveEvent.INSTANCE.handle(this::handleClientEntityLeave);
        ClientTickEvent.INSTANCE.handle(this::handleClientTick);
        dimensions.forEach(dim -> VALID_DIMENSIONS.add(new class_2960(dim)));
    }

    private void handleClientTick(class_310 client) {
        if (this.handler != null && !client.method_1493()) {
            this.handler.tick();
        }
    }

    private void handleClientEntityLeave(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746 && this.handler != null) {
            this.handler.stop();
        }
    }

    private void handleClientEntityJoin(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746) {
            class_746 player = (class_746)entity;
            this.trySetupSoundHandler((class_1657)player);
        }
    }

    private void trySetupSoundHandler(class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        this.handler = new Handler(player);
        this.handler.updatePlayer(player);
    }

    public static class Handler
    extends SoundHandler<BiomeSound> {
        public Handler(@NotNull class_1657 player) {
            super(player);
            BADLANDS.addSounds(this);
            BEACH.addSounds(this);
            CAVES.addSounds(this);
            DESERT.addSounds(this);
            FOREST.addSounds(this);
            ICY.addSounds(this);
            JUNGLE.addSounds(this);
            MOUNTAINS.addSounds(this);
            OCEAN.addSounds(this);
            PLAINS.addSounds(this);
            RIVER.addSounds(this);
            SAVANNA.addSounds(this);
            SWAMP.addSounds(this);
            TAIGA.addSounds(this);
            THE_END.addSounds(this);
        }
    }
}

