/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.variant_mob_textures;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1433;
import net.minecraft.class_1452;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1477;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3989;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import svenhjol.charm.feature.variant_mob_textures.VariantMobRenderer;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.event.ClientEntityJoinEvent;
import svenhjol.charmony.client.ClientFeature;
import svenhjol.charmony.iface.IClientRegistry;

public class VariantMobTextures
extends ClientFeature {
    static final String TEXTURES = "textures/entity";
    static final String TEXTURE_TAG = "charm_texture";
    static final Map<UUID, class_2960> CACHED_TEXTURE = new WeakHashMap<UUID, class_2960>();
    static final class_2960 DEFAULT_SHEEP = new class_2960("textures/entity/sheep/sheep.png");
    static final List<class_2960> CHICKENS = new ArrayList<class_2960>();
    static final List<class_2960> COWS = new ArrayList<class_2960>();
    static final List<class_2960> DOLPHINS = new ArrayList<class_2960>();
    static final List<class_2960> SNOW_GOLEMS = new ArrayList<class_2960>();
    static final List<class_2960> SQUIDS = new ArrayList<class_2960>();
    static final List<class_2960> PIGS = new ArrayList<class_2960>();
    static final List<class_2960> TURTLES = new ArrayList<class_2960>();
    static final List<class_2960> WOLVES = new ArrayList<class_2960>();
    static final Map<class_1767, class_2960> SHEEP = new HashMap<class_1767, class_2960>();
    static final List<class_2960> WANDERING_TRADERS = new ArrayList<class_2960>();
    static final List<class_2960> RARE_CHICKENS = new ArrayList<class_2960>();
    static final List<class_2960> RARE_COWS = new ArrayList<class_2960>();
    static final List<class_2960> RARE_DOLPHINS = new ArrayList<class_2960>();
    static final List<class_2960> RARE_SQUIDS = new ArrayList<class_2960>();
    static final List<class_2960> RARE_PIGS = new ArrayList<class_2960>();
    static final List<class_2960> RARE_TURTLES = new ArrayList<class_2960>();
    static final List<class_2960> RARE_WOLVES = new ArrayList<class_2960>();
    @Configurable(name="Cows", description="If true, cows may spawn with different textures.")
    public static boolean cows = true;
    @Configurable(name="Chickens", description="If true, chickens may spawn with different textures.")
    public static boolean chickens = true;
    @Configurable(name="Dolphins", description="If true, dolphins may spawn with different textures.")
    public static boolean dolphins = true;
    @Configurable(name="Pigs", description="If true, pigs may spawn with different textures.")
    public static boolean pigs = true;
    @Configurable(name="Sheep", description="If true, sheep face and 'shorn' textures match their wool color.")
    public static boolean sheep = true;
    @Configurable(name="Snow golems", description="If true, snow golems may spawn with different derp faces.")
    public static boolean snowGolems = true;
    @Configurable(name="Squids", description="If true, squids may spawn with different textures.")
    public static boolean squids = true;
    @Configurable(name="Turtles", description="If true, turtles may spawn with different textures.")
    public static boolean turtles = true;
    @Configurable(name="Wolves", description="If true, wolves may spawn with different textures.")
    public static boolean wolves = true;
    @Configurable(name="Wandering traders", description="If true, wandering traders may spawn with different textures.")
    public static boolean wanderingTraders = true;
    @Configurable(name="Chance of rare variants", description="Approximately 1 in X chance of a mob spawning as a rare variant.\nSet to zero to disable rare variants.")
    public static int rareVariantChance = 1000;

    public boolean canBeDisabled() {
        return true;
    }

    public String description() {
        return "Mobs may spawn with different textures.";
    }

    public void runWhenEnabled() {
        ClientEntityJoinEvent.INSTANCE.handle(this::handlePlayerJoin);
        IClientRegistry registry = this.mod().registry();
        if (chickens) {
            registry.entityRenderer(() -> class_1299.field_6132, () -> VariantMobRenderer.RenderChicken::new);
        }
        if (cows) {
            registry.entityRenderer(() -> class_1299.field_6085, () -> VariantMobRenderer.RenderCow::new);
        }
        if (dolphins) {
            registry.entityRenderer(() -> class_1299.field_6087, () -> VariantMobRenderer.RenderDolphin::new);
        }
        if (pigs) {
            registry.entityRenderer(() -> class_1299.field_6093, () -> VariantMobRenderer.RenderPig::new);
        }
        if (sheep) {
            registry.entityRenderer(() -> class_1299.field_6115, () -> VariantMobRenderer.RenderSheep::new);
        }
        if (snowGolems) {
            registry.entityRenderer(() -> class_1299.field_6047, () -> VariantMobRenderer.RenderSnowGolem::new);
        }
        if (squids) {
            registry.entityRenderer(() -> class_1299.field_6114, () -> VariantMobRenderer.RenderSquid::new);
        }
        if (turtles) {
            registry.entityRenderer(() -> class_1299.field_6113, () -> VariantMobRenderer.RenderTurtle::new);
        }
        if (wolves) {
            registry.entityRenderer(() -> class_1299.field_6055, () -> VariantMobRenderer.RenderWolf::new);
        }
        if (wanderingTraders) {
            registry.entityRenderer(() -> class_1299.field_17713, () -> VariantMobRenderer.RenderWanderingTrader::new);
        }
    }

    public void handlePlayerJoin(class_1297 entity, class_1937 level) {
        int i;
        if (!(entity instanceof class_746)) {
            return;
        }
        CHICKENS.clear();
        COWS.clear();
        DOLPHINS.clear();
        PIGS.clear();
        SNOW_GOLEMS.clear();
        SQUIDS.clear();
        TURTLES.clear();
        WOLVES.clear();
        WANDERING_TRADERS.clear();
        RARE_CHICKENS.clear();
        RARE_COWS.clear();
        RARE_DOLPHINS.clear();
        RARE_PIGS.clear();
        RARE_SQUIDS.clear();
        RARE_TURTLES.clear();
        RARE_WOLVES.clear();
        CHICKENS.add(new class_2960("textures/entity/chicken.png"));
        COWS.add(new class_2960("textures/entity/cow/cow.png"));
        DOLPHINS.add(new class_2960("textures/entity/dolphin.png"));
        PIGS.add(new class_2960("textures/entity/pig/pig.png"));
        SNOW_GOLEMS.add(new class_2960("textures/entity/snow_golem.png"));
        SQUIDS.add(new class_2960("textures/entity/squid/squid.png"));
        TURTLES.add(new class_2960("textures/entity/turtle/big_sea_turtle.png"));
        WANDERING_TRADERS.add(new class_2960("textures/entity/wandering_trader.png"));
        class_2960 wolf = new class_2960("textures/entity/wolf/wolf.png");
        WOLVES.add(wolf);
        for (i = 1; i <= 5; ++i) {
            this.addCustomTextures(CHICKENS, MobType.CHICKEN, "chicken" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addCustomTextures(RARE_CHICKENS, MobType.CHICKEN, "rare_chicken" + i);
        }
        for (i = 1; i <= 3; ++i) {
            this.addCustomTextures(DOLPHINS, MobType.DOLPHIN, "dolphin" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addCustomTextures(RARE_DOLPHINS, MobType.DOLPHIN, "rare_dolphin" + i);
        }
        for (i = 1; i <= 3; ++i) {
            this.addCustomTextures(TURTLES, MobType.TURTLE, "turtle" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(RARE_TURTLES, MobType.TURTLE, "rare_turtle" + i);
        }
        for (i = 1; i <= 7; ++i) {
            this.addCustomTextures(COWS, MobType.COW, "cow" + i);
        }
        for (i = 1; i <= 4; ++i) {
            this.addCustomTextures(WANDERING_TRADERS, MobType.WANDERING_TRADER, "wandering_trader" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(RARE_COWS, MobType.COW, "rare_cow" + i);
        }
        for (i = 1; i <= 4; ++i) {
            this.addCustomTextures(PIGS, MobType.PIG, "pig" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addCustomTextures(RARE_PIGS, MobType.PIG, "rare_pig" + i);
        }
        for (i = 1; i <= 5; ++i) {
            this.addCustomTextures(SNOW_GOLEMS, MobType.SNOW_GOLEM, "snow_golem" + i);
        }
        for (i = 1; i <= 4; ++i) {
            this.addCustomTextures(SQUIDS, MobType.SQUID, "squid" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(RARE_SQUIDS, MobType.SQUID, "rare_squid" + i);
        }
        for (i = 1; i <= 25; ++i) {
            this.addCustomTextures(WOLVES, MobType.WOLF, "nlg_wolf" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(RARE_WOLVES, MobType.WOLF, "rare_wolf" + i);
        }
        this.addCustomTextures(WOLVES, MobType.WOLF, "brownwolf", "greywolf", "blackwolf", "amotwolf", "jupiter1390");
        for (class_1767 color : class_1767.values()) {
            class_2960 res = this.createResource(MobType.SHEEP, "sheep_" + color.toString());
            SHEEP.put(color, res);
        }
    }

    public void addCustomTextures(List<class_2960> set, MobType type, String ... names) {
        ArrayList<String> textures = new ArrayList<String>(Arrays.asList(names));
        textures.forEach(texture -> {
            class_2960 res = this.createResource(type, (String)texture);
            set.add(res);
        });
    }

    @Nullable
    public static class_2960 getChickenTexture(class_1428 entity) {
        return VariantMobTextures.getTexture((class_1297)entity, CHICKENS, RARE_CHICKENS);
    }

    @Nullable
    public static class_2960 getCowTexture(class_1430 entity) {
        return VariantMobTextures.getTexture((class_1297)entity, COWS, RARE_COWS);
    }

    @Nullable
    public static class_2960 getDolphinTexture(class_1433 entity) {
        return VariantMobTextures.getTexture((class_1297)entity, DOLPHINS, RARE_DOLPHINS);
    }

    @Nullable
    public static class_2960 getPigTexture(class_1452 entity) {
        return VariantMobTextures.getTexture((class_1297)entity, PIGS, RARE_PIGS);
    }

    public static class_2960 getSheepTexture(class_1472 entity) {
        class_1767 fleeceColor = entity.method_6633();
        return SHEEP.getOrDefault(fleeceColor, DEFAULT_SHEEP);
    }

    @Nullable
    public static class_2960 getSnowGolemTexture(class_1473 entity) {
        return VariantMobTextures.getTexture((class_1297)entity, SNOW_GOLEMS, (List<class_2960>)ImmutableList.of());
    }

    @Nullable
    public static class_2960 getWanderingTraderTexture(class_3989 entity) {
        return VariantMobTextures.getTexture((class_1297)entity, WANDERING_TRADERS, (List<class_2960>)ImmutableList.of());
    }

    @Nullable
    public static class_2960 getSquidTexture(class_1477 entity) {
        return VariantMobTextures.getTexture((class_1297)entity, SQUIDS, RARE_SQUIDS);
    }

    @Nullable
    public static class_2960 getTurtleTexture(class_1481 entity) {
        return VariantMobTextures.getTexture((class_1297)entity, TURTLES, RARE_TURTLES);
    }

    @Nullable
    public static class_2960 getWolfTexture(class_1493 entity) {
        class_2960 res = VariantMobTextures.getTexture((class_1297)entity, WOLVES, RARE_WOLVES);
        if (res == null) {
            return null;
        }
        if (entity.method_6181()) {
            String path = res.method_12832().split("\\.")[0] + "_tame.png";
            res = new class_2960(res.method_12836(), path);
        } else if (entity.method_29511()) {
            String path = res.method_12832().split("\\.")[0] + "_angry.png";
            res = new class_2960(res.method_12836(), path);
        }
        return res;
    }

    @Nullable
    public static class_2960 getTexture(class_1297 entity, List<class_2960> normalSet, List<class_2960> rareSet) {
        List<class_2960> set;
        UUID id = entity.method_5667();
        if (CACHED_TEXTURE.containsKey(id)) {
            class_2960 val = CACHED_TEXTURE.get(id);
            if (val != null) {
                return val;
            }
        } else {
            String defined = "";
            Set tags = entity.method_5752();
            for (String tag : tags) {
                if (!tag.startsWith(TEXTURE_TAG)) continue;
                defined = tag.split("=")[1];
            }
            if (defined.isEmpty()) {
                CACHED_TEXTURE.put(id, null);
            } else {
                class_2960 res;
                if (defined.contains(":")) {
                    String[] s = defined.split(":");
                    res = new class_2960(s[0], "textures/entity/" + s[1]);
                } else {
                    res = new class_2960("charm", "textures/entity/" + defined);
                }
                CACHED_TEXTURE.put(id, res);
                return res;
            }
        }
        boolean isRare = rareVariantChance > 0 && !rareSet.isEmpty() && (id.getLeastSignificantBits() + id.getMostSignificantBits()) % (long)rareVariantChance == 0L;
        List<class_2960> list = set = isRare ? rareSet : normalSet;
        if (set.isEmpty()) {
            return null;
        }
        int choice = Math.abs((int)(id.getMostSignificantBits() % (long)set.size()));
        return set.get(choice);
    }

    private class_2960 createResource(MobType type, String texture) {
        return this.mod().id("textures/entity/" + type.method_15434() + "/" + texture + ".png");
    }

    public static enum MobType implements class_3542
    {
        CHICKEN,
        COW,
        DOLPHIN,
        PIG,
        SHEEP,
        SNOW_GOLEM,
        SQUID,
        TURTLE,
        WANDERING_TRADER,
        WOLF;


        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

