/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.spawner_drops;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1917;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import svenhjol.charm.CharmTags;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.event.BlockBreakEvent;
import svenhjol.charmony.common.CommonFeature;

public class SpawnerDrops
extends CommonFeature {
    static final int ITEMS_PER_STACK = 64;
    static final Table<class_6862<class_1299<?>>, class_1792, Integer> DROP_TYPES = HashBasedTable.create();
    @Configurable(name="Peaceful only", description="Spawners only drop items when the game difficulty is set to peaceful.")
    public static boolean onlyPeaceful = true;

    public String description() {
        return "Spawners drop mob-related items when broken.";
    }

    public void register() {
        SpawnerDrops.registerDropType(CharmTags.SPAWNER_DROPS_BLAZE_RODS, class_1802.field_8894, 32);
        SpawnerDrops.registerDropType(CharmTags.SPAWNER_DROPS_BONES, class_1802.field_8606, 64);
        SpawnerDrops.registerDropType(CharmTags.SPAWNER_DROPS_GUNPOWDER, class_1802.field_8054, 128);
        SpawnerDrops.registerDropType(CharmTags.SPAWNER_DROPS_MAGMA_CREAM, class_1802.field_8135, 64);
        SpawnerDrops.registerDropType(CharmTags.SPAWNER_DROPS_ROTTEN_FLESH, class_1802.field_8511, 64);
        SpawnerDrops.registerDropType(CharmTags.SPAWNER_DROPS_SLIME_BALLS, class_1802.field_8777, 128);
        SpawnerDrops.registerDropType(CharmTags.SPAWNER_DROPS_SPIDER_EYES, class_1802.field_8680, 64);
        SpawnerDrops.registerDropType(CharmTags.SPAWNER_DROPS_STRING, class_1802.field_8276, 64);
    }

    public void runWhenEnabled() {
        BlockBreakEvent.INSTANCE.handle(this::handleBlockBreak);
    }

    public static void registerDropType(class_6862<class_1299<?>> entity, class_1792 item, int amount) {
        DROP_TYPES.put(entity, (Object)item, (Object)amount);
    }

    private boolean handleBlockBreak(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1657 player) {
        class_2586 class_25862;
        if (level.field_9236) {
            return true;
        }
        if (onlyPeaceful && level.method_8407() != class_1267.field_5801) {
            return true;
        }
        if (state.method_26204() == class_2246.field_10260 && (class_25862 = level.method_8321(pos)) instanceof class_2636) {
            class_5819 random;
            class_2636 spawner = (class_2636)class_25862;
            class_1917 baseSpawner = spawner.method_11390();
            class_1297 entity = baseSpawner.method_8283(level, random = level.method_8409(), pos);
            if (entity == null) {
                return true;
            }
            class_1299 type = entity.method_5864();
            for (class_6862 dropType : DROP_TYPES.rowKeySet()) {
                if (!type.method_20210(dropType)) continue;
                DROP_TYPES.row((Object)dropType).forEach((item, amount) -> {
                    List<class_1799> stacks = this.getItemStacks((class_1792)item, (int)amount);
                    for (class_1799 stack : stacks) {
                        for (int i = 0; i < amount; ++i) {
                            class_1799 singleStack = new class_1799((class_1935)stack.method_7909());
                            class_243 vec3 = class_243.method_49273((class_2382)pos, (double)0.5, (double)0.5, (double)0.5).method_49272(level.field_9229, 0.7f);
                            class_1542 itemEntity = new class_1542(level, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), singleStack);
                            level.method_8649((class_1297)itemEntity);
                        }
                    }
                });
            }
        }
        return true;
    }

    private List<class_1799> getItemStacks(class_1792 item, int amount) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int numberOfStacks = 1;
        int remaining = amount;
        if (amount > 64) {
            numberOfStacks = amount / 64;
        }
        for (int i = 0; i < numberOfStacks; ++i) {
            class_1799 stack = new class_1799((class_1935)item);
            stack.method_7939(Math.min(remaining, 64));
            stacks.add(stack);
            remaining -= 64;
        }
        return stacks;
    }
}

