/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.shulker_box_drag_drop;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import svenhjol.charm.feature.inventory_tidying.InventoryTidyingHandler;
import svenhjol.charmony.api.event.ItemDragDropEvent;
import svenhjol.charmony.api.event.LevelLoadEvent;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.TagHelper;

public class ShulkerBoxDragDrop
extends CommonFeature {
    static final List<class_1935> BLACKLIST = new ArrayList<class_1935>();

    public String description() {
        return "Drag and drop items into a shulkerbox from within your inventory.";
    }

    public void runWhenEnabled() {
        ItemDragDropEvent.INSTANCE.handle(this::handleItemDragDrop);
        LevelLoadEvent.INSTANCE.handle(this::handleLevelLoad);
    }

    private void handleLevelLoad(MinecraftServer server, class_3218 level) {
        if (level.method_27983() == class_1937.field_25179) {
            for (class_2248 block : TagHelper.getValues((class_2378)class_7923.field_41175, (class_6862)class_3481.field_21490)) {
                if (BLACKLIST.contains(block)) continue;
                BLACKLIST.add((class_1935)block);
            }
        }
    }

    private class_1269 handleItemDragDrop(ItemDragDropEvent.StackType direction, class_1799 source, class_1799 dest, class_1735 slot, class_5536 clickAction, class_1657 player, class_5630 slotAccess) {
        if (clickAction != class_5536.field_27014 || !slot.method_32754(player)) {
            return class_1269.field_5811;
        }
        if (direction == ItemDragDropEvent.StackType.STACKED_ON_OTHER && source.method_7960()) {
            return class_1269.field_5811;
        }
        class_2248 class_22482 = class_2248.method_9503((class_1792)dest.method_7909());
        if (class_22482 instanceof class_2480) {
            class_2480 shulkerBoxBlock = (class_2480)class_22482;
            class_1792 item = source.method_7909();
            class_2248 block = class_2248.method_9503((class_1792)item);
            if (BLACKLIST.contains(item) || BLACKLIST.contains(block)) {
                return class_1269.field_5811;
            }
            class_2487 shulkerBoxTag = class_1747.method_38072((class_1799)dest);
            class_2586 blockEntity = shulkerBoxTag == null ? shulkerBoxBlock.method_10123(class_2338.field_10980, shulkerBoxBlock.method_9564()) : class_2586.method_11005((class_2338)class_2338.field_10980, (class_2680)shulkerBoxBlock.method_9564(), (class_2487)shulkerBoxTag);
            if (blockEntity instanceof class_2627) {
                class_2627 shulkerBox = (class_2627)blockEntity;
                int size = 27;
                class_1277 container = new class_1277(size);
                for (int i = 0; i < size; ++i) {
                    container.method_5447(i, shulkerBox.method_5438(i));
                }
                if (source.method_7960()) {
                    int index = 0;
                    for (int i = size - 1; i >= 0; --i) {
                        if (container.method_5438(i).method_7960()) continue;
                        index = i;
                    }
                    class_1799 stack = container.method_5438(index);
                    if (stack.method_7960()) {
                        return class_1269.field_5811;
                    }
                    class_1799 out = stack.method_7972();
                    container.method_5447(index, class_1799.field_8037);
                    InventoryTidyingHandler.mergeStacks((class_1263)container);
                    if (slot.method_32756(out).method_7960()) {
                        this.playRemoveOneSound((class_1297)player);
                    }
                } else {
                    class_1799 result = container.method_5491(source);
                    source.method_7939(result.method_7947());
                    if (result.method_7947() == 0) {
                        this.playInsertSound((class_1297)player);
                    }
                }
                for (int i = 0; i < size; ++i) {
                    class_1799 stackInSlot = container.method_5438(i);
                    shulkerBox.method_5447(i, stackInSlot);
                }
                shulkerBox.method_38240(dest);
                ShulkerBoxDragDrop.triggerDraggedItemToShulkerBox(player);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
        entity.method_5783(class_3417.field_14825, 0.1f + entity.method_37908().method_8409().method_43057() * 0.3f, 0.65f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
        entity.method_5783(class_3417.field_14825, 0.1f + entity.method_37908().method_8409().method_43057() * 0.3f, 0.67f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public static void triggerDraggedItemToShulkerBox(class_1657 player) {
        Advancements.trigger((class_2960)new class_2960("charm", "dragged_item_to_shulker_box"), (class_1657)player);
    }
}

