/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.hover_sorting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_5455;
import net.minecraft.class_5537;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import svenhjol.charm.feature.hover_sorting.HoverSortingNetwork;
import svenhjol.charm.feature.inventory_tidying.InventoryTidyingHandler;
import svenhjol.charmony.api.CharmonyApi;
import svenhjol.charmony.api.event.ItemHoverSortEvent;
import svenhjol.charmony.api.event.LevelLoadEvent;
import svenhjol.charmony.api.iface.IHoverSortableItemProvider;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.ApiHelper;
import svenhjol.charmony.helper.TagHelper;

public class HoverSorting
extends CommonFeature
implements IHoverSortableItemProvider {
    private final List<class_1935> cachedSortables = new ArrayList<class_1935>();
    private final List<class_6862<class_2248>> cachedBlockTags = new ArrayList<class_6862<class_2248>>();
    private final List<class_6862<class_1792>> cachedItemTags = new ArrayList<class_6862<class_1792>>();
    private final List<class_1935> sortables = new ArrayList<class_1935>();

    public String description() {
        return "Scroll the mouse while hovering over a bundle or shulker box to cycle the order of its contents.";
    }

    public void register() {
        ApiHelper.consume(IHoverSortableItemProvider.class, provider -> {
            this.cachedSortables.addAll(provider.getHoverSortableItems());
            this.cachedBlockTags.addAll(provider.getHoverSortableBlockTags());
            this.cachedItemTags.addAll(provider.getHoverSortableItemTags());
        });
        HoverSortingNetwork.register();
        CharmonyApi.registerProvider((Object)((Object)this));
    }

    public void runWhenEnabled() {
        LevelLoadEvent.INSTANCE.handle(this::handleLevelLoad);
        ItemHoverSortEvent.INSTANCE.handle(this::handleBundleSorting);
        ItemHoverSortEvent.INSTANCE.handle(this::handleShulkerBoxSorting);
    }

    public static void handleScrollOnHover(HoverSortingNetwork.ScrollOnHover message, class_1657 player) {
        class_1703 container = player.field_7512;
        int slotIndex = message.getSlotIndex();
        ItemHoverSortEvent.SortDirection direction = message.getSortDirection();
        if (slotIndex >= container.field_7761.size() || slotIndex < 0) {
            return;
        }
        class_1799 itemInSlot = container.method_7611(slotIndex).method_7677();
        ItemHoverSortEvent.INSTANCE.invoke((class_3222)player, itemInSlot, direction);
    }

    private void handleBundleSorting(class_3222 player, class_1799 stack, ItemHoverSortEvent.SortDirection direction) {
        if (stack.method_31574(class_1802.field_27023) && this.sortables.contains(class_1802.field_27023)) {
            String itemsTag = "Items";
            LinkedList contents = class_5537.method_32345((class_1799)stack).collect(Collectors.toCollection(LinkedList::new));
            if (contents.isEmpty()) {
                return;
            }
            ItemHoverSortEvent.sortByScrollDirection((List)contents, (ItemHoverSortEvent.SortDirection)direction);
            stack.method_7983(itemsTag);
            class_2487 tag = stack.method_7948();
            tag.method_10566(itemsTag, (class_2520)new class_2499());
            class_2499 list = tag.method_10554(itemsTag, 10);
            Collections.reverse(contents);
            contents.forEach(itemStack -> {
                class_2487 t = new class_2487();
                itemStack.method_7953(t);
                list.method_10531(0, (class_2520)t);
            });
            HoverSorting.triggerSortedItems((class_1657)player);
        }
    }

    private void handleShulkerBoxSorting(class_3222 player, class_1799 stack, ItemHoverSortEvent.SortDirection direction) {
        class_2487 tag;
        class_2586 blockEntity;
        class_2480 block;
        class_2248 class_22482 = class_2248.method_9503((class_1792)stack.method_7909());
        if (class_22482 instanceof class_2480 && this.sortables.contains(block = (class_2480)class_22482) && (blockEntity = (tag = class_1747.method_38072((class_1799)stack)) == null ? block.method_10123(class_2338.field_10980, block.method_9564()) : class_2586.method_11005((class_2338)class_2338.field_10980, (class_2680)block.method_9564(), (class_2487)tag)) instanceof class_2627) {
            class_2627 shulkerBox = (class_2627)blockEntity;
            class_2371 itemStacks = shulkerBox.field_12054;
            if (itemStacks.isEmpty()) {
                return;
            }
            ArrayList<class_1799> stacks = new ArrayList<class_1799>((Collection<class_1799>)itemStacks);
            InventoryTidyingHandler.mergeStacks(stacks);
            ItemHoverSortEvent.sortByScrollDirection(stacks, (ItemHoverSortEvent.SortDirection)direction);
            class_2371 list = class_2371.method_10211();
            list.addAll(stacks);
            shulkerBox.field_12054 = list;
            shulkerBox.method_38240(stack);
            HoverSorting.triggerSortedItems((class_1657)player);
        }
    }

    private void handleLevelLoad(MinecraftServer server, class_3218 level) {
        if (level.method_27983() == class_1937.field_25179) {
            class_5455 registryAccess = level.method_30349();
            ArrayList<class_1935> holder = new ArrayList<class_1935>();
            this.cachedBlockTags.forEach(blockTagKey -> holder.addAll(TagHelper.getValues((class_2378)registryAccess.method_30530(blockTagKey.comp_326()), (class_6862)blockTagKey)));
            this.cachedItemTags.forEach(itemTagKey -> holder.addAll(TagHelper.getValues((class_2378)registryAccess.method_30530(itemTagKey.comp_326()), (class_6862)itemTagKey)));
            holder.addAll(this.cachedSortables);
            this.sortables.clear();
            holder.forEach(item -> {
                if (!this.sortables.contains(item)) {
                    this.sortables.add((class_1935)item);
                }
            });
        }
    }

    public List<class_1935> getHoverSortableItems() {
        return List.of(class_1802.field_27023);
    }

    public List<class_6862<class_2248>> getHoverSortableBlockTags() {
        return List.of(class_3481.field_21490);
    }

    public static void triggerSortedItems(class_1657 player) {
        Advancements.trigger((class_2960)new class_2960("charm", "sorted_items"), (class_1657)player);
    }
}

