/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.extra_mob_drops;

import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1542;
import net.minecraft.class_1549;
import net.minecraft.class_1576;
import net.minecraft.class_1640;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3417;
import net.minecraft.class_5819;
import net.minecraft.class_6053;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.event.EntityKilledDropEvent;
import svenhjol.charmony.common.CommonFeature;

public class ExtraMobDrops
extends CommonFeature {
    private static final double LOOTING_BOOST = 0.1;
    @Configurable(name="Maximum sand drops", description="Maximum sand blocks dropped when a husk is killed.")
    public static int maxSandDrops = 2;
    @Configurable(name="Maximum mutton drops", description="Maximum pieces of mutton dropped when a goat is killed.")
    public static int maxMuttonDrops = 2;
    @Configurable(name="Maximum cobweb drops", description="Maximum cobwebs dropped when a cave spider is killed.")
    public static int maxCobwebDrops = 2;
    @Configurable(name="Luck drop chance", description="Chance (out of 1.0) of a witch dropping a Potion of Luck when killed.")
    public static double luckDropChance = 0.05;
    @Configurable(name="Feather drop chance", description="Chance (out of 1.0) of a chicken dropping a feather at the same time as an egg.")
    public static double featherDropChance = 0.33;

    public String description() {
        return "Some mobs have a chance to drop additional items.";
    }

    public void runWhenEnabled() {
        EntityKilledDropEvent.INSTANCE.handle(this::handleEntityDrop);
    }

    private class_1269 handleEntityDrop(class_1309 entity, class_1282 source, int lootingLevel) {
        if (!entity.method_37908().method_8608()) {
            class_1799 stack = null;
            if (entity instanceof class_1640) {
                class_1640 witch = (class_1640)entity;
                stack = new WitchDrops().getItemStack(witch, lootingLevel);
            } else if (entity instanceof class_1576) {
                class_1576 husk = (class_1576)entity;
                stack = new HuskDrops().getItemStack(husk, lootingLevel);
            } else if (entity instanceof class_6053) {
                class_6053 goat = (class_6053)entity;
                stack = new GoatDrops().getItemStack(goat, lootingLevel);
            } else if (entity instanceof class_1549) {
                class_1549 caveSpider = (class_1549)entity;
                stack = new CaveSpiderDrops().getItemStack(caveSpider, lootingLevel);
            }
            if (stack != null && !stack.method_7960() && stack.method_7947() > 0) {
                class_1937 level = entity.method_37908();
                class_2338 pos = entity.method_24515();
                level.method_8649((class_1297)new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack));
            }
        }
        return class_1269.field_5811;
    }

    public static void tryDropFeather(class_1428 chicken) {
        if (chicken.method_5805() && !chicken.method_6109() && !chicken.method_37908().field_9236 && !chicken.method_6472() && (double)chicken.method_37908().field_9229.method_43057() < featherDropChance) {
            chicken.method_5783(class_3417.field_15219, 1.0f, (chicken.method_37908().field_9229.method_43057() - chicken.method_37908().field_9229.method_43057()) * 0.2f + 1.0f);
            chicken.method_5706((class_1935)class_1802.field_8153);
            chicken.field_6739 = chicken.method_37908().field_9229.method_43048(3000) + 3000;
        }
    }

    static class WitchDrops
    extends TryGetDrops<class_1640> {
        WitchDrops() {
        }

        @Override
        class_1799 getItemStack(class_1640 entity, int lootingLevel) {
            if (entity.method_6051().method_43058() < luckDropChance + (double)lootingLevel * 0.1) {
                class_1799 potion = new class_1799((class_1935)class_1802.field_8574);
                class_1844.method_8061((class_1799)potion, (class_1842)class_1847.field_8995);
                return potion;
            }
            return class_1799.field_8037;
        }
    }

    static class HuskDrops
    extends TryGetDrops<class_1576> {
        HuskDrops() {
        }

        @Override
        class_1799 getItemStack(class_1576 entity, int lootingLevel) {
            int amount = this.getAmountWithLooting(entity.method_6051(), maxSandDrops, lootingLevel);
            return amount == 0 ? class_1799.field_8037 : new class_1799((class_1935)class_1802.field_8858, amount);
        }
    }

    static class GoatDrops
    extends TryGetDrops<class_6053> {
        GoatDrops() {
        }

        @Override
        class_1799 getItemStack(class_6053 entity, int lootingLevel) {
            int amount = this.getAmountWithLooting(entity.method_6051(), maxMuttonDrops, lootingLevel);
            class_1792 item = entity.method_5809() ? class_1802.field_8347 : class_1802.field_8748;
            return amount == 0 ? class_1799.field_8037 : new class_1799((class_1935)item, amount);
        }
    }

    static class CaveSpiderDrops
    extends TryGetDrops<class_1549> {
        CaveSpiderDrops() {
        }

        @Override
        class_1799 getItemStack(class_1549 entity, int lootingLevel) {
            int amount = this.getAmountWithLooting(entity.method_6051(), maxCobwebDrops, lootingLevel);
            return amount == 0 ? class_1799.field_8037 : new class_1799((class_1935)class_1802.field_8786, amount);
        }
    }

    private static abstract class TryGetDrops<T extends class_1309> {
        private TryGetDrops() {
        }

        abstract class_1799 getItemStack(T var1, int var2);

        int getAmountWithLooting(class_5819 random, int max, int lootingLevel) {
            int amount = random.method_43048(Math.max(1, max + 1));
            if (random.method_43058() < (double)lootingLevel * 0.1) {
                ++amount;
            }
            return amount;
        }
    }
}

