/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.coral_sea_lanterns;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1935;
import svenhjol.charm.feature.coral_sea_lanterns.CoralMaterial;
import svenhjol.charm.feature.coral_sea_lanterns.CoralSeaLanternBlock;
import svenhjol.charmony.api.CharmonyApi;
import svenhjol.charmony.api.iface.IWandererTrade;
import svenhjol.charmony.api.iface.IWandererTradeProvider;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.iface.ICommonRegistry;

public class CoralSeaLanterns
extends CommonFeature
implements IWandererTradeProvider {
    public static final Map<CoralMaterial, Supplier<CoralSeaLanternBlock>> BLOCKS = new LinkedHashMap<CoralMaterial, Supplier<CoralSeaLanternBlock>>();
    public static final Map<CoralMaterial, Supplier<CoralSeaLanternBlock.BlockItem>> BLOCK_ITEMS = new LinkedHashMap<CoralMaterial, Supplier<CoralSeaLanternBlock.BlockItem>>();

    public String description() {
        return "Coral can be combined with sea lanterns to make colored variants.";
    }

    public void register() {
        ICommonRegistry registry = this.mod().registry();
        for (CoralMaterial material : CoralMaterial.values()) {
            String id = material.method_15434() + "_sea_lantern";
            Supplier block = registry.block(id, () -> new CoralSeaLanternBlock(material));
            Supplier blockItem = registry.item(id, () -> CoralSeaLanterns.lambda$register$1((Supplier)block));
            BLOCKS.put(material, block);
            BLOCK_ITEMS.put(material, blockItem);
        }
        CharmonyApi.registerProvider((Object)((Object)this));
    }

    public List<IWandererTrade> getWandererTrades() {
        ArrayList<IWandererTrade> out = new ArrayList<IWandererTrade>();
        for (final Supplier<CoralSeaLanternBlock> block : BLOCKS.values()) {
            out.add(new IWandererTrade(){

                public class_1935 getItem() {
                    return (class_1935)block.get();
                }

                public int getCount() {
                    return 1;
                }

                public int getCost() {
                    return 10;
                }
            });
        }
        return out;
    }

    private static /* synthetic */ CoralSeaLanternBlock.BlockItem lambda$register$1(Supplier block) {
        return new CoralSeaLanternBlock.BlockItem(block);
    }
}

