/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.atlases;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1762;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import svenhjol.charm.feature.atlases.Atlases;
import svenhjol.charm.feature.atlases.AtlasesClient;
import svenhjol.charm.feature.atlases.MoveMode;
import svenhjol.charmony.annotation.Packet;
import svenhjol.charmony.base.Mods;
import svenhjol.charmony.enums.PacketDirection;
import svenhjol.charmony.iface.IClientNetwork;
import svenhjol.charmony.iface.ICommonRegistry;
import svenhjol.charmony.iface.IPacketRequest;
import svenhjol.charmony.iface.IServerNetwork;

public class AtlasesNetwork {
    public static void register() {
        ICommonRegistry registry = Mods.common((String)"charm").registry();
        registry.packet((IPacketRequest)new TransferAtlas(), () -> Atlases::handleTransferAtlas);
        registry.packet((IPacketRequest)new SwapAtlasSlot(), () -> Atlases::handleSwappedSlot);
        registry.packet((IPacketRequest)new SwappedAtlasSlot(), () -> AtlasesClient::handleSwappedSlot);
        registry.packet((IPacketRequest)new UpdateInventory(), () -> AtlasesClient::handleUpdateInventory);
    }

    public static IClientNetwork getClientNetwork() {
        return Mods.client((String)"charm").network();
    }

    public static IServerNetwork getServerNetwork() {
        return Mods.common((String)"charm").network();
    }

    public static void sendMapToClient(class_3222 player, class_1799 map, boolean markDirty) {
        if (map.method_7909().method_16698()) {
            if (markDirty) {
                Integer mapId = class_1806.method_8003((class_1799)map);
                class_22 mapData = class_1806.method_7997((Integer)mapId, (class_1937)player.method_37908());
                if (mapData == null) {
                    return;
                }
                mapData.method_103(0, 0);
            }
            map.method_7909().method_7888(map, player.method_37908(), (class_1297)player, -1, true);
            class_2596 packet = ((class_1762)map.method_7909()).method_7757(map, player.method_37908(), (class_1657)player);
            if (packet != null) {
                player.field_13987.method_14364(packet);
            }
        }
    }

    @Packet(id="charm:transfer_atlas", direction=PacketDirection.CLIENT_TO_SERVER)
    public static class TransferAtlas
    implements IPacketRequest {
        private int atlasSlot;
        private int mapX;
        private int mapZ;
        private MoveMode moveMode;

        private TransferAtlas() {
        }

        public int getAtlasSlot() {
            return this.atlasSlot;
        }

        public int getMapX() {
            return this.mapX;
        }

        public int getMapZ() {
            return this.mapZ;
        }

        public MoveMode getMoveMode() {
            return this.moveMode;
        }

        public static void send(int atlasSlot, int mapX, int mapZ, MoveMode moveMode) {
            TransferAtlas message = new TransferAtlas();
            message.atlasSlot = atlasSlot;
            message.mapX = mapX;
            message.mapZ = mapZ;
            message.moveMode = moveMode;
            AtlasesNetwork.getClientNetwork().send((IPacketRequest)message);
        }

        public void encode(class_2540 buf) {
            buf.writeInt(this.atlasSlot);
            buf.writeInt(this.mapX);
            buf.writeInt(this.mapZ);
            buf.method_10817((Enum)this.moveMode);
        }

        public void decode(class_2540 buf) {
            this.atlasSlot = buf.readInt();
            this.mapX = buf.readInt();
            this.mapZ = buf.readInt();
            this.moveMode = (MoveMode)buf.method_10818(MoveMode.class);
        }
    }

    @Packet(id="charm:swap_atlas_slot", direction=PacketDirection.CLIENT_TO_SERVER)
    public static class SwapAtlasSlot
    implements IPacketRequest {
        private int slot;

        private SwapAtlasSlot() {
        }

        public static void send(int slot) {
            SwapAtlasSlot message = new SwapAtlasSlot();
            message.slot = slot;
            AtlasesNetwork.getClientNetwork().send((IPacketRequest)message);
        }

        public int getSlot() {
            return this.slot;
        }

        public void encode(class_2540 buf) {
            buf.writeInt(this.slot);
        }

        public void decode(class_2540 buf) {
            this.slot = buf.readInt();
        }
    }

    @Packet(id="charm:swapped_atlas_slot", direction=PacketDirection.SERVER_TO_CLIENT)
    public static class SwappedAtlasSlot
    implements IPacketRequest {
        private int slot;

        private SwappedAtlasSlot() {
        }

        public static void send(class_1657 player, int slot) {
            SwappedAtlasSlot message = new SwappedAtlasSlot();
            message.slot = slot;
            AtlasesNetwork.getServerNetwork().send((IPacketRequest)message, player);
        }

        public int getSlot() {
            return this.slot;
        }

        public void encode(class_2540 buf) {
            buf.writeInt(this.slot);
        }

        public void decode(class_2540 buf) {
            this.slot = buf.readInt();
        }
    }

    @Packet(id="charm:update_atlas_inventory", direction=PacketDirection.SERVER_TO_CLIENT, description="The slot that contains the active atlas is transferred to the client.")
    public static class UpdateInventory
    implements IPacketRequest {
        private int slot = Integer.MIN_VALUE;

        private UpdateInventory() {
        }

        public static void send(class_1657 player, int slot) {
            UpdateInventory message = new UpdateInventory();
            message.slot = slot;
            AtlasesNetwork.getServerNetwork().send((IPacketRequest)message, player);
        }

        public void encode(class_2540 buf) {
            if (this.slot >= 0) {
                buf.writeInt(this.slot);
            }
        }

        public void decode(class_2540 buf) {
            this.slot = buf.readInt();
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

