/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class Path {
    public static final double NEAR_ZERO = 0.01;
    public static final Vec3 CUBE_EXTENT = new Vec3(0.5, 0.5, 0.5);

    public static List<BlockPos> calculateBresenhamVoxels(BlockPos startPos, BlockPos endPos) {
        ArrayList<BlockPos> points = new ArrayList<BlockPos>();
        points.add(startPos);
        BlockPos delta = endPos.m_121996_((Vec3i)startPos);
        int dx = Math.abs(delta.m_123341_());
        int dy = Math.abs(delta.m_123342_());
        int dz = Math.abs(delta.m_123343_());
        int xStep = delta.m_123341_() > 0 ? 1 : -1;
        int yStep = delta.m_123342_() > 0 ? 1 : -1;
        int zStep = delta.m_123343_() > 0 ? 1 : -1;
        Vec3 workingVec = new Vec3((double)startPos.m_123341_(), (double)startPos.m_123342_(), (double)startPos.m_123343_());
        Vec3 targetVec = new Vec3((double)endPos.m_123341_(), (double)endPos.m_123342_(), (double)endPos.m_123343_());
        if (dx >= dy && dx >= dz) {
            int point1 = 2 * dy - dx;
            int point2 = 2 * dz - dx;
            while (Math.abs(workingVec.m_7096_() - targetVec.m_7096_()) > 0.01) {
                workingVec = workingVec.m_82520_((double)xStep, 0.0, 0.0);
                if (point1 >= 0) {
                    workingVec = workingVec.m_82520_(0.0, (double)yStep, 0.0);
                    point1 -= 2 * dx;
                }
                if (point2 >= 0) {
                    workingVec = workingVec.m_82520_(0.0, 0.0, (double)zStep);
                    point2 -= 2 * dx;
                }
                point1 += 2 * dy;
                point2 += 2 * dz;
                BlockPos newPoint = BlockPos.m_274446_((Position)workingVec);
                List<BlockPos> lostPoints = Path.calculateMissedPoints(points, newPoint, startPos, endPos);
                points.addAll(lostPoints);
                points.add(newPoint);
            }
            return points;
        }
        if (dy >= dx && dy >= dz) {
            int point1 = 2 * dx - dy;
            int point2 = 2 * dz - dy;
            while (Math.abs(workingVec.m_7098_() - targetVec.m_7098_()) > 0.01) {
                workingVec = workingVec.m_82520_(0.0, (double)yStep, 0.0);
                if (point1 >= 0) {
                    workingVec = workingVec.m_82520_((double)xStep, 0.0, 0.0);
                    point1 -= 2 * dy;
                }
                if (point2 >= 0) {
                    workingVec = workingVec.m_82520_(0.0, 0.0, (double)zStep);
                    point2 -= 2 * dy;
                }
                point1 += 2 * dx;
                point2 += 2 * dz;
                BlockPos newPoint = BlockPos.m_274446_((Position)workingVec);
                List<BlockPos> lostPoints = Path.calculateMissedPoints(points, newPoint, startPos, endPos);
                points.addAll(lostPoints);
                points.add(newPoint);
            }
            return points;
        }
        int point1 = 2 * dy - dz;
        int point2 = 2 * dx - dz;
        while (Math.abs(workingVec.m_7094_() - targetVec.m_7094_()) > 0.01) {
            workingVec = workingVec.m_82520_(0.0, 0.0, (double)zStep);
            if (point1 >= 0) {
                workingVec = workingVec.m_82520_(0.0, (double)yStep, 0.0);
                point1 -= 2 * dz;
            }
            if (point2 >= 0) {
                workingVec = workingVec.m_82520_((double)xStep, 0.0, 0.0);
                point2 -= 2 * dz;
            }
            point1 += 2 * dy;
            point2 += 2 * dx;
            BlockPos newPoint = BlockPos.m_274446_((Position)workingVec);
            List<BlockPos> lostPoints = Path.calculateMissedPoints(points, newPoint, startPos, endPos);
            points.addAll(lostPoints);
            points.add(newPoint);
        }
        return points;
    }

    private static List<BlockPos> calculateMissedPoints(List<BlockPos> points, BlockPos newPoint, BlockPos lineStart, BlockPos lineEnd) {
        BlockPos checkPos;
        BlockPos[] checkDirections;
        if (points.size() == 0) {
            return List.of();
        }
        BlockPos lastPoint = points.get(points.size() - 1);
        BlockPos pointDelta = newPoint.m_121996_((Vec3i)lastPoint);
        int diff = newPoint.m_123333_((Vec3i)lastPoint);
        if (diff < 0 || diff > 3) {
            throw new IllegalArgumentException("The last point and the new point share no common boundaries");
        }
        if (diff == 1 || diff == 0) {
            return List.of();
        }
        LinkedList<BlockPos> reviewPositions = new LinkedList<BlockPos>();
        if (diff == 2) {
            for (BlockPos direction : checkDirections = new BlockPos[]{new BlockPos(pointDelta.m_123341_(), 0, 0), new BlockPos(0, pointDelta.m_123342_(), 0), new BlockPos(0, 0, pointDelta.m_123343_())}) {
                if (direction.equals((Object)BlockPos.f_121853_)) continue;
                checkPos = lastPoint.m_121955_((Vec3i)direction);
                reviewPositions.add(checkPos);
            }
        }
        if (diff == 3) {
            for (BlockPos direction : checkDirections = new BlockPos[]{new BlockPos(pointDelta.m_123341_(), 0, 0), new BlockPos(0, pointDelta.m_123342_(), 0), new BlockPos(0, 0, pointDelta.m_123343_()), new BlockPos(pointDelta.m_123341_(), pointDelta.m_123342_(), 0), new BlockPos(pointDelta.m_123341_(), 0, pointDelta.m_123343_()), new BlockPos(0, pointDelta.m_123342_(), pointDelta.m_123343_())}) {
                if (direction.equals((Object)BlockPos.f_121853_)) continue;
                checkPos = lastPoint.m_121955_((Vec3i)direction);
                reviewPositions.add(checkPos);
            }
        }
        return reviewPositions.stream().filter(pos -> {
            Vec3 boxSpaceTransform = Vec3.m_82528_((Vec3i)pos);
            Vec3 lineStartD = Vec3.m_82528_((Vec3i)lineStart).m_82546_(boxSpaceTransform);
            Vec3 lineEndD = Vec3.m_82528_((Vec3i)lineEnd).m_82546_(boxSpaceTransform);
            Vec3 lineMid = lineStartD.m_82549_(lineEndD).m_82490_(0.5);
            Vec3 line = lineStartD.m_82546_(lineMid);
            Vec3 lineExt = new Vec3(Math.abs(line.f_82479_), Math.abs(line.f_82480_), Math.abs(line.f_82481_));
            if (Math.abs(lineMid.f_82479_) > Path.CUBE_EXTENT.f_82479_ + lineExt.f_82479_) {
                return false;
            }
            if (Math.abs(lineMid.f_82480_) > Path.CUBE_EXTENT.f_82480_ + lineExt.f_82480_) {
                return false;
            }
            if (Math.abs(lineMid.f_82481_) > Path.CUBE_EXTENT.f_82481_ + lineExt.f_82481_) {
                return false;
            }
            if (Math.abs(lineMid.f_82480_ * line.f_82481_ - lineMid.f_82481_ * line.f_82480_) > Path.CUBE_EXTENT.f_82480_ * lineExt.f_82481_ + Path.CUBE_EXTENT.f_82481_ * lineExt.f_82480_) {
                return false;
            }
            if (Math.abs(lineMid.f_82479_ * line.f_82481_ - lineMid.f_82481_ * line.f_82479_) > Path.CUBE_EXTENT.f_82479_ * lineExt.f_82481_ + Path.CUBE_EXTENT.f_82481_ * lineExt.f_82479_) {
                return false;
            }
            return !(Math.abs(lineMid.f_82479_ * line.f_82480_ - lineMid.f_82480_ * line.f_82479_) > Path.CUBE_EXTENT.f_82479_ * lineExt.f_82480_ + Path.CUBE_EXTENT.f_82480_ * lineExt.f_82479_);
        }).toList();
    }
}

