/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.mixin;

import me.cg360.mod.bridging.BridgingKeyMappings;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.raytrace.BridgingStateTracker;
import me.cg360.mod.bridging.util.InfoStrings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Unique
    private double bridgingmod$lastKnownYFrac = 0.0;
    @Shadow
    @Nullable
    public MultiPlayerGameMode f_91072_;
    @Shadow
    @Nullable
    public LocalPlayer f_91074_;
    @Shadow
    @Nullable
    public HitResult f_91077_;
    @Shadow
    private int f_91011_;
    @Shadow
    @Nullable
    public ClientLevel f_91073_;

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void onTick(CallbackInfo ci) {
        if (this.f_91074_ != null && this.f_91074_.m_20096_()) {
            this.bridgingmod$lastKnownYFrac = Mth.m_14185_((double)this.f_91074_.m_20186_());
        }
        if (BridgingKeyMappings.TOGGLE_BRIDGING.m_90859_()) {
            BridgingMod.getConfig().toggleBridgingEnabled();
            Component stateMsg = BridgingMod.getConfig().isBridgingEnabled() ? InfoStrings.ON : InfoStrings.OFF;
            MutableComponent text = InfoStrings.TOGGLE_BRIDGING.m_6881_().m_7220_(stateMsg);
            Minecraft.m_91087_().f_91065_.m_93063_((Component)text, false);
        }
        BridgingStateTracker.tick(this.f_91074_);
    }

    @Inject(at={@At(value="HEAD")}, method={"startUseItem()V"}, cancellable=true)
    public void onItemUse(CallbackInfo info) {
        boolean passesCrouchTest;
        if (!BridgingMod.getConfig().isBridgingEnabled()) {
            return;
        }
        if (this.f_91074_ == null) {
            return;
        }
        if (this.f_91072_ == null) {
            return;
        }
        if (this.f_91074_.m_108637_() || this.f_91072_.m_105296_()) {
            return;
        }
        if (this.f_91077_ != null && this.f_91077_.m_6662_() != HitResult.Type.MISS) {
            return;
        }
        boolean bl = passesCrouchTest = !BridgingMod.getConfig().shouldOnlyBridgeWhenCrouched() || this.f_91074_.m_6047_();
        if (!passesCrouchTest) {
            return;
        }
        Tuple<BlockPos, Direction> pair = BridgingStateTracker.getLastTickTarget();
        if (pair == null) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            boolean stackSizeChanged;
            Direction dir;
            ItemStack itemStack = this.f_91074_.m_21120_(hand);
            BlockPos pos = (BlockPos)pair.m_14418_();
            if (!this.f_91074_.m_36204_(pos, dir = ((Direction)pair.m_14419_()).m_122424_(), itemStack)) continue;
            BlockHitResult blockHitResult = this.bridgingmod$getFinalPlaceAssistTarget(itemStack, dir, pos);
            int originalStackSize = itemStack.m_41613_();
            InteractionResult blockPlaceResult = this.f_91072_.m_233732_(this.f_91074_, hand, blockHitResult);
            if (!blockPlaceResult.m_19077_()) continue;
            this.f_91011_ = Math.max(0, BridgingMod.getConfig().getDelayPostBridging());
            info.cancel();
            if (!blockPlaceResult.m_19080_()) {
                return;
            }
            this.f_91074_.m_6674_(hand);
            boolean bl2 = stackSizeChanged = itemStack.m_41613_() != originalStackSize || this.f_91072_.m_105290_();
            if (stackSizeChanged && !itemStack.m_41619_()) {
                Minecraft.m_91087_().f_91063_.f_109055_.m_109320_(hand);
            }
            return;
        }
    }

    @Unique
    @NotNull
    private BlockHitResult bridgingmod$getFinalPlaceAssistTarget(ItemStack heldItem, Direction dir, BlockPos pos) {
        if (BridgingMod.getConfig().isSlabAssistEnabled()) {
            BlockHitResult override;
            switch (dir.m_122434_()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case X: 
                case Z: {
                    BlockHitResult blockHitResult = this.bridgingmod$handleHorizontalSlabAssist(dir, pos);
                    break;
                }
                case Y: {
                    BlockHitResult blockHitResult = override = this.bridgingmod$handleVerticalSlabAssist(heldItem, dir, pos);
                }
            }
            if (override != null) {
                return override;
            }
        }
        Vec3 placerOrigin = Vec3.m_82512_((Vec3i)pos);
        return new BlockHitResult(placerOrigin, dir, pos, true);
    }

    @Unique
    private BlockHitResult bridgingmod$handleHorizontalSlabAssist(Direction dir, BlockPos pos) {
        boolean shouldTargetLowerHalf = this.bridgingmod$lastKnownYFrac > 0.1775 && this.bridgingmod$lastKnownYFrac < 0.51;
        Vec3 placerOrigin = shouldTargetLowerHalf ? Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, 0.1, 0.0) : Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, 0.9, 0.0);
        Direction placeDir = shouldTargetLowerHalf ? Direction.UP : Direction.DOWN;
        return new BlockHitResult(placerOrigin, placeDir, pos, false);
    }

    @Unique
    private BlockHitResult bridgingmod$handleVerticalSlabAssist(ItemStack heldItem, Direction dir, BlockPos pos) {
        if (this.f_91073_ == null) {
            return null;
        }
        Item item = heldItem.m_41720_();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!(blockItem.m_40614_() instanceof SlabBlock)) {
            return null;
        }
        BlockPos buildingOffPos = pos.m_121955_(dir.m_122436_().m_142393_(-1));
        BlockState localState = this.f_91073_.m_8055_(buildingOffPos);
        if (!(localState.m_60734_() instanceof SlabBlock)) {
            return null;
        }
        SlabType slabType = (SlabType)localState.m_61143_((Property)SlabBlock.f_56353_);
        if (slabType == SlabType.DOUBLE) {
            return null;
        }
        if (slabType == SlabType.TOP && dir != Direction.DOWN) {
            return null;
        }
        if (slabType == SlabType.BOTTOM && dir != Direction.UP) {
            return null;
        }
        Vec3 placerOrigin = Vec3.m_82512_((Vec3i)pos);
        return new BlockHitResult(placerOrigin, dir, buildingOffPos, false);
    }
}

