/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.config;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.config.BridgingConfig;
import me.cg360.mod.bridging.config.helper.Category;
import me.cg360.mod.bridging.config.helper.DiscreteRange;
import me.cg360.mod.bridging.config.helper.HideInConfigUI;
import me.cg360.mod.bridging.config.helper.IncludeAnimatedImage;
import me.cg360.mod.bridging.config.helper.IncludeExtraDescription;
import me.cg360.mod.bridging.config.helper.IncludeImage;
import me.cg360.mod.bridging.config.helper.Translatable;
import me.cg360.mod.bridging.util.ReflectSupport;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class BridgingConfigUI {
    public static String DEFAULT_CATEGORY_NAME = "other".trim().toLowerCase();

    public static YetAnotherConfigLib buildConfig() {
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder();
        Map<String, List<Field>> sortedCategories = BridgingConfigUI.sortConfigIntoCategories(BridgingConfig.class);
        for (String categoryName : sortedCategories.keySet()) {
            List<Field> categoryOptions = sortedCategories.get(categoryName);
            ConfigCategory category = BridgingConfigUI.createCategory(categoryName, categoryOptions);
            builder.category(category);
        }
        return builder.title((Component)Component.m_237115_((String)"config.bridgingmod.title")).save(() -> BridgingConfig.HANDLER.save()).screenInit(screen -> ((BridgingConfig)BridgingConfig.HANDLER.instance()).upgrade()).build();
    }

    private static <T> Optional<Option<T>> createOption(Field field, Function<Option<T>, ControllerBuilder<T>> controllerBuilder) {
        String id = field.getName();
        String nameTranslation = "config.bridgingmod.option.%s".formatted(id);
        BridgingConfig instance = (BridgingConfig)BridgingConfig.HANDLER.instance();
        Object defaultValue = instance.getDefaultForField(field).orElse(null);
        if (defaultValue == null) {
            BridgingMod.getLogger().error("Config field '%s' has no default value. Skipping.");
            return Optional.empty();
        }
        Object castedDefault = defaultValue;
        Option.Builder option = Option.createBuilder().name((Component)Component.m_237115_((String)nameTranslation)).binding(castedDefault, () -> {
            try {
                field.setAccessible(true);
                Object val = field.get(instance);
                return val == null ? castedDefault : val;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, val -> {
            try {
                field.setAccessible(true);
                field.set(instance, val);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).controller(controllerBuilder);
        IncludeExtraDescription[] descriptionNotation = (IncludeExtraDescription[])field.getDeclaredAnnotationsByType(IncludeExtraDescription.class);
        IncludeImage[] imageNotation = (IncludeImage[])field.getDeclaredAnnotationsByType(IncludeImage.class);
        IncludeAnimatedImage[] animatedImageNotation = (IncludeAnimatedImage[])field.getDeclaredAnnotationsByType(IncludeAnimatedImage.class);
        OptionDescription.Builder desc = OptionDescription.createBuilder();
        String descTranslationKey = "config.bridgingmod.option.%s.description.%s".formatted(id, 0);
        MutableComponent descTranslation = Component.m_264568_((String)descTranslationKey, (String)"");
        desc.text(new Component[]{descTranslation});
        if (descriptionNotation.length > 0) {
            int extraParagraphs = Math.max(descriptionNotation[0].extraParagraphs(), 1);
            for (int i = 1; i < extraParagraphs + 1; ++i) {
                String extraDescriptionTranslationKey = "config.bridgingmod.option.%s.description.%s".formatted(id, i);
                MutableComponent extraDescTranslation = Component.m_237115_((String)extraDescriptionTranslationKey);
                desc.text(new Component[]{extraDescTranslation});
            }
        }
        if (imageNotation.length > 0) {
            IncludeImage imageAnnotation = imageNotation[0];
            ResourceLocation checkedPath = BridgingMod.id(imageAnnotation.value());
            int width = imageAnnotation.width();
            int height = imageAnnotation.height();
            desc.image(checkedPath, width, height);
        }
        if (animatedImageNotation.length > 0) {
            IncludeAnimatedImage imageAnnotation = animatedImageNotation[0];
            ResourceLocation checkedPath = BridgingMod.id(imageAnnotation.value());
            desc.webpImage(checkedPath);
        }
        return Optional.of(option.description(desc.build()).build());
    }

    private static ConfigCategory createCategory(String categoryName, List<Field> categoryOptions) {
        ConfigCategory.Builder category = ConfigCategory.createBuilder();
        String translatedName = "config.bridgingmod.category.%s".formatted(categoryName);
        String translatedTooltip = "config.bridgingmod.category.%s.tooltip".formatted(categoryName);
        category.name((Component)Component.m_237115_((String)translatedName));
        category.tooltip(new Component[]{Component.m_264568_((String)translatedTooltip, (String)"")});
        for (Field field : categoryOptions) {
            Optional<Option<Option>> optOption;
            Class<?> type = ReflectSupport.boxPrimitive(field.getType());
            if (Boolean.class.isAssignableFrom(type)) {
                optOption = BridgingConfigUI.createOption(field, TickBoxControllerBuilder::create);
                optOption.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                continue;
            }
            if (Integer.class.isAssignableFrom(type)) {
                DiscreteRange[] rangeAnnotations = (DiscreteRange[])field.getDeclaredAnnotationsByType(DiscreteRange.class);
                if (rangeAnnotations.length > 0) {
                    DiscreteRange range = rangeAnnotations[0];
                    Optional<Option<Option>> optOption2 = BridgingConfigUI.createOption(field, option -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)option).range((Number)range.min(), (Number)range.max())).step((Number)1));
                    optOption2.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                    continue;
                }
                Optional<Option<Option>> optOption3 = BridgingConfigUI.createOption(field, IntegerFieldControllerBuilder::create);
                optOption3.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                continue;
            }
            if (Color.class.isAssignableFrom(type)) {
                optOption = BridgingConfigUI.createOption(field, opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(true));
                optOption.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                continue;
            }
            if (Enum.class.isAssignableFrom(type)) {
                optOption = BridgingConfigUI.createOption(field, opt -> EnumControllerBuilder.create((Option)opt).enumClass(type).formatValue(val -> {
                    MutableComponent mutableComponent;
                    if (val instanceof Translatable) {
                        Translatable translatable = (Translatable)val;
                        mutableComponent = Component.m_237115_((String)translatable.getTranslationKey());
                    } else {
                        mutableComponent = Component.m_237113_((String)((Enum)val).name());
                    }
                    return mutableComponent;
                }));
                optOption.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                continue;
            }
            BridgingMod.getLogger().warn("Skipped displaying config entry '%s' as its type has no display logic".formatted(field.getName()));
        }
        return category.build();
    }

    private static Map<String, List<Field>> sortConfigIntoCategories(Class<?> configClass) {
        Field[] fields = configClass.getDeclaredFields();
        LinkedHashMap<String, List<Field>> sortedCategories = new LinkedHashMap<String, List<Field>>(fields.length);
        for (Field field : fields) {
            String firstCatName;
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || ((HideInConfigUI[])field.getDeclaredAnnotationsByType(HideInConfigUI.class)).length > 0) continue;
            Category[] foundCategories = (Category[])field.getDeclaredAnnotationsByType(Category.class);
            String categoryName = foundCategories.length > 0 ? ((firstCatName = foundCategories[0].value()) == null ? DEFAULT_CATEGORY_NAME : firstCatName.trim().toLowerCase()) : DEFAULT_CATEGORY_NAME;
            if (!sortedCategories.containsKey(categoryName)) {
                sortedCategories.put(categoryName, new LinkedList());
            }
            ((List)sortedCategories.get(categoryName)).add(field);
        }
        return sortedCategories;
    }
}

